/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.ClipEntry;
import androidx.compose.ui.platform.ClipboardManager;
import androidx.compose.ui.platform.PlatformClipboardManager;
import androidx.compose.ui.text.AnnotatedString;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u001f\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/platform/PlatformClipboardManager;", "Landroidx/compose/ui/platform/ClipboardManager;", "()V", "nativeClipboard", "Ljava/awt/datatransfer/Clipboard;", "Landroidx/compose/ui/platform/NativeClipboard;", "getNativeClipboard", "()Ljava/awt/datatransfer/Clipboard;", "nativeClipboard$delegate", "Lkotlin/Lazy;", "systemClipboard", "getSystemClipboard$ui", "getClip", "Landroidx/compose/ui/platform/ClipEntry;", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "setClip", "", "clipEntry", "setText", "annotatedString", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformClipboardManager.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformClipboardManager.desktop.kt\nandroidx/compose/ui/platform/PlatformClipboardManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class PlatformClipboardManager
implements ClipboardManager {
    @Nullable
    private final Clipboard systemClipboard;
    @NotNull
    private final Lazy nativeClipboard$delegate;
    public static final int $stable = 8;

    public PlatformClipboardManager() {
        Clipboard clipboard;
        PlatformClipboardManager platformClipboardManager;
        PlatformClipboardManager platformClipboardManager2 = this;
        try {
            platformClipboardManager = platformClipboardManager2;
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            platformClipboardManager = platformClipboardManager2;
            clipboard = null;
        }
        platformClipboardManager.systemClipboard = clipboard;
        this.nativeClipboard$delegate = LazyKt.lazy((Function0)nativeClipboard.2.INSTANCE);
    }

    @Nullable
    public final Clipboard getSystemClipboard$ui() {
        return this.systemClipboard;
    }

    @Override
    @Nullable
    public AnnotatedString getText() {
        AnnotatedString annotatedString;
        Clipboard clipboard = this.systemClipboard;
        if (clipboard != null) {
            AnnotatedString annotatedString2;
            Clipboard it = clipboard;
            boolean bl = false;
            try {
                Object object = it.getData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                annotatedString2 = new AnnotatedString((String)object, null, null, 6, null);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                annotatedString2 = null;
            }
            annotatedString = annotatedString2;
        } else {
            annotatedString = null;
        }
        return annotatedString;
    }

    @Override
    public void setText(@NotNull AnnotatedString annotatedString) {
        block0: {
            Clipboard clipboard = this.systemClipboard;
            if (clipboard == null) break block0;
            clipboard.setContents(new StringSelection(annotatedString.getText()), null);
        }
    }

    @Override
    @Nullable
    public ClipEntry getClip() {
        ClipEntry clipEntry;
        try {
            ClipEntry clipEntry2;
            Object object = this.systemClipboard;
            if (object != null && (object = ((Clipboard)object).getContents(this)) != null) {
                Object p0 = object;
                boolean bl = false;
                clipEntry2 = new ClipEntry((Transferable)p0);
            } else {
                clipEntry2 = null;
            }
            clipEntry = clipEntry2;
        }
        catch (IllegalStateException illegalStateException) {
            clipEntry = null;
        }
        return clipEntry;
    }

    @Override
    public void setClip(@Nullable ClipEntry clipEntry) {
        block0: {
            Clipboard clipboard = this.systemClipboard;
            if (clipboard == null) break block0;
            ClipEntry clipEntry2 = clipEntry;
            clipboard.setContents(clipEntry2 != null ? clipEntry2.getTransferable$ui() : null, null);
        }
    }

    @Override
    @NotNull
    public Clipboard getNativeClipboard() {
        Lazy lazy = this.nativeClipboard$delegate;
        return (Clipboard)lazy.getValue();
    }
}

