/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.AndroidPath;
import androidx.compose.ui.graphics.AndroidPathIterator_androidKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.PathSegmentKt;
import androidx.graphics.path.PathIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0016H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0018\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Landroidx/compose/ui/graphics/AndroidPathIterator;", "Landroidx/compose/ui/graphics/PathIterator;", "path", "Landroidx/compose/ui/graphics/Path;", "conicEvaluation", "Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "tolerance", "", "(Landroidx/compose/ui/graphics/Path;Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;F)V", "getConicEvaluation", "()Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "implementation", "Landroidx/graphics/path/PathIterator;", "getPath", "()Landroidx/compose/ui/graphics/Path;", "segmentPoints", "", "getTolerance", "()F", "calculateSize", "", "includeConvertedConics", "", "hasNext", "next", "Landroidx/compose/ui/graphics/PathSegment;", "Landroidx/compose/ui/graphics/PathSegment$Type;", "points", "offset", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAndroidPathIterator.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPathIterator.android.kt\nandroidx/compose/ui/graphics/AndroidPathIterator\n+ 2 AndroidPath.android.kt\nandroidx/compose/ui/graphics/AndroidPath_androidKt\n*L\n1#1,86:1\n38#2,5:87\n*S KotlinDebug\n*F\n+ 1 AndroidPathIterator.android.kt\nandroidx/compose/ui/graphics/AndroidPathIterator\n*L\n37#1:87,5\n*E\n"})
public final class AndroidPathIterator
implements PathIterator {
    @NotNull
    private final Path path;
    @NotNull
    private final PathIterator.ConicEvaluation conicEvaluation;
    private final float tolerance;
    @NotNull
    private final float[] segmentPoints;
    @NotNull
    private final androidx.graphics.path.PathIterator implementation;

    public AndroidPathIterator(@NotNull Path path, @NotNull PathIterator.ConicEvaluation conicEvaluation, float tolerance) {
        PathIterator.ConicEvaluation conicEvaluation2;
        this.path = path;
        this.conicEvaluation = conicEvaluation;
        this.tolerance = tolerance;
        this.segmentPoints = new float[8];
        Path $this$asAndroidPath$iv = this.getPath();
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path2 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConicEvaluation().ordinal()]) {
            case 1: {
                conicEvaluation2 = PathIterator.ConicEvaluation.AsConic;
                break;
            }
            case 2: {
                conicEvaluation2 = PathIterator.ConicEvaluation.AsQuadratics;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.implementation = new androidx.graphics.path.PathIterator(path2, conicEvaluation2, this.getTolerance());
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public PathIterator.ConicEvaluation getConicEvaluation() {
        return this.conicEvaluation;
    }

    @Override
    public float getTolerance() {
        return this.tolerance;
    }

    @Override
    public int calculateSize(boolean includeConvertedConics) {
        return this.implementation.calculateSize(includeConvertedConics);
    }

    @Override
    public boolean hasNext() {
        return this.implementation.hasNext();
    }

    @Override
    @NotNull
    public PathSegment.Type next(@NotNull float[] points, int offset) {
        return AndroidPathIterator_androidKt.access$toPathSegmentType(this.implementation.next(points, offset));
    }

    @Override
    @NotNull
    public PathSegment next() {
        float[] fArray;
        float[] p = this.segmentPoints;
        PathSegment.Type type = AndroidPathIterator_androidKt.access$toPathSegmentType(this.implementation.next(p, 0));
        if (type == PathSegment.Type.Done) {
            return PathSegmentKt.getDoneSegment();
        }
        if (type == PathSegment.Type.Close) {
            return PathSegmentKt.getCloseSegment();
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                float[] fArray2 = new float[]{p[0], p[1]};
                fArray = fArray2;
                break;
            }
            case 2: {
                float[] fArray2 = new float[]{p[0], p[1], p[2], p[3]};
                fArray = fArray2;
                break;
            }
            case 3: {
                float[] fArray2 = new float[]{p[0], p[1], p[2], p[3], p[4], p[5]};
                fArray = fArray2;
                break;
            }
            case 4: {
                float[] fArray2 = new float[]{p[0], p[1], p[2], p[3], p[4], p[5]};
                fArray = fArray2;
                break;
            }
            case 5: {
                float[] fArray2 = new float[]{p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7]};
                fArray = fArray2;
                break;
            }
            default: {
                fArray = new float[]{};
            }
        }
        float[] points = fArray;
        return new PathSegment(type, points, type == PathSegment.Type.Conic ? p[6] : 0.0f);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PathIterator.ConicEvaluation.values().length];
            try {
                nArray[PathIterator.ConicEvaluation.AsConic.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathIterator.ConicEvaluation.AsQuadratics.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

