/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a8\u0006\u0006"}, d2={"computeDirection", "Landroidx/compose/ui/graphics/Path$Direction;", "Landroidx/compose/ui/graphics/Path;", "divide", "", "contours", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nPathGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathGeometry.kt\nandroidx/compose/ui/graphics/PathGeometryKt\n+ 2 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n1#1,252:1\n525#2:253\n*S KotlinDebug\n*F\n+ 1 PathGeometry.kt\nandroidx/compose/ui/graphics/PathGeometryKt\n*L\n141#1:253\n*E\n"})
public final class PathGeometryKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Path.Direction computeDirection(@NotNull Path $this$computeDirection) {
        Path.Direction direction;
        boolean first = true;
        PathIterator iterator2 = $this$computeDirection.iterator();
        float[] points = new float[8];
        float area = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        float endX = 0.0f;
        float endY = 0.0f;
        PathSegment.Type type = PathIterator.next$default(iterator2, points, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!first) break block9;
                    first = false;
                    startX = points[0];
                    startY = points[1];
                    break;
                }
                case 2: {
                    float x0 = points[0];
                    float y0 = points[1];
                    float x1 = points[2];
                    float y1 = points[3];
                    area += BezierKt.cubicArea(x0, y0, x0, y0, x1, y1, x1, y1);
                    endX = x1;
                    endY = y1;
                    break;
                }
                case 3: {
                    float x0 = points[0];
                    float y0 = points[1];
                    float x1 = points[2];
                    float y1 = points[3];
                    float x2 = points[4];
                    float y2 = points[5];
                    float c1x = x0 + 0.6666667f * (x1 - x0);
                    float c1y = y0 + 0.6666667f * (y1 - y0);
                    float c2x = x2 + 0.6666667f * (x1 - x2);
                    float c2y = y2 + 0.6666667f * (y1 - y2);
                    area += BezierKt.cubicArea(x0, y0, c1x, c1y, c2x, c2y, x2, y2);
                    endX = x2;
                    endY = y2;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    area += BezierKt.cubicArea(points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7]);
                    endX = points[6];
                    endY = points[7];
                    break;
                }
                case 6: {
                    float $this$closeTo$iv = endX;
                    boolean $i$f$closeTo = false;
                    if (Math.abs($this$closeTo$iv - startX) < 8.34465E-7f) {
                        $this$closeTo$iv = endY;
                        $i$f$closeTo = false;
                        if (Math.abs($this$closeTo$iv - startY) < 8.34465E-7f) break;
                    }
                    area += BezierKt.cubicArea(endX, endY, endX, endY, startX, startY, startX, startY);
                    endX = startX;
                    endY = startY;
                    break;
                }
                case 7: {
                    break block9;
                }
            }
            type = PathIterator.next$default(iterator2, points, 0, 2, null);
        }
        if (area >= 0.0f) {
            direction = Path.Direction.Clockwise;
            return direction;
        }
        direction = Path.Direction.CounterClockwise;
        return direction;
    }

    @NotNull
    public static final List<Path> divide(@NotNull Path $this$divide, @NotNull List<Path> contours) {
        Path path = AndroidPath_androidKt.Path();
        boolean first = true;
        boolean isEmpty = true;
        PathIterator iterator2 = $this$divide.iterator();
        float[] points = new float[8];
        PathSegment.Type type = PathIterator.next$default(iterator2, points, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!first && !isEmpty) {
                        contours.add(path);
                        path = AndroidPath_androidKt.Path();
                    }
                    first = false;
                    isEmpty = true;
                    path.moveTo(points[0], points[1]);
                    break;
                }
                case 2: {
                    path.lineTo(points[2], points[3]);
                    isEmpty = false;
                    break;
                }
                case 3: {
                    path.quadraticTo(points[2], points[3], points[4], points[5]);
                    isEmpty = false;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    path.cubicTo(points[2], points[3], points[4], points[5], points[6], points[7]);
                    isEmpty = false;
                    break;
                }
                case 6: {
                    path.close();
                    break;
                }
                case 7: {
                    continue block9;
                }
            }
            type = PathIterator.next$default(iterator2, points, 0, 2, null);
        }
        if (!first && !isEmpty) {
            contours.add(path);
        }
        return contours;
    }

    public static /* synthetic */ List divide$default(Path path, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        return PathGeometryKt.divide(path, list);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

