/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import android.media.ImageReader;
import android.os.Build;
import android.view.Surface;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.LockHardwareCanvasHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/graphics/layer/LayerManager;", "", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "(Landroidx/compose/ui/graphics/CanvasHolder;)V", "getCanvasHolder", "()Landroidx/compose/ui/graphics/CanvasHolder;", "imageReader", "Landroid/media/ImageReader;", "layerList", "Landroidx/collection/MutableObjectList;", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "destroy", "", "persist", "layer", "persistLayers", "layers", "Landroidx/collection/ObjectList;", "release", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nLayerManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 AndroidCanvas.android.kt\nandroidx/compose/ui/graphics/CanvasHolder\n+ 5 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,97:1\n1580#2:98\n1#3:99\n47#4,3:100\n50#4,2:109\n305#5,6:103\n*S KotlinDebug\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n*L\n36#1:98\n77#1:100,3\n77#1:109,2\n78#1:103,6\n*E\n"})
public final class LayerManager {
    @NotNull
    private final CanvasHolder canvasHolder;
    @NotNull
    private final MutableObjectList<GraphicsLayer> layerList;
    @Nullable
    private ImageReader imageReader;

    public LayerManager(@NotNull CanvasHolder canvasHolder) {
        this.canvasHolder = canvasHolder;
        boolean $i$f$mutableObjectListOf = false;
        this.layerList = new MutableObjectList(0, 1, null);
    }

    @NotNull
    public final CanvasHolder getCanvasHolder() {
        return this.canvasHolder;
    }

    public final void persist(@NotNull GraphicsLayer layer) {
        if (!this.layerList.contains((Object)layer)) {
            this.layerList.add((Object)layer);
            this.persistLayers((ObjectList<GraphicsLayer>)((ObjectList)this.layerList));
        }
    }

    public final void release(@NotNull GraphicsLayer layer) {
        if (this.layerList.remove((Object)layer)) {
            layer.discardDisplayList$ui_graphics_release();
        }
    }

    private final void persistLayers(ObjectList<GraphicsLayer> layers) {
        if (Build.VERSION.SDK_INT >= 23) {
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                ImageReader imageReader2;
                ImageReader it = imageReader2 = ImageReader.newInstance((int)1, (int)1, (int)1, (int)1);
                boolean bl = false;
                this.imageReader = it;
                imageReader = imageReader2;
            }
            ImageReader reader = imageReader;
            Surface surface = reader.getSurface();
            android.graphics.Canvas canvas = LockHardwareCanvasHelper.INSTANCE.lockHardwareCanvas(surface);
            CanvasHolder this_$iv = this.canvasHolder;
            boolean $i$f$drawInto = false;
            android.graphics.Canvas previousCanvas$iv = this_$iv.getAndroidCanvas().getInternalCanvas();
            this_$iv.getAndroidCanvas().setInternalCanvas(canvas);
            Canvas $this$persistLayers_u24lambda_u242 = this_$iv.getAndroidCanvas();
            boolean bl = false;
            ObjectList<GraphicsLayer> this_$iv2 = layers;
            boolean $i$f$forEach = false;
            Object[] content$iv = this_$iv2.content;
            int n = this_$iv2._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                GraphicsLayer layer = (GraphicsLayer)content$iv[i$iv];
                boolean bl2 = false;
                layer.draw$ui_graphics_release($this$persistLayers_u24lambda_u242, null);
            }
            this_$iv.getAndroidCanvas().setInternalCanvas(previousCanvas$iv);
            surface.unlockCanvasAndPost(canvas);
        }
    }

    public final void destroy() {
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        this.imageReader = null;
    }
}

