/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.LockHardwareCanvasHelper;
import androidx.core.os.HandlerCompat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/graphics/layer/LayerManager;", "", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "(Landroidx/compose/ui/graphics/CanvasHolder;)V", "getCanvasHolder", "()Landroidx/compose/ui/graphics/CanvasHolder;", "handler", "Landroid/os/Handler;", "imageReader", "Landroid/media/ImageReader;", "layerSet", "Landroidx/collection/MutableScatterSet;", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "destroy", "", "persist", "layer", "persistLayers", "layers", "Landroidx/collection/ScatterSet;", "release", "updateLayerPersistence", "Companion", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nLayerManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AndroidCanvas.android.kt\nandroidx/compose/ui/graphics/CanvasHolder\n+ 4 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 5 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,141:1\n1#2:142\n47#3,3:143\n50#3,2:173\n267#4,4:146\n237#4,7:150\n248#4,3:158\n251#4,2:162\n272#4,2:164\n254#4,6:166\n274#4:172\n1810#5:157\n1672#5:161\n*S KotlinDebug\n*F\n+ 1 LayerManager.android.kt\nandroidx/compose/ui/graphics/layer/LayerManager\n*L\n103#1:143,3\n103#1:173,2\n106#1:146,4\n106#1:150,7\n106#1:158,3\n106#1:162,2\n106#1:164,2\n106#1:166,6\n106#1:172\n106#1:157\n106#1:161\n*E\n"})
public final class LayerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CanvasHolder canvasHolder;
    @NotNull
    private final MutableScatterSet<GraphicsLayer> layerSet;
    @Nullable
    private ImageReader imageReader;
    @NotNull
    private final Handler handler;
    private static final boolean isRobolectric;

    public LayerManager(@NotNull CanvasHolder canvasHolder) {
        this.canvasHolder = canvasHolder;
        this.layerSet = ScatterSetKt.mutableScatterSetOf();
        this.handler = HandlerCompat.createAsync((Looper)Looper.getMainLooper(), arg_0 -> LayerManager.handler$lambda$0(this, arg_0));
    }

    @NotNull
    public final CanvasHolder getCanvasHolder() {
        return this.canvasHolder;
    }

    public final void persist(@NotNull GraphicsLayer layer) {
        this.layerSet.add((Object)layer);
        if (!this.handler.hasMessages(0)) {
            this.handler.sendMessageAtFrontOfQueue(Message.obtain());
        }
    }

    public final void release(@NotNull GraphicsLayer layer) {
        if (this.layerSet.remove((Object)layer)) {
            layer.discardDisplayList$ui_graphics_release();
        }
    }

    private final void persistLayers(ScatterSet<GraphicsLayer> layers) {
        boolean shouldPersistLayers;
        boolean requiredOsVersion = Build.VERSION.SDK_INT >= 23;
        boolean bl = shouldPersistLayers = requiredOsVersion && layers.isNotEmpty() && !isRobolectric;
        if (shouldPersistLayers) {
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                ImageReader imageReader2;
                ImageReader $this$persistLayers_u24lambda_u242 = imageReader2 = ImageReader.newInstance((int)1, (int)1, (int)1, (int)1);
                boolean bl2 = false;
                $this$persistLayers_u24lambda_u242.setOnImageAvailableListener(LayerManager::persistLayers$lambda$2$lambda$1, this.handler);
                ImageReader it = imageReader2;
                boolean bl3 = false;
                this.imageReader = it;
                imageReader = imageReader2;
            }
            ImageReader reader = imageReader;
            Surface surface = reader.getSurface();
            android.graphics.Canvas canvas = LockHardwareCanvasHelper.INSTANCE.lockHardwareCanvas(surface);
            CanvasHolder this_$iv = this.canvasHolder;
            boolean $i$f$drawInto = false;
            android.graphics.Canvas previousCanvas$iv = this_$iv.getAndroidCanvas().getInternalCanvas();
            this_$iv.getAndroidCanvas().setInternalCanvas(canvas);
            Canvas $this$persistLayers_u24lambda_u245 = this_$iv.getAndroidCanvas();
            boolean bl4 = false;
            canvas.save();
            canvas.clipRect(0, 0, 1, 1);
            ScatterSet<GraphicsLayer> this_$iv2 = layers;
            boolean $i$f$forEach = false;
            Object[] k$iv = this_$iv2.elements;
            ScatterSet<GraphicsLayer> this_$iv$iv = this_$iv2;
            boolean $i$f$forEachIndex = false;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            int i$iv$iv = 0;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl5 = false;
                                GraphicsLayer layer = (GraphicsLayer)k$iv[index$iv];
                                boolean bl6 = false;
                                layer.drawForPersistence$ui_graphics_release($this$persistLayers_u24lambda_u245);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
            canvas.restore();
            this_$iv.getAndroidCanvas().setInternalCanvas(previousCanvas$iv);
            surface.unlockCanvasAndPost(canvas);
        }
    }

    public final void destroy() {
        ImageReader imageReader = this.imageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        this.imageReader = null;
    }

    public final void updateLayerPersistence() {
        this.destroy();
        this.persistLayers((ScatterSet<GraphicsLayer>)((ScatterSet)this.layerSet));
    }

    private static final boolean handler$lambda$0(LayerManager this$0, Message it) {
        this$0.persistLayers((ScatterSet<GraphicsLayer>)((ScatterSet)this$0.layerSet));
        return true;
    }

    private static final void persistLayers$lambda$2$lambda$1(ImageReader it) {
        block0: {
            ImageReader imageReader = it;
            if (imageReader == null || (imageReader = imageReader.acquireLatestImage()) == null) break block0;
            imageReader.close();
        }
    }

    static {
        String string = Build.FINGERPRINT.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        isRobolectric = Intrinsics.areEqual((Object)string, (Object)"robolectric");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/graphics/layer/LayerManager$Companion;", "", "()V", "isRobolectric", "", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

