/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.annotation.FloatRange;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTree;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.PathHitTesterKt;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0003\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/graphics/PathHitTester;", "", "()V", "bounds", "Landroidx/compose/ui/geometry/Rect;", "curves", "", "intervals", "Landroidx/compose/ui/graphics/IntervalTree;", "Landroidx/compose/ui/graphics/PathSegment;", "path", "Landroidx/compose/ui/graphics/Path;", "roots", "tolerance", "", "contains", "", "position", "Landroidx/compose/ui/geometry/Offset;", "contains-k-4lQ0M", "(J)Z", "updatePath", "", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nPathHitTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathHitTester.kt\nandroidx/compose/ui/graphics/PathHitTester\n+ 2 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 3 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 IntervalTree.kt\nandroidx/compose/ui/graphics/IntervalTree\n*L\n1#1,163:1\n67#2:164\n81#2:166\n22#3:165\n71#4:167\n65#4:168\n73#4:171\n69#4:172\n60#5:169\n70#5:173\n22#6:170\n22#6:174\n152#7,17:175\n*S KotlinDebug\n*F\n+ 1 PathHitTester.kt\nandroidx/compose/ui/graphics/PathHitTester\n*L\n100#1:164\n100#1:166\n100#1:165\n122#1:167\n122#1:168\n125#1:171\n125#1:172\n122#1:169\n125#1:173\n122#1:170\n125#1:174\n131#1:175,17\n*E\n"})
public final class PathHitTester {
    @NotNull
    private Path path = PathHitTesterKt.access$getEmptyPath$p();
    private float tolerance = 0.5f;
    @NotNull
    private Rect bounds = Rect.Companion.getZero();
    @NotNull
    private final IntervalTree<PathSegment> intervals = new IntervalTree();
    @NotNull
    private final float[] curves = new float[20];
    @NotNull
    private final float[] roots = new float[2];

    public final void updatePath(@NotNull Path path, @FloatRange(from=0.0) float tolerance) {
        PathIterator iterator2;
        this.path = path;
        this.tolerance = tolerance;
        this.bounds = path.getBounds();
        this.intervals.clear();
        PathIterator pathIterator = iterator2 = path.iterator(PathIterator.ConicEvaluation.AsQuadratics, tolerance);
        block4: while (((Iterator)pathIterator).hasNext()) {
            PathSegment segment = pathIterator.next();
            switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    long l = BezierKt.computeVerticalBounds$default(segment, this.curves, 0, 4, null);
                    boolean bl = false;
                    int bits$iv$iv = (int)(l >> 32);
                    boolean $i$f$floatFromBits = false;
                    float min = Float.intBitsToFloat(bits$iv$iv);
                    boolean bl2 = false;
                    int bits$iv$iv2 = (int)(l & 0xFFFFFFFFL);
                    boolean $i$f$floatFromBits2 = false;
                    float max = Float.intBitsToFloat(bits$iv$iv2);
                    this.intervals.addInterval(min, max, segment);
                    continue block4;
                }
                case 4: {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    public static /* synthetic */ void updatePath$default(PathHitTester pathHitTester, Path path, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.5f;
        }
        pathHitTester.updatePath(path, f);
    }

    public final boolean contains-k-4lQ0M(long position) {
        boolean isInverse = false;
        if (this.path.isEmpty() || !this.bounds.contains-k-4lQ0M(position)) {
            return isInverse;
        }
        boolean bl = false;
        boolean bl2 = false;
        long value$iv$iv$iv = position;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float x = Float.intBitsToFloat(bits$iv$iv$iv$iv);
        boolean bl3 = false;
        boolean bl4 = false;
        long value$iv$iv$iv2 = position;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv$iv2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y = Float.intBitsToFloat(bits$iv$iv$iv$iv2);
        float[] curvesArray = this.curves;
        float[] rootsArray = this.roots;
        int winding = 0;
        IntervalTree<PathSegment> $this$iv = this.intervals;
        float end$iv = y;
        boolean $i$f$forEach$ui_graphics_release = false;
        if ($this$iv.root != $this$iv.terminator) {
            ArrayList<IntervalTree.Node> s$iv = $this$iv.stack;
            s$iv.add($this$iv.root);
            while (s$iv.size() > 0) {
                IntervalTree.Node node$iv = s$iv.remove(s$iv.size() - 1);
                if (node$iv.overlaps(y, end$iv)) {
                    Interval interval = node$iv;
                    boolean bl5 = false;
                    Object t = interval.getData();
                    Intrinsics.checkNotNull(t);
                    PathSegment segment = (PathSegment)t;
                    float[] points = segment.getPoints();
                    switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
                        case 1: {
                            winding += BezierKt.lineWinding(points, x, y);
                            break;
                        }
                        case 2: {
                            winding += BezierKt.quadraticWinding(points, x, y, curvesArray, rootsArray);
                            break;
                        }
                        case 3: {
                            winding += BezierKt.cubicWinding(points, x, y, curvesArray, rootsArray);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                        }
                    }
                }
                if (node$iv.getLeft() != $this$iv.terminator && node$iv.getLeft().getMax() >= y) {
                    s$iv.add(node$iv.getLeft());
                }
                if (node$iv.getRight() == $this$iv.terminator || !(node$iv.getRight().getMin() <= end$iv)) continue;
                s$iv.add(node$iv.getRight());
            }
            s$iv.clear();
        }
        boolean isEvenOdd = PathFillType.equals-impl0(this.path.getFillType-Rg-k1Os(), PathFillType.Companion.getEvenOdd-Rg-k1Os());
        if (isEvenOdd) {
            winding &= 1;
        }
        return winding != 0;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

