/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.layer.SurfaceVerificationHelper;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\n\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/graphics/layer/SurfaceUtils;", "", "()V", "hasRetrievedMethod", "", "lockHardwareCanvasMethod", "Ljava/lang/reflect/Method;", "isLockHardwareCanvasAvailable", "lockCanvas", "Landroid/graphics/Canvas;", "surface", "Landroid/view/Surface;", "lockCanvasFallback", "resolveLockHardwareCanvasMethod", "ui-graphics_release"})
public final class SurfaceUtils {
    @NotNull
    public static final SurfaceUtils INSTANCE = new SurfaceUtils();
    @Nullable
    private static Method lockHardwareCanvasMethod;
    private static boolean hasRetrievedMethod;

    private SurfaceUtils() {
    }

    @RequiresApi(value=22)
    @NotNull
    public final Canvas lockCanvas(@NotNull Surface surface) {
        return Build.VERSION.SDK_INT >= 23 ? SurfaceVerificationHelper.INSTANCE.lockHardwareCanvas(surface) : this.lockCanvasFallback(surface);
    }

    public final boolean isLockHardwareCanvasAvailable() {
        return Build.VERSION.SDK_INT >= 23 ? true : (Build.VERSION.SDK_INT == 22 ? this.resolveLockHardwareCanvasMethod() != null : false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"BanUncheckedReflection"})
    private final Method resolveLockHardwareCanvasMethod() {
        SurfaceUtils surfaceUtils = this;
        synchronized (surfaceUtils) {
            Method method;
            boolean bl = false;
            try {
                Method method2 = lockHardwareCanvasMethod;
                if (!hasRetrievedMethod) {
                    Method method3;
                    hasRetrievedMethod = true;
                    Method it = method3 = Surface.class.getDeclaredMethod("lockHardwareCanvas", new Class[0]);
                    boolean bl2 = false;
                    it.setAccessible(true);
                    lockHardwareCanvasMethod = it;
                    method2 = method3;
                }
            }
            catch (Throwable _) {
                lockHardwareCanvasMethod = null;
                method = null;
            }
            Method method4 = method;
            return method4;
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private final Canvas lockCanvasFallback(Surface surface) {
        Canvas canvas;
        Method method = this.resolveLockHardwareCanvasMethod();
        if (method != null) {
            Object object = method.invoke((Object)surface, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.graphics.Canvas");
            canvas = (Canvas)object;
        } else {
            canvas = surface.lockCanvas(null);
        }
        return canvas;
    }
}

