/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.vector.FastFloatParserKt;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathNodeKt;
import androidx.compose.ui.graphics.vector.PathParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\bJ\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011J\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0011\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000fH\u0082\bJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011J\u0010\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/ui/graphics/vector/PathParser;", "", "()V", "nodeData", "", "nodes", "Ljava/util/ArrayList;", "Landroidx/compose/ui/graphics/vector/PathNode;", "Lkotlin/collections/ArrayList;", "addNodes", "", "cmd", "", "args", "count", "", "addPathNodes", "", "clear", "parsePathString", "pathData", "", "resizeNodeData", "dataCount", "toNodes", "toPath", "Landroidx/compose/ui/graphics/Path;", "target", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n+ 2 FastFloatParser.kt\nandroidx/compose/ui/graphics/vector/FastFloatParserKt\n+ 3 JvmFastFloatParser.jvm.kt\nandroidx/compose/ui/graphics/vector/JvmFastFloatParser_jvmKt\n*L\n1#1,555:1\n132#1,6:559\n150#1,2:565\n49#2:556\n50#2:557\n22#3:558\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n*L\n115#1:559,6\n123#1:565,2\n109#1:556\n110#1:557\n110#1:558\n*E\n"})
public final class PathParser {
    @NotNull
    private final ArrayList<PathNode> nodes = new ArrayList();
    @NotNull
    private float[] nodeData = new float[64];

    public final void clear() {
        this.nodes.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathParser parsePathString(@NotNull String pathData) {
        int start;
        this.nodes.clear();
        int end = pathData.length();
        int dataCount = 0;
        for (start = 0; start < end && Intrinsics.compare((int)pathData.charAt(start), (int)32) <= 0; ++start) {
        }
        while (end > start && Intrinsics.compare((int)pathData.charAt(end - 1), (int)32) <= 0) {
            --end;
        }
        int index = start;
        while (index < end) {
            void this_$iv;
            char c = '\u0000';
            char command = '\u0000';
            do {
                int lowerChar;
                if (((lowerChar = (c = pathData.charAt(index++)) | 0x20) - 97) * (lowerChar - 122) > 0 || lowerChar == 101) continue;
                command = c;
                break;
            } while (index < end);
            if (command == '\u0000') continue;
            if ((command | 0x20) != 122) {
                dataCount = 0;
                while (true) {
                    long result;
                    if (index < end && Intrinsics.compare((int)pathData.charAt(index), (int)32) <= 0) {
                        ++index;
                        continue;
                    }
                    long $this$index$iv = result = FastFloatParserKt.nextFloat(pathData, index, end);
                    boolean $i$f$getIndex = false;
                    index = (int)($this$index$iv >>> 32);
                    long $this$floatValue$iv = result;
                    boolean $i$f$getFloatValue = false;
                    int bits$iv$iv = (int)($this$floatValue$iv & 0xFFFFFFFFL);
                    boolean $i$f$floatFromBits = false;
                    float value = Float.intBitsToFloat(bits$iv$iv);
                    if (!Float.isNaN(value)) {
                        this.nodeData[dataCount++] = value;
                        PathParser this_$iv2 = this;
                        boolean $i$f$resizeNodeData = false;
                        if (dataCount >= this_$iv2.nodeData.length) {
                            float[] src$iv = this_$iv2.nodeData;
                            this_$iv2.nodeData = new float[dataCount * 2];
                            ArraysKt.copyInto((float[])src$iv, (float[])this_$iv2.nodeData, (int)0, (int)0, (int)src$iv.length);
                        }
                    }
                    while (index < end && pathData.charAt(index) == ',') {
                        ++index;
                    }
                    if (index >= end || Float.isNaN(value)) break;
                }
            }
            PathParser result = this;
            float[] args$iv = this.nodeData;
            boolean $i$f$addNodes = false;
            PathNodeKt.addPathNodes(command, this_$iv.nodes, args$iv, dataCount);
        }
        return this;
    }

    private final void resizeNodeData(int dataCount) {
        boolean $i$f$resizeNodeData = false;
        if (dataCount >= this.nodeData.length) {
            float[] src = this.nodeData;
            this.nodeData = new float[dataCount * 2];
            ArraysKt.copyInto((float[])src, (float[])this.nodeData, (int)0, (int)0, (int)src.length);
        }
    }

    @NotNull
    public final PathParser addPathNodes(@NotNull List<? extends PathNode> nodes) {
        this.nodes.addAll((Collection<PathNode>)nodes);
        return this;
    }

    @NotNull
    public final List<PathNode> toNodes() {
        return this.nodes;
    }

    @NotNull
    public final Path toPath(@NotNull Path target) {
        return PathParserKt.toPath((List<? extends PathNode>)this.nodes, target);
    }

    public static /* synthetic */ Path toPath$default(PathParser pathParser, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = SkiaBackedPath_skikoKt.Path();
        }
        return pathParser.toPath(path);
    }

    private final void addNodes(char cmd, float[] args, int count) {
        boolean $i$f$addNodes = false;
        PathNodeKt.addPathNodes(cmd, this.nodes, args, count);
    }
}

