/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.ui.graphics.AndroidImageAssetKt;
import androidx.ui.graphics.ImageAsset;
import androidx.ui.graphics.ImageAssetConfig;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaces;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J@\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\""}, d2={"Landroidx/ui/graphics/AndroidImageAsset;", "Landroidx/ui/graphics/ImageAsset;", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "getBitmap$ui_graphics_release", "()Landroid/graphics/Bitmap;", "colorSpace", "Landroidx/ui/graphics/colorspace/ColorSpace;", "getColorSpace", "()Landroidx/ui/graphics/colorspace/ColorSpace;", "config", "Landroidx/ui/graphics/ImageAssetConfig;", "getConfig", "()Landroidx/ui/graphics/ImageAssetConfig;", "hasAlpha", "", "getHasAlpha", "()Z", "height", "", "getHeight", "()I", "width", "getWidth", "prepareToDraw", "", "readPixels", "buffer", "", "startX", "startY", "bufferOffset", "stride", "ui-graphics_release"})
public final class AndroidImageAsset
implements ImageAsset {
    @NotNull
    private final Bitmap bitmap;

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    @NotNull
    public ImageAssetConfig getConfig() {
        Bitmap.Config config = this.bitmap.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"bitmap.config");
        return AndroidImageAssetKt.toImageConfig(config);
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        ColorSpace colorSpace;
        if (Build.VERSION.SDK_INT >= 26) {
            colorSpace = this.bitmap.getColorSpace();
            if (colorSpace == null || (colorSpace = AndroidImageAssetKt.toComposeColorSpace((android.graphics.ColorSpace)colorSpace)) == null) {
                colorSpace = ColorSpaces.INSTANCE.getSrgb();
            }
        } else {
            colorSpace = ColorSpaces.INSTANCE.getSrgb();
        }
        return colorSpace;
    }

    @Override
    public void readPixels(@NotNull int[] buffer, int startX, int startY, int width, int height, int bufferOffset, int stride) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Bitmap androidBitmap = AndroidImageAssetKt.asAndroidBitmap(this);
        boolean recycleTarget = false;
        if (Build.VERSION.SDK_INT < 26 || androidBitmap.getConfig() != Bitmap.Config.HARDWARE) {
            bitmap = androidBitmap;
        } else {
            recycleTarget = true;
            bitmap = androidBitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        Bitmap targetBitmap = bitmap;
        targetBitmap.getPixels(buffer, bufferOffset, stride, startX, startY, width, height);
        if (recycleTarget) {
            targetBitmap.recycle();
        }
    }

    @Override
    public boolean getHasAlpha() {
        return this.bitmap.hasAlpha();
    }

    @Override
    public void prepareToDraw() {
        this.bitmap.prepareToDraw();
    }

    @NotNull
    public final Bitmap getBitmap$ui_graphics_release() {
        return this.bitmap;
    }

    public AndroidImageAsset(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.bitmap = bitmap;
    }
}

