/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import androidx.ui.graphics.AndroidBlendModeKt;
import androidx.ui.graphics.AndroidPaintKt$WhenMappings;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.ColorFilter;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.FilterQuality;
import androidx.ui.graphics.PaintingStyle;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u0003*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b*\u00060\u0001j\u0002`\u0004H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u000b*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\f\u001a\u00020\r*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u0003*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u0003*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u0013*\u00060\u0001j\u0002`\u0004H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0019H\u0000\u001a\"\u0010\u001a\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\bH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001a\u0010\u001d\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u001eH\u0000\u001a\u0018\u0010\u001f\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u001a \u0010 \u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u000e\u0010\u0016\u001a\n\u0018\u00010!j\u0004\u0018\u0001`\"H\u0000\u001a \u0010#\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u000e\u0010\u0016\u001a\n\u0018\u00010$j\u0004\u0018\u0001`%H\u0000\u001a\u0018\u0010&\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\rH\u0000\u001a\u0018\u0010'\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0018\u0010(\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u001a\u0018\u0010)\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u001a\u0018\u0010*\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00042\u0006\u0010\u0016\u001a\u00020\u0013H\u0000*\n\u0010+\"\u00020\u00012\u00020\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"makeNativePaint", "Landroid/graphics/Paint;", "getNativeAlpha", "", "Landroidx/ui/graphics/NativePaint;", "getNativeAntiAlias", "", "getNativeColor", "Landroidx/ui/graphics/Color;", "(Landroid/graphics/Paint;)J", "getNativeFilterQuality", "Landroidx/ui/graphics/FilterQuality;", "getNativeStrokeCap", "Landroidx/ui/graphics/StrokeCap;", "getNativeStrokeJoin", "Landroidx/ui/graphics/StrokeJoin;", "getNativeStrokeMiterLimit", "getNativeStrokeWidth", "getNativeStyle", "Landroidx/ui/graphics/PaintingStyle;", "setNativeAlpha", "", "value", "setNativeAntiAlias", "setNativeBlendMode", "Landroidx/ui/graphics/BlendMode;", "setNativeColor", "setNativeColor-6CSLprE", "(Landroid/graphics/Paint;J)V", "setNativeColorFilter", "Landroidx/ui/graphics/ColorFilter;", "setNativeFilterQuality", "setNativePathEffect", "Landroid/graphics/PathEffect;", "Landroidx/ui/graphics/NativePathEffect;", "setNativeShader", "Landroid/graphics/Shader;", "Landroidx/ui/graphics/Shader;", "setNativeStrokeCap", "setNativeStrokeJoin", "setNativeStrokeMiterLimit", "setNativeStrokeWidth", "setNativeStyle", "NativePaint", "ui-graphics_release"})
public final class AndroidPaintKt {
    @NotNull
    public static final Paint makeNativePaint() {
        return new Paint(1);
    }

    public static final void setNativeBlendMode(@NotNull Paint $this$setNativeBlendMode, @NotNull BlendMode value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeBlendMode, (String)"$this$setNativeBlendMode");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        $this$setNativeBlendMode.setXfermode((Xfermode)new PorterDuffXfermode(AndroidBlendModeKt.toPorterDuffMode(value)));
    }

    public static final void setNativeColorFilter(@NotNull Paint $this$setNativeColorFilter, @Nullable ColorFilter value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeColorFilter, (String)"$this$setNativeColorFilter");
        if (value != null) {
            $this$setNativeColorFilter.setColorFilter((android.graphics.ColorFilter)new PorterDuffColorFilter(ColorKt.toArgb-QEYXlZo(value.getColor-CJRZkaY()), AndroidBlendModeKt.toPorterDuffMode(value.getBlendMode())));
        } else {
            $this$setNativeColorFilter.setColorFilter((android.graphics.ColorFilter)null);
        }
    }

    public static final float getNativeAlpha(@NotNull Paint $this$getNativeAlpha) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeAlpha, (String)"$this$getNativeAlpha");
        return (float)$this$getNativeAlpha.getAlpha() / 255.0f;
    }

    public static final void setNativeAlpha(@NotNull Paint $this$setNativeAlpha, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeAlpha, (String)"$this$setNativeAlpha");
        float f = value * 255.0f;
        boolean bl = false;
        $this$setNativeAlpha.setAlpha((int)Math.rint(f));
    }

    public static final boolean getNativeAntiAlias(@NotNull Paint $this$getNativeAntiAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeAntiAlias, (String)"$this$getNativeAntiAlias");
        return $this$getNativeAntiAlias.isAntiAlias();
    }

    public static final void setNativeAntiAlias(@NotNull Paint $this$setNativeAntiAlias, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeAntiAlias, (String)"$this$setNativeAntiAlias");
        $this$setNativeAntiAlias.setAntiAlias(value);
    }

    public static final long getNativeColor(@NotNull Paint $this$getNativeColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeColor, (String)"$this$getNativeColor");
        return ColorKt.Color($this$getNativeColor.getColor());
    }

    public static final void setNativeColor-6CSLprE(@NotNull Paint $this$setNativeColor, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeColor, (String)"$this$setNativeColor");
        $this$setNativeColor.setColor(ColorKt.toArgb-QEYXlZo(value));
    }

    public static final void setNativeStyle(@NotNull Paint $this$setNativeStyle, @NotNull PaintingStyle value) {
        Paint.Style style;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStyle, (String)"$this$setNativeStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
            case 1: {
                style = Paint.Style.STROKE;
                break;
            }
            default: {
                style = Paint.Style.FILL;
            }
        }
        $this$setNativeStyle.setStyle(style);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final PaintingStyle getNativeStyle(@NotNull Paint $this$getNativeStyle) {
        PaintingStyle paintingStyle;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStyle, (String)"$this$getNativeStyle");
        Paint.Style style = $this$getNativeStyle.getStyle();
        if (style != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
                case 1: {
                    paintingStyle = PaintingStyle.stroke;
                    return paintingStyle;
                }
            }
        }
        paintingStyle = PaintingStyle.fill;
        return paintingStyle;
    }

    public static final float getNativeStrokeWidth(@NotNull Paint $this$getNativeStrokeWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeWidth, (String)"$this$getNativeStrokeWidth");
        return $this$getNativeStrokeWidth.getStrokeWidth();
    }

    public static final void setNativeStrokeWidth(@NotNull Paint $this$setNativeStrokeWidth, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeWidth, (String)"$this$setNativeStrokeWidth");
        $this$setNativeStrokeWidth.setStrokeWidth(value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final StrokeCap getNativeStrokeCap(@NotNull Paint $this$getNativeStrokeCap) {
        StrokeCap strokeCap;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeCap, (String)"$this$getNativeStrokeCap");
        Paint.Cap cap = $this$getNativeStrokeCap.getStrokeCap();
        if (cap != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$2[cap.ordinal()]) {
                case 1: {
                    strokeCap = StrokeCap.butt;
                    return strokeCap;
                }
                case 2: {
                    strokeCap = StrokeCap.round;
                    return strokeCap;
                }
                case 3: {
                    strokeCap = StrokeCap.square;
                    return strokeCap;
                }
            }
        }
        strokeCap = StrokeCap.butt;
        return strokeCap;
    }

    public static final void setNativeStrokeCap(@NotNull Paint $this$setNativeStrokeCap, @NotNull StrokeCap value) {
        Paint.Cap cap;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeCap, (String)"$this$setNativeStrokeCap");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$3[value.ordinal()]) {
            case 1: {
                cap = Paint.Cap.SQUARE;
                break;
            }
            case 2: {
                cap = Paint.Cap.ROUND;
                break;
            }
            case 3: {
                cap = Paint.Cap.BUTT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$setNativeStrokeCap.setStrokeCap(cap);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final StrokeJoin getNativeStrokeJoin(@NotNull Paint $this$getNativeStrokeJoin) {
        StrokeJoin strokeJoin;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeJoin, (String)"$this$getNativeStrokeJoin");
        Paint.Join join = $this$getNativeStrokeJoin.getStrokeJoin();
        if (join != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$4[join.ordinal()]) {
                case 1: {
                    strokeJoin = StrokeJoin.miter;
                    return strokeJoin;
                }
                case 2: {
                    strokeJoin = StrokeJoin.bevel;
                    return strokeJoin;
                }
                case 3: {
                    strokeJoin = StrokeJoin.round;
                    return strokeJoin;
                }
            }
        }
        strokeJoin = StrokeJoin.miter;
        return strokeJoin;
    }

    public static final void setNativeStrokeJoin(@NotNull Paint $this$setNativeStrokeJoin, @NotNull StrokeJoin value) {
        Paint.Join join;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeJoin, (String)"$this$setNativeStrokeJoin");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$5[value.ordinal()]) {
            case 1: {
                join = Paint.Join.MITER;
                break;
            }
            case 2: {
                join = Paint.Join.BEVEL;
                break;
            }
            case 3: {
                join = Paint.Join.ROUND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$setNativeStrokeJoin.setStrokeJoin(join);
    }

    public static final float getNativeStrokeMiterLimit(@NotNull Paint $this$getNativeStrokeMiterLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeMiterLimit, (String)"$this$getNativeStrokeMiterLimit");
        return $this$getNativeStrokeMiterLimit.getStrokeMiter();
    }

    public static final void setNativeStrokeMiterLimit(@NotNull Paint $this$setNativeStrokeMiterLimit, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeMiterLimit, (String)"$this$setNativeStrokeMiterLimit");
        $this$setNativeStrokeMiterLimit.setStrokeMiter(value);
    }

    @NotNull
    public static final FilterQuality getNativeFilterQuality(@NotNull Paint $this$getNativeFilterQuality) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeFilterQuality, (String)"$this$getNativeFilterQuality");
        return !$this$getNativeFilterQuality.isFilterBitmap() ? FilterQuality.none : FilterQuality.low;
    }

    public static final void setNativeFilterQuality(@NotNull Paint $this$setNativeFilterQuality, @NotNull FilterQuality value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeFilterQuality, (String)"$this$setNativeFilterQuality");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        $this$setNativeFilterQuality.setFilterBitmap(value != FilterQuality.none);
    }

    public static final void setNativeShader(@NotNull Paint $this$setNativeShader, @Nullable Shader value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeShader, (String)"$this$setNativeShader");
        $this$setNativeShader.setShader(value);
    }

    public static final void setNativePathEffect(@NotNull Paint $this$setNativePathEffect, @Nullable PathEffect value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativePathEffect, (String)"$this$setNativePathEffect");
        $this$setNativePathEffect.setPathEffect(value);
    }
}

