/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.BitmapShader;
import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.AndroidImageAssetKt;
import androidx.compose.ui.graphics.AndroidTileModeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.ImageAsset;
import androidx.compose.ui.graphics.TileMode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001aL\u0010\b\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001aL\u0010\u0014\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a)\u0010\u0019\u001a\u00020\u001a2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002\u00f8\u0001\u0000\u001a\u0015\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00f8\u0001\u0000*\n\u0010\u001d\"\u00020\u00012\u00020\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"ActualImageShader", "Landroid/graphics/Shader;", "Landroidx/compose/ui/graphics/Shader;", "image", "Landroidx/compose/ui/graphics/ImageAsset;", "tileModeX", "Landroidx/compose/ui/graphics/TileMode;", "tileModeY", "ActualLinearGradientShader", "from", "Landroidx/compose/ui/geometry/Offset;", "to", "colors", "", "Landroidx/compose/ui/graphics/Color;", "colorStops", "", "tileMode", "ActualLinearGradientShader-GfyHbQM", "(JJLjava/util/List;Ljava/util/List;Landroidx/compose/ui/graphics/TileMode;)Landroid/graphics/Shader;", "ActualRadialGradientShader", "center", "radius", "ActualRadialGradientShader-cY6o93o", "(JFLjava/util/List;Ljava/util/List;Landroidx/compose/ui/graphics/TileMode;)Landroid/graphics/Shader;", "validateColorStops", "", "toIntArray", "", "Shader", "ui-graphics_release"})
public final class AndroidShaderKt {
    @NotNull
    public static final Shader ActualLinearGradientShader-GfyHbQM(long from, long to, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        AndroidShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return (Shader)new LinearGradient(Offset.getX-impl((long)from), Offset.getY-impl((long)from), Offset.getX-impl((long)to), Offset.getY-impl((long)to), AndroidShaderKt.toIntArray(colors), (float[])(list != null ? CollectionsKt.toFloatArray((Collection)list) : null), AndroidTileModeKt.toNativeTileMode(tileMode));
    }

    @NotNull
    public static final Shader ActualRadialGradientShader-cY6o93o(long center, float radius, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        AndroidShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return (Shader)new RadialGradient(Offset.getX-impl((long)center), Offset.getY-impl((long)center), radius, AndroidShaderKt.toIntArray(colors), (float[])(list != null ? CollectionsKt.toFloatArray((Collection)list) : null), AndroidTileModeKt.toNativeTileMode(tileMode));
    }

    @NotNull
    public static final Shader ActualImageShader(@NotNull ImageAsset image, @NotNull TileMode tileModeX, @NotNull TileMode tileModeY) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeX), (String)"tileModeX");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeY), (String)"tileModeY");
        return (Shader)new BitmapShader(AndroidImageAssetKt.asAndroidBitmap(image), AndroidTileModeKt.toNativeTileMode(tileModeX), AndroidTileModeKt.toNativeTileMode(tileModeY));
    }

    /*
     * WARNING - void declaration
     */
    private static final int[] toIntArray(List<Color> $this$toIntArray) {
        int n = $this$toIntArray.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n5] = n3 = ColorKt.toArgb-8_81llA($this$toIntArray.get((int)i).unbox-impl());
        }
        return nArray;
    }

    private static final void validateColorStops(List<Color> colors, List<Float> colorStops) {
        if (colorStops == null) {
            if (colors.size() < 2) {
                throw (Throwable)new IllegalArgumentException("colors must have length of at least 2 if colorStops is omitted.");
            }
        } else if (colors.size() != colorStops.size()) {
            throw (Throwable)new IllegalArgumentException("colors and colorStops arguments must have equal length.");
        }
    }
}

