/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\b'\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0007J\u0012\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001e\u001a\u00020\u0019H'J\u0012\u0010\u001f\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020\bH&J\u0012\u0010!\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020\bH&J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J \u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001bH\u0007J\u0012\u0010$\u001a\u00020\u00192\b\b\u0001\u0010\u001e\u001a\u00020\u0019H'R\u0011\u0010\n\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "name", "", "model", "Landroidx/compose/ui/graphics/colorspace/ColorModel;", "(Ljava/lang/String;Landroidx/compose/ui/graphics/colorspace/ColorModel;)V", "id", "", "(Ljava/lang/String;Landroidx/compose/ui/graphics/colorspace/ColorModel;I)V", "componentCount", "getComponentCount", "()I", "getId$ui_graphics_release", "isSrgb", "", "()Z", "isWideGamut", "getModel", "()Landroidx/compose/ui/graphics/colorspace/ColorModel;", "getName", "()Ljava/lang/String;", "equals", "other", "fromXyz", "", "x", "", "y", "z", "v", "getMaxValue", "component", "getMinValue", "hashCode", "toString", "toXyz", "r", "g", "b", "Companion", "ui-graphics_release"})
public abstract class ColorSpace {
    @NotNull
    private final String name;
    @NotNull
    private final ColorModel model;
    private final int id;
    public static final int MinId = -1;
    public static final int MaxId = 63;
    public static final Companion Companion = new Companion(null);

    @IntRange(from=1L, to=4L)
    public final int getComponentCount() {
        return this.model.getComponentCount();
    }

    public abstract boolean isWideGamut();

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(@IntRange(from=0L, to=3L) int var1);

    public abstract float getMaxValue(@IntRange(from=0L, to=3L) int var1);

    @Size(value=3L)
    @NotNull
    public final float[] toXyz(float r, float g, float b) {
        return this.toXyz(new float[]{r, g, b});
    }

    @Size(min=3L)
    @NotNull
    public abstract float[] toXyz(@Size(min=3L) @NotNull float[] var1);

    @Size(min=3L)
    @NotNull
    public final float[] fromXyz(float x, float y, float z) {
        float[] xyz = new float[this.model.getComponentCount()];
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return this.fromXyz(xyz);
    }

    @Size(min=3L)
    @NotNull
    public abstract float[] fromXyz(@Size(min=3L) @NotNull float[] var1);

    @NotNull
    public String toString() {
        return this.name + " (id=" + this.id + ", model=" + (Object)((Object)this.model) + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
            return false;
        }
        ColorSpace that = (ColorSpace)other;
        if (this.id != that.id) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)that.name) ^ true ? false : this.model == that.model;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.model.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ColorModel getModel() {
        return this.model;
    }

    public final int getId$ui_graphics_release() {
        return this.id;
    }

    public ColorSpace(@NotNull String name, @NotNull ColorModel model, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.name = name;
        this.model = model;
        this.id = id;
        CharSequence charSequence = this.name;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (this.id < -1 || this.id > 63) {
            throw (Throwable)new IllegalArgumentException("The id must be between -1 and 63");
        }
    }

    public ColorSpace(@NotNull String name, @NotNull ColorModel model) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this(name, model, -1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace$Companion;", "", "()V", "MaxId", "", "MinId", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

