/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import androidx.compose.ui.graphics.AndroidBlendModeKt;
import androidx.compose.ui.graphics.AndroidPaint;
import androidx.compose.ui.graphics.AndroidPaintKt$WhenMappings;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.FilterQuality;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.StrokeJoin;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u0005*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0018\u0010\t\u001a\u00020\n*\u00060\u0003j\u0002`\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\r*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u0011*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u0005*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u0005*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u0015*\u00060\u0003j\u0002`\u0006H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0019\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\bH\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\"\u0010\u001d\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\nH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u001a\u0010 \u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010!H\u0000\u001a\u0018\u0010\"\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\rH\u0000\u001a \u0010#\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u000e\u0010\u0018\u001a\n\u0018\u00010$j\u0004\u0018\u0001`%H\u0000\u001a \u0010&\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u000e\u0010\u0018\u001a\n\u0018\u00010'j\u0004\u0018\u0001`(H\u0000\u001a\u0018\u0010)\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0000\u001a\u0018\u0010*\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0011H\u0000\u001a\u0018\u0010+\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a\u0018\u0010,\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a\u0018\u0010-\u001a\u00020\u0017*\u00060\u0003j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0015H\u0000*\n\u0010.\"\u00020\u00032\u00020\u0003\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Paint", "Landroidx/compose/ui/graphics/Paint;", "makeNativePaint", "Landroid/graphics/Paint;", "getNativeAlpha", "", "Landroidx/compose/ui/graphics/NativePaint;", "getNativeAntiAlias", "", "getNativeColor", "Landroidx/compose/ui/graphics/Color;", "(Landroid/graphics/Paint;)J", "getNativeFilterQuality", "Landroidx/compose/ui/graphics/FilterQuality;", "getNativeStrokeCap", "Landroidx/compose/ui/graphics/StrokeCap;", "getNativeStrokeJoin", "Landroidx/compose/ui/graphics/StrokeJoin;", "getNativeStrokeMiterLimit", "getNativeStrokeWidth", "getNativeStyle", "Landroidx/compose/ui/graphics/PaintingStyle;", "setNativeAlpha", "", "value", "setNativeAntiAlias", "setNativeBlendMode", "mode", "Landroidx/compose/ui/graphics/BlendMode;", "setNativeColor", "setNativeColor-xhkX8pw", "(Landroid/graphics/Paint;J)V", "setNativeColorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "setNativeFilterQuality", "setNativePathEffect", "Landroid/graphics/PathEffect;", "Landroidx/compose/ui/graphics/NativePathEffect;", "setNativeShader", "Landroid/graphics/Shader;", "Landroidx/compose/ui/graphics/Shader;", "setNativeStrokeCap", "setNativeStrokeJoin", "setNativeStrokeMiterLimit", "setNativeStrokeWidth", "setNativeStyle", "NativePaint", "ui-graphics_release"})
public final class AndroidPaintKt {
    @NotNull
    public static final Paint Paint() {
        return new AndroidPaint();
    }

    @NotNull
    public static final android.graphics.Paint makeNativePaint() {
        return new android.graphics.Paint(1);
    }

    public static final void setNativeBlendMode(@NotNull android.graphics.Paint $this$setNativeBlendMode, @NotNull BlendMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeBlendMode, (String)"$this$setNativeBlendMode");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (Build.VERSION.SDK_INT >= 29) {
            $this$setNativeBlendMode.setBlendMode(AndroidBlendModeKt.toAndroidBlendMode(mode));
        } else {
            $this$setNativeBlendMode.setXfermode((Xfermode)new PorterDuffXfermode(AndroidBlendModeKt.toPorterDuffMode(mode)));
        }
    }

    public static final void setNativeColorFilter(@NotNull android.graphics.Paint $this$setNativeColorFilter, @Nullable ColorFilter value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeColorFilter, (String)"$this$setNativeColorFilter");
        if (value != null) {
            $this$setNativeColorFilter.setColorFilter((android.graphics.ColorFilter)new PorterDuffColorFilter(ColorKt.toArgb-8_81llA(value.getColor-0d7_KjU()), AndroidBlendModeKt.toPorterDuffMode(value.getBlendMode())));
        } else {
            $this$setNativeColorFilter.setColorFilter((android.graphics.ColorFilter)null);
        }
    }

    public static final float getNativeAlpha(@NotNull android.graphics.Paint $this$getNativeAlpha) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeAlpha, (String)"$this$getNativeAlpha");
        return (float)$this$getNativeAlpha.getAlpha() / 255.0f;
    }

    public static final void setNativeAlpha(@NotNull android.graphics.Paint $this$setNativeAlpha, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeAlpha, (String)"$this$setNativeAlpha");
        float f = value * 255.0f;
        boolean bl = false;
        $this$setNativeAlpha.setAlpha((int)Math.rint(f));
    }

    public static final boolean getNativeAntiAlias(@NotNull android.graphics.Paint $this$getNativeAntiAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeAntiAlias, (String)"$this$getNativeAntiAlias");
        return $this$getNativeAntiAlias.isAntiAlias();
    }

    public static final void setNativeAntiAlias(@NotNull android.graphics.Paint $this$setNativeAntiAlias, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeAntiAlias, (String)"$this$setNativeAntiAlias");
        $this$setNativeAntiAlias.setAntiAlias(value);
    }

    public static final long getNativeColor(@NotNull android.graphics.Paint $this$getNativeColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeColor, (String)"$this$getNativeColor");
        return ColorKt.Color($this$getNativeColor.getColor());
    }

    public static final void setNativeColor-xhkX8pw(@NotNull android.graphics.Paint $this$setNativeColor, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeColor, (String)"$this$setNativeColor");
        $this$setNativeColor.setColor(ColorKt.toArgb-8_81llA(value));
    }

    public static final void setNativeStyle(@NotNull android.graphics.Paint $this$setNativeStyle, @NotNull PaintingStyle value) {
        Paint.Style style;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStyle, (String)"$this$setNativeStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
            case 1: {
                style = Paint.Style.STROKE;
                break;
            }
            default: {
                style = Paint.Style.FILL;
            }
        }
        $this$setNativeStyle.setStyle(style);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final PaintingStyle getNativeStyle(@NotNull android.graphics.Paint $this$getNativeStyle) {
        PaintingStyle paintingStyle;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStyle, (String)"$this$getNativeStyle");
        Paint.Style style = $this$getNativeStyle.getStyle();
        if (style != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
                case 1: {
                    paintingStyle = PaintingStyle.Stroke;
                    return paintingStyle;
                }
            }
        }
        paintingStyle = PaintingStyle.Fill;
        return paintingStyle;
    }

    public static final float getNativeStrokeWidth(@NotNull android.graphics.Paint $this$getNativeStrokeWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeWidth, (String)"$this$getNativeStrokeWidth");
        return $this$getNativeStrokeWidth.getStrokeWidth();
    }

    public static final void setNativeStrokeWidth(@NotNull android.graphics.Paint $this$setNativeStrokeWidth, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeWidth, (String)"$this$setNativeStrokeWidth");
        $this$setNativeStrokeWidth.setStrokeWidth(value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final StrokeCap getNativeStrokeCap(@NotNull android.graphics.Paint $this$getNativeStrokeCap) {
        StrokeCap strokeCap;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeCap, (String)"$this$getNativeStrokeCap");
        Paint.Cap cap = $this$getNativeStrokeCap.getStrokeCap();
        if (cap != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$2[cap.ordinal()]) {
                case 1: {
                    strokeCap = StrokeCap.Butt;
                    return strokeCap;
                }
                case 2: {
                    strokeCap = StrokeCap.Round;
                    return strokeCap;
                }
                case 3: {
                    strokeCap = StrokeCap.Square;
                    return strokeCap;
                }
            }
        }
        strokeCap = StrokeCap.Butt;
        return strokeCap;
    }

    public static final void setNativeStrokeCap(@NotNull android.graphics.Paint $this$setNativeStrokeCap, @NotNull StrokeCap value) {
        Paint.Cap cap;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeCap, (String)"$this$setNativeStrokeCap");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$3[value.ordinal()]) {
            case 1: {
                cap = Paint.Cap.SQUARE;
                break;
            }
            case 2: {
                cap = Paint.Cap.ROUND;
                break;
            }
            case 3: {
                cap = Paint.Cap.BUTT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$setNativeStrokeCap.setStrokeCap(cap);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final StrokeJoin getNativeStrokeJoin(@NotNull android.graphics.Paint $this$getNativeStrokeJoin) {
        StrokeJoin strokeJoin;
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeJoin, (String)"$this$getNativeStrokeJoin");
        Paint.Join join = $this$getNativeStrokeJoin.getStrokeJoin();
        if (join != null) {
            switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$4[join.ordinal()]) {
                case 1: {
                    strokeJoin = StrokeJoin.Miter;
                    return strokeJoin;
                }
                case 2: {
                    strokeJoin = StrokeJoin.Bevel;
                    return strokeJoin;
                }
                case 3: {
                    strokeJoin = StrokeJoin.Round;
                    return strokeJoin;
                }
            }
        }
        strokeJoin = StrokeJoin.Miter;
        return strokeJoin;
    }

    public static final void setNativeStrokeJoin(@NotNull android.graphics.Paint $this$setNativeStrokeJoin, @NotNull StrokeJoin value) {
        Paint.Join join;
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeJoin, (String)"$this$setNativeStrokeJoin");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (AndroidPaintKt$WhenMappings.$EnumSwitchMapping$5[value.ordinal()]) {
            case 1: {
                join = Paint.Join.MITER;
                break;
            }
            case 2: {
                join = Paint.Join.BEVEL;
                break;
            }
            case 3: {
                join = Paint.Join.ROUND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$setNativeStrokeJoin.setStrokeJoin(join);
    }

    public static final float getNativeStrokeMiterLimit(@NotNull android.graphics.Paint $this$getNativeStrokeMiterLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeStrokeMiterLimit, (String)"$this$getNativeStrokeMiterLimit");
        return $this$getNativeStrokeMiterLimit.getStrokeMiter();
    }

    public static final void setNativeStrokeMiterLimit(@NotNull android.graphics.Paint $this$setNativeStrokeMiterLimit, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeStrokeMiterLimit, (String)"$this$setNativeStrokeMiterLimit");
        $this$setNativeStrokeMiterLimit.setStrokeMiter(value);
    }

    @NotNull
    public static final FilterQuality getNativeFilterQuality(@NotNull android.graphics.Paint $this$getNativeFilterQuality) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeFilterQuality, (String)"$this$getNativeFilterQuality");
        return !$this$getNativeFilterQuality.isFilterBitmap() ? FilterQuality.None : FilterQuality.Low;
    }

    public static final void setNativeFilterQuality(@NotNull android.graphics.Paint $this$setNativeFilterQuality, @NotNull FilterQuality value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeFilterQuality, (String)"$this$setNativeFilterQuality");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        $this$setNativeFilterQuality.setFilterBitmap(value != FilterQuality.None);
    }

    public static final void setNativeShader(@NotNull android.graphics.Paint $this$setNativeShader, @Nullable Shader value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativeShader, (String)"$this$setNativeShader");
        $this$setNativeShader.setShader(value);
    }

    public static final void setNativePathEffect(@NotNull android.graphics.Paint $this$setNativePathEffect, @Nullable PathEffect value) {
        Intrinsics.checkNotNullParameter((Object)$this$setNativePathEffect, (String)"$this$setNativePathEffect");
        $this$setNativePathEffect.setPathEffect(value);
    }
}

