/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/graphics/colorspace/Xyz;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "id", "", "(Ljava/lang/String;I)V", "isWideGamut", "", "()Z", "clamp", "", "x", "fromXyz", "", "v", "getMaxValue", "component", "getMinValue", "toXyz", "ui-graphics_release"})
public final class Xyz
extends ColorSpace {
    @Override
    public boolean isWideGamut() {
        return true;
    }

    @Override
    public float getMinValue(@IntRange(from=0L, to=3L) int component) {
        return -2.0f;
    }

    @Override
    public float getMaxValue(@IntRange(from=0L, to=3L) int component) {
        return 2.0f;
    }

    @Override
    @NotNull
    public float[] toXyz(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = this.clamp(v[0]);
        v[1] = this.clamp(v[1]);
        v[2] = this.clamp(v[2]);
        return v;
    }

    @Override
    @NotNull
    public float[] fromXyz(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = this.clamp(v[0]);
        v[1] = this.clamp(v[1]);
        v[2] = this.clamp(v[2]);
        return v;
    }

    private final float clamp(float x) {
        return RangesKt.coerceIn((float)x, (float)-2.0f, (float)2.0f);
    }

    public Xyz(@NotNull String name, @IntRange(from=-1L, to=63L) int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, ColorModel.Xyz, id);
    }
}

