/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\"\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007B<\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0010\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\n\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006 "}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "transformSource", "transformDestination", "renderIntent", "transform", "", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDestination", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getRenderIntent-uksYyKA", "()I", "I", "getSource", "r", "", "g", "b", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "a", "transformToColor-wmQWz5c$ui_graphics_release", "(FFFF)J", "Companion", "RgbConnector", "ui-graphics_release"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace source;
    @NotNull
    private final ColorSpace destination;
    @NotNull
    private final ColorSpace transformSource;
    @NotNull
    private final ColorSpace transformDestination;
    private final int renderIntent;
    @Nullable
    private final float[] transform;
    @NotNull
    private static final Connector SrgbIdentity = Companion.identity$ui_graphics_release(ColorSpaces.INSTANCE.getSrgb());
    @NotNull
    private static final Connector SrgbToOklabPerceptual = new Connector(ColorSpaces.INSTANCE.getSrgb(), ColorSpaces.INSTANCE.getOklab(), RenderIntent.Companion.getPerceptual-uksYyKA(), null);
    @NotNull
    private static final Connector OklabToSrgbPerceptual = new Connector(ColorSpaces.INSTANCE.getOklab(), ColorSpaces.INSTANCE.getSrgb(), RenderIntent.Companion.getPerceptual-uksYyKA(), null);

    private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform) {
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    public final int getRenderIntent-uksYyKA() {
        return this.renderIntent;
    }

    private Connector(ColorSpace source, ColorSpace destination, int intent) {
        this(source, destination, ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform-YBCOT_4(source, destination, intent), null);
    }

    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @NotNull
    public float[] transform(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            xyz[0] = xyz[0] * this.transform[0];
            xyz[1] = xyz[1] * this.transform[1];
            xyz[2] = xyz[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    public long transformToColor-wmQWz5c$ui_graphics_release(float r, float g, float b, float a) {
        long packed = this.transformSource.toXy$ui_graphics_release(r, g, b);
        boolean $i$f$unpackFloat1 = false;
        float x = Float.intBitsToFloat((int)(packed >> 32));
        boolean $i$f$unpackFloat2 = false;
        float y = Float.intBitsToFloat((int)(packed & 0xFFFFFFFFL));
        float z = this.transformSource.toZ$ui_graphics_release(r, g, b);
        if (this.transform != null) {
            x *= this.transform[0];
            y *= this.transform[1];
            z *= this.transform[2];
        }
        return this.transformDestination.xyzaToColor-JlNiLsg$ui_graphics_release(x, y, z, a, this.destination);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, transformSource, transformDestination, renderIntent, transform);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, int intent, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, intent);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\"\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J-\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0010\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/compose/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "mTransform", "", "computeTransform", "source", "destination", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;I)[F", "transform", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "r", "", "g", "b", "a", "transformToColor-wmQWz5c$ui_graphics_release", "(FFFF)J", "ui-graphics_release"})
    public static final class RgbConnector
    extends Connector {
        @NotNull
        private final Rgb mSource;
        @NotNull
        private final Rgb mDestination;
        @NotNull
        private final float[] mTransform;

        private RgbConnector(Rgb mSource, Rgb mDestination, int intent) {
            super(mSource, mDestination, mSource, mDestination, intent, null, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform-YBCOT_4(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(v[0]);
            v[1] = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(v[1]);
            v[2] = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(v[2]);
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v[0]);
            v[1] = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v[1]);
            v[2] = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v[2]);
            return v;
        }

        @Override
        public long transformToColor-wmQWz5c$ui_graphics_release(float r, float g, float b, float a) {
            float v0 = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(r);
            float v1 = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(g);
            float v2 = (float)this.mSource.getEotfFunc$ui_graphics_release().invoke(b);
            float v01 = ColorSpaceKt.mul3x3Float3_0(this.mTransform, v0, v1, v2);
            float v11 = ColorSpaceKt.mul3x3Float3_1(this.mTransform, v0, v1, v2);
            float v21 = ColorSpaceKt.mul3x3Float3_2(this.mTransform, v0, v1, v2);
            float v02 = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v01);
            float v12 = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v11);
            float v22 = (float)this.mDestination.getOetfFunc$ui_graphics_release().invoke(v21);
            return ColorKt.Color(v02, v12, v22, a, this.mDestination);
        }

        private final float[] computeTransform-YBCOT_4(Rgb source, Rgb destination, int intent) {
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$ui_graphics_release(), source.getTransform$ui_graphics_release());
            }
            float[] transform = source.getTransform$ui_graphics_release();
            float[] inverseTransform = destination.getInverseTransform$ui_graphics_release();
            float[] srcXYZ = source.getWhitePoint().toXyz$ui_graphics_release();
            float[] dstXYZ = destination.getWhitePoint().toXyz$ui_graphics_release();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray = Adaptation.Companion.getBradford().getTransform$ui_graphics_release();
                float[] fArray2 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] fArray3 = Arrays.copyOf(fArray2, fArray2.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"copyOf(this, size)");
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(fArray, srcXYZ, fArray3);
                transform = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$ui_graphics_release());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray = Adaptation.Companion.getBradford().getTransform$ui_graphics_release();
                float[] fArray4 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] fArray5 = Arrays.copyOf(fArray4, fArray4.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray5, (String)"copyOf(this, size)");
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(fArray, dstXYZ, fArray5);
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$ui_graphics_release()));
            }
            if (RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform = ColorSpaceKt.mul3x3Diag(fArray, transform);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform);
        }

        public /* synthetic */ RgbConnector(Rgb mSource, Rgb mDestination, int intent, DefaultConstructorMarker $constructor_marker) {
            this(mSource, mDestination, intent);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$Companion;", "", "()V", "OklabToSrgbPerceptual", "Landroidx/compose/ui/graphics/colorspace/Connector;", "getOklabToSrgbPerceptual$ui_graphics_release", "()Landroidx/compose/ui/graphics/colorspace/Connector;", "SrgbIdentity", "getSrgbIdentity$ui_graphics_release", "SrgbToOklabPerceptual", "getSrgbToOklabPerceptual$ui_graphics_release", "computeTransform", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)[F", "identity", "identity$ui_graphics_release", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
            if (!RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                return null;
            }
            boolean srcRGB = ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            boolean dstRGB = ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                ColorSpace colorSpace = srcRGB ? source : destination;
                Intrinsics.checkNotNull((Object)colorSpace, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                Rgb rgb = (Rgb)colorSpace;
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$ui_graphics_release(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int n = RenderIntent.Companion.getRelative-uksYyKA();
            return new Connector(source, n){

                @NotNull
                public float[] transform(@NotNull float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }

                public long transformToColor-wmQWz5c$ui_graphics_release(float r, float g, float b, float a) {
                    return ColorKt.Color(r, g, b, a, this.getDestination());
                }
            };
        }

        @NotNull
        public final Connector getSrgbIdentity$ui_graphics_release() {
            return SrgbIdentity;
        }

        @NotNull
        public final Connector getSrgbToOklabPerceptual$ui_graphics_release() {
            return SrgbToOklabPerceptual;
        }

        @NotNull
        public final Connector getOklabToSrgbPerceptual$ui_graphics_release() {
            return OklabToSrgbPerceptual;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

