/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.AndroidImageHelpers_androidKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.TestContext;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.test.android.WindowCapture_androidKt;
import androidx.compose.ui.window.DialogWindowProvider;
import androidx.test.platform.app.InstrumentationRegistry;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003\u001a\f\u0010\r\u001a\u00020\n*\u00020\u000eH\u0007\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"findDialogWindowProviderInParent", "Landroidx/compose/ui/window/DialogWindowProvider;", "view", "Landroid/view/View;", "findNodePosition", "Landroidx/compose/ui/geometry/Offset;", "node", "Landroidx/compose/ui/semantics/SemanticsNode;", "(Landroidx/compose/ui/semantics/SemanticsNode;)J", "processMultiWindowScreenshot", "Landroidx/compose/ui/graphics/ImageBitmap;", "testContext", "Landroidx/compose/ui/test/TestContext;", "captureToImage", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "getActivityWindow", "Landroid/view/Window;", "Landroid/content/Context;", "ui-test_release"})
public final class AndroidImageHelpers_androidKt {
    @RequiresApi(value=26)
    @NotNull
    public static final ImageBitmap captureToImage(@NotNull SemanticsNodeInteraction $this$captureToImage) {
        Window window;
        SemanticsNode node = $this$captureToImage.fetchSemanticsNode("Failed to capture a node to bitmap.");
        SemanticsNode popupParentMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToImage.popupParentMaybe.1.INSTANCE));
        if (popupParentMaybe2 != null) {
            return AndroidImageHelpers_androidKt.processMultiWindowScreenshot(node, $this$captureToImage.getTestContext$ui_test_release());
        }
        RootForTest rootForTest = node.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        View view = ((ViewRootForTest)rootForTest).getView();
        SemanticsNode dialogParentNodeMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToImage.dialogParentNodeMaybe.1.INSTANCE));
        Window dialogWindow = null;
        if (dialogParentNodeMaybe2 != null) {
            if (Build.VERSION.SDK_INT < 28) {
                throw new IllegalArgumentException("Cannot currently capture dialogs on API lower than 28!");
            }
            DialogWindowProvider dialogWindowProvider = AndroidImageHelpers_androidKt.findDialogWindowProviderInParent(view);
            if (dialogWindowProvider == null || (dialogWindowProvider = dialogWindowProvider.getWindow()) == null) {
                throw new IllegalArgumentException("Could not find a dialog window provider to capture its bitmap");
            }
            dialogWindow = dialogWindowProvider;
        }
        if ((window = dialogWindow) == null) {
            window = AndroidImageHelpers_androidKt.getActivityWindow(view.getContext());
        }
        Window windowToUse = window;
        Rect nodeBounds = node.getBoundsInRoot();
        android.graphics.Rect nodeBoundsRect = new android.graphics.Rect(MathKt.roundToInt((float)nodeBounds.getLeft()), MathKt.roundToInt((float)nodeBounds.getTop()), MathKt.roundToInt((float)nodeBounds.getRight()), MathKt.roundToInt((float)nodeBounds.getBottom()));
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        view.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        nodeBoundsRect.offset(x, y);
        return WindowCapture_androidKt.captureRegionToImage(windowToUse, $this$captureToImage.getTestContext$ui_test_release(), nodeBoundsRect);
    }

    @ExperimentalTestApi
    @RequiresApi(value=26)
    private static final ImageBitmap processMultiWindowScreenshot(SemanticsNode node, TestContext testContext) {
        RootForTest rootForTest = node.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        WindowCapture_androidKt.forceRedraw(((ViewRootForTest)rootForTest).getView(), testContext);
        long nodePositionInScreen = AndroidImageHelpers_androidKt.findNodePosition(node);
        Rect nodeBoundsInRoot = node.getBoundsInRoot();
        Bitmap combinedBitmap = InstrumentationRegistry.getInstrumentation().getUiAutomation().takeScreenshot();
        Bitmap finalBitmap = Bitmap.createBitmap((Bitmap)combinedBitmap, (int)MathKt.roundToInt((float)(Offset.getX-impl((long)nodePositionInScreen) + nodeBoundsInRoot.getLeft())), (int)MathKt.roundToInt((float)(Offset.getY-impl((long)nodePositionInScreen) + nodeBoundsInRoot.getTop())), (int)MathKt.roundToInt((float)nodeBoundsInRoot.getWidth()), (int)MathKt.roundToInt((float)nodeBoundsInRoot.getHeight()));
        return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)finalBitmap);
    }

    private static final long findNodePosition(SemanticsNode node) {
        RootForTest rootForTest = node.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        View view = ((ViewRootForTest)rootForTest).getView();
        int[] nArray = new int[]{0, 0};
        int[] locationOnScreen = nArray;
        view.getLocationOnScreen(locationOnScreen);
        int x = locationOnScreen[0];
        int y = locationOnScreen[1];
        return OffsetKt.Offset((float)x, (float)y);
    }

    @Nullable
    public static final DialogWindowProvider findDialogWindowProviderInParent(@NotNull View view) {
        if (view instanceof DialogWindowProvider) {
            return (DialogWindowProvider)view;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent == null) {
            return null;
        }
        ViewParent parent = viewParent;
        if (parent instanceof View) {
            return AndroidImageHelpers_androidKt.findDialogWindowProviderInParent((View)parent);
        }
        return null;
    }

    private static final Window getActivityWindow(Context $this$getActivityWindow) {
        return AndroidImageHelpers_androidKt.getActivityWindow$getActivity($this$getActivityWindow).getWindow();
    }

    private static final Activity getActivityWindow$getActivity(Context $this$getActivityWindow_u24getActivity) {
        Activity activity;
        Context context = $this$getActivityWindow_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$getActivityWindow_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            activity = AndroidImageHelpers_androidKt.getActivityWindow$getActivity(((ContextWrapper)$this$getActivityWindow_u24getActivity).getBaseContext());
        } else {
            throw new IllegalStateException("Context is not an Activity context, but a " + $this$getActivityWindow_u24getActivity.getClass().getSimpleName() + " context. An Activity context is required to get a Window instance");
        }
        return activity;
    }
}

