/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.test.ActionsKt;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.GestureScope;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.unit.IntSizeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0006\u001a#\u0010\u0007\u001a\u00020\u0006*\u00020\u00062\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0006\u001a\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a$\u0010\u0014\u001a\u00020\u000b*\u00020\u00062\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00170\u00160\u0015\u001aB\u0010\u0014\u001a\u00020\u000b\"\u000e\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u00020\u00010\u0019*\u00020\u00062\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00160\u00152\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u000b0\t\u001aC\u0010\u001b\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00022\u001a\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u001e\"\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002\u00a2\u0006\u0002\u0010!\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\""}, d2={"isReversedHorizontally", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isReversedVertically", "performClick", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "performGesture", "block", "Lkotlin/Function1;", "Landroidx/compose/ui/test/GestureScope;", "", "Lkotlin/ExtensionFunctionType;", "performScrollTo", "performScrollToIndex", "index", "", "performScrollToKey", "key", "", "performSemanticsAction", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "T", "Lkotlin/Function;", "invocation", "requireSemantics", "node", "properties", "", "errorMessage", "", "(Landroidx/compose/ui/test/SemanticsNodeInteraction;Landroidx/compose/ui/semantics/SemanticsNode;[Landroidx/compose/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)V", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction performClick(@NotNull SemanticsNodeInteraction $this$performClick) {
        Intrinsics.checkNotNullParameter((Object)$this$performClick, (String)"<this>");
        return ActionsKt.performGesture($this$performClick, (Function1<? super GestureScope, Unit>)((Function1)performClick.1.INSTANCE));
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollTo(@NotNull SemanticsNodeInteraction $this$performScrollTo) {
        float f;
        boolean bl;
        float rawDx;
        float f2;
        boolean bl2;
        float f3;
        float f4;
        boolean mustScrollRight;
        Intrinsics.checkNotNullParameter((Object)$this$performScrollTo, (String)"<this>");
        String errorMessageOnFail = "Action performScrollTo() failed.";
        SemanticsNode node = $this$performScrollTo.fetchSemanticsNode(errorMessageOnFail);
        SemanticsNode semanticsNode = UtilsKt.findClosestParentNode$default(node, false, performScrollTo.scrollableNode.1.INSTANCE, 1, null);
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableNode2 = semanticsNode;
        Rect viewPortInParent = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)scrollableNode2.getLayoutInfo().getCoordinates());
        LayoutCoordinates layoutCoordinates = scrollableNode2.getLayoutInfo().getCoordinates().getParentLayoutCoordinates();
        Offset offset = layoutCoordinates == null ? null : Offset.box-impl((long)LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)layoutCoordinates));
        long parentInRoot = offset == null ? Offset.Companion.getZero-F1C5BW0() : offset.unbox-impl();
        Rect viewPort = viewPortInParent.translate-k-4lQ0M(parentInRoot);
        Rect target = RectKt.Rect-tz77jQw((long)node.getPositionInRoot-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)node.getSize-YbymL2g()));
        boolean mustScrollUp = target.getBottom() > viewPort.getBottom();
        boolean mustScrollDown = target.getTop() < viewPort.getTop();
        boolean mustScrollLeft = target.getRight() > viewPort.getRight();
        boolean bl3 = mustScrollRight = target.getLeft() < viewPort.getLeft();
        if (mustScrollLeft && !mustScrollRight) {
            f4 = target.getLeft() - viewPort.getLeft();
            f3 = target.getRight() - viewPort.getRight();
            bl2 = false;
            f2 = Math.min(f4, f3);
        } else if (mustScrollRight && !mustScrollLeft) {
            f4 = target.getLeft() - viewPort.getLeft();
            f3 = target.getRight() - viewPort.getRight();
            bl2 = false;
            f2 = Math.max(f4, f3);
        } else {
            f2 = rawDx = 0.0f;
        }
        if (mustScrollUp && !mustScrollDown) {
            f3 = target.getTop() - viewPort.getTop();
            float f5 = target.getBottom() - viewPort.getBottom();
            bl = false;
            f = Math.min(f3, f5);
        } else if (mustScrollDown && !mustScrollUp) {
            f3 = target.getTop() - viewPort.getTop();
            float f6 = target.getBottom() - viewPort.getBottom();
            bl = false;
            f = Math.max(f3, f6);
        } else {
            f = 0.0f;
        }
        float rawDy = f;
        float dx = ActionsKt.isReversedHorizontally(scrollableNode2) ? -rawDx : rawDx;
        float dy = ActionsKt.isReversedVertically(scrollableNode2) ? -rawDy : rawDy;
        $this$performScrollTo.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(scrollableNode2, dx, dy){
            final /* synthetic */ SemanticsNode $scrollableNode;
            final /* synthetic */ float $dx;
            final /* synthetic */ float $dy;
            {
                this.$scrollableNode = $scrollableNode;
                this.$dx = $dx;
                this.$dy = $dy;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
                return function2 == null ? null : (Boolean)function2.invoke((Object)Float.valueOf(this.$dx), (Object)Float.valueOf(this.$dy));
            }
        });
        return $this$performScrollTo;
    }

    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performScrollToIndex(@NotNull SemanticsNodeInteraction $this$performScrollToIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToIndex, (String)"<this>");
        SemanticsNode node = $this$performScrollToIndex.fetchSemanticsNode("Failed: performScrollToIndex(" + index + ')');
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics($this$performScrollToIndex, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(index){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Failed to scroll to index ", (Object)this.$index);
            }
        }));
        $this$performScrollToIndex.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(node, index){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ int $index;
            {
                this.$node = $node;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function2 = ((AccessibilityAction)this.$node.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function2);
                return (Boolean)((Function1)function2).invoke((Object)this.$index);
            }
        });
        return $this$performScrollToIndex;
    }

    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performScrollToKey(@NotNull SemanticsNodeInteraction $this$performScrollToKey, @NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SemanticsNode node = $this$performScrollToKey.fetchSemanticsNode("Failed: performScrollToKey(\"" + key + "\")");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsProperties.INSTANCE.getIndexForKey(), SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics($this$performScrollToKey, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ Object $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to scroll to the item identified by \"" + this.$key + '\"';
            }
        }));
        int index = ((Number)((Function1)node.getConfig().get(SemanticsProperties.INSTANCE.getIndexForKey())).invoke(key)).intValue();
        boolean bl = index >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed to scroll to the item identified by \"" + key + "\", couldn't find the key.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$performScrollToKey.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(node, index){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ int $index;
            {
                this.$node = $node;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function2 = ((AccessibilityAction)this.$node.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function2);
                return (Boolean)((Function1)function2).invoke((Object)this.$index);
            }
        });
        return $this$performScrollToKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performGesture(@NotNull SemanticsNodeInteraction $this$performGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performGesture.fetchSemanticsNode("Failed to perform a gesture.");
        GestureScope gestureScope = new GestureScope(node, $this$performGesture.getTestContext$ui_test_release());
        boolean bl = false;
        boolean bl2 = false;
        GestureScope $this$performGesture_u24lambda_u2d1 = gestureScope;
        boolean bl3 = false;
        try {
            block.invoke((Object)$this$performGesture_u24lambda_u2d1);
        }
        finally {
            try {
                $this$performGesture_u24lambda_u2d1.getInputDispatcher$ui_test_release().sendAllSynchronous();
            }
            finally {
                $this$performGesture_u24lambda_u2d1.dispose$ui_test_release();
            }
        }
        return $this$performGesture;
    }

    public static final <T extends Function<? extends Boolean>> void performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        SemanticsNode node = $this$performSemanticsAction.fetchSemanticsNode("Failed to perform " + key.getName() + " action.");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{key};
        ActionsKt.requireSemantics($this$performSemanticsAction, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Failed to perform action ", (Object)this.$key.getName());
            }
        }));
        $this$performSemanticsAction.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Unit>(node, key, invocation){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            final /* synthetic */ Function1<T, Unit> $invocation;
            {
                this.$node = $node;
                this.$key = $key;
                this.$invocation = $invocation;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Function function2 = ((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction();
                if (function2 == null) {
                    unit = null;
                } else {
                    Function function3 = function2;
                    Function1<T, Unit> function1 = this.$invocation;
                    boolean bl = false;
                    boolean bl2 = false;
                    function1.invoke((Object)function3);
                    unit = Unit.INSTANCE;
                }
                return unit;
            }
        });
    }

    public static final void performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ActionsKt.performSemanticsAction($this$performSemanticsAction, key, performSemanticsAction.3.INSTANCE);
    }

    private static final boolean isReversedHorizontally(SemanticsNode $this$isReversedHorizontally) {
        ScrollAxisRange scrollAxisRange = (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$isReversedHorizontally.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        return scrollAxisRange == null ? false : scrollAxisRange.getReverseScrolling();
    }

    private static final boolean isReversedVertically(SemanticsNode $this$isReversedVertically) {
        ScrollAxisRange scrollAxisRange = (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$isReversedVertically.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        return scrollAxisRange == null ? false : scrollAxisRange.getReverseScrolling();
    }

    /*
     * WARNING - void declaration
     */
    private static final void requireSemantics(SemanticsNodeInteraction $this$requireSemantics, SemanticsNode node, SemanticsPropertyKey<?>[] properties, Function0<String> errorMessage) {
        void $this$filterTo$iv$iv;
        Object $this$filter$iv = properties;
        boolean $i$f$filter = false;
        SemanticsPropertyKey<?>[] semanticsPropertyKeyArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_9 = $this$filterTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var10_9[i];
            boolean bl = false;
            if (!(!node.getConfig().contains((SemanticsPropertyKey)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingProperties = (List)destination$iv$iv;
        $this$filter$iv = missingProperties;
        boolean bl = false;
        if (!$this$filter$iv.isEmpty()) {
            String msg = (String)errorMessage.invoke() + ", the node is missing [" + CollectionsKt.joinToString$default((Iterable)missingProperties, null, null, null, (int)0, null, null, (int)63, null) + ']';
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$requireSemantics.getSelector$ui_test_release(), node));
        }
    }
}

