/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import android.os.SystemClock;
import android.view.MotionEvent;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.compose.ui.test.InputDispatcher;
import androidx.compose.ui.test.PartialGesture;
import androidx.compose.ui.test.TestContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJG\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0002\u00f8\u0001\u0000J\b\u0010\"\u001a\u00020\tH\u0002J\b\u0010#\u001a\u00020\tH\u0014J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u00020\t*\u00020*2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\f\u0010+\u001a\u00020\t*\u00020*H\u0014J\u0014\u0010,\u001a\u00020\t*\u00020*2\u0006\u0010-\u001a\u00020\u001cH\u0014J\f\u0010.\u001a\u00020\t*\u00020*H\u0014J\u0014\u0010/\u001a\u00020\t*\u00020*2\u0006\u0010-\u001a\u00020\u001cH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Landroidx/compose/ui/test/AndroidInputDispatcher;", "Landroidx/compose/ui/test/InputDispatcher;", "testContext", "Landroidx/compose/ui/test/TestContext;", "root", "Landroidx/compose/ui/platform/ViewRootForTest;", "sendEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "", "(Landroidx/compose/ui/test/TestContext;Landroidx/compose/ui/platform/ViewRootForTest;Lkotlin/jvm/functions/Function1;)V", "acceptEvents", "", "batchLock", "", "batchedEvents", "", "firstEventTime", "", "now", "getNow", "()J", "previousLastEventTime", "Ljava/lang/Long;", "batchMotionEvent", "downTime", "eventTime", "action", "", "actionIndex", "coordinates", "", "Landroidx/compose/ui/geometry/Offset;", "pointerIds", "checkAndStopAcceptingEvents", "onDispose", "pumpClock", "millis", "sendAllSynchronous", "sendAndRecycleEvent", "event", "stopAcceptingEvents", "Landroidx/compose/ui/test/PartialGesture;", "enqueueCancel", "enqueueDown", "pointerId", "enqueueMove", "enqueueUp", "ui-test_release"})
public final class AndroidInputDispatcher
extends InputDispatcher {
    @NotNull
    private final TestContext testContext;
    @Nullable
    private final ViewRootForTest root;
    @NotNull
    private final Function1<MotionEvent, Unit> sendEvent;
    @NotNull
    private final Object batchLock;
    @NotNull
    private List<MotionEvent> batchedEvents;
    private boolean acceptEvents;
    private long firstEventTime;
    @Nullable
    private final Long previousLastEventTime;

    public AndroidInputDispatcher(@NotNull TestContext testContext, @Nullable ViewRootForTest root, @NotNull Function1<? super MotionEvent, Unit> sendEvent) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter(sendEvent, (String)"sendEvent");
        super(testContext, (RootForTest)root);
        this.testContext = testContext;
        this.root = root;
        this.sendEvent = sendEvent;
        this.batchLock = new Object();
        boolean bl = false;
        this.batchedEvents = new ArrayList();
        this.acceptEvents = true;
        this.firstEventTime = Long.MAX_VALUE;
        PartialGesture partialGesture = this.getPartialGesture();
        this.previousLastEventTime = partialGesture == null ? null : Long.valueOf(partialGesture.getLastEventTime());
    }

    @Override
    protected long getNow() {
        return SystemClock.uptimeMillis();
    }

    @Override
    protected void enqueueDown(@NotNull PartialGesture $this$enqueueDown, int pointerId) {
        Intrinsics.checkNotNullParameter((Object)$this$enqueueDown, (String)"<this>");
        this.batchMotionEvent($this$enqueueDown, $this$enqueueDown.getLastPositions().size() == 1 ? 0 : 5, CollectionsKt.sorted((Iterable)$this$enqueueDown.getLastPositions().keySet()).indexOf(pointerId));
    }

    @Override
    protected void enqueueMove(@NotNull PartialGesture $this$enqueueMove) {
        Intrinsics.checkNotNullParameter((Object)$this$enqueueMove, (String)"<this>");
        this.batchMotionEvent($this$enqueueMove, 2, 0);
    }

    @Override
    protected void enqueueUp(@NotNull PartialGesture $this$enqueueUp, int pointerId) {
        Intrinsics.checkNotNullParameter((Object)$this$enqueueUp, (String)"<this>");
        this.batchMotionEvent($this$enqueueUp, $this$enqueueUp.getLastPositions().size() == 1 ? 1 : 6, CollectionsKt.sorted((Iterable)$this$enqueueUp.getLastPositions().keySet()).indexOf(pointerId));
    }

    @Override
    protected void enqueueCancel(@NotNull PartialGesture $this$enqueueCancel) {
        Intrinsics.checkNotNullParameter((Object)$this$enqueueCancel, (String)"<this>");
        this.batchMotionEvent($this$enqueueCancel, 3, 0);
    }

    private final void batchMotionEvent(PartialGesture $this$batchMotionEvent, int action, int actionIndex) {
        Object object;
        int it;
        ArrayList<Offset> arrayList;
        boolean bl;
        int n;
        Iterable $this$sortedBy$iv = $this$batchMotionEvent.getLastPositions().entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        List entries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        int n2 = entries.size();
        int n3 = actionIndex;
        int n4 = action;
        long l = $this$batchMotionEvent.getLastEventTime();
        long l2 = $this$batchMotionEvent.getDownTime();
        AndroidInputDispatcher androidInputDispatcher = this;
        boolean bl3 = false;
        bl2 = false;
        ArrayList<Offset> arrayList2 = new ArrayList<Offset>(n2);
        boolean bl4 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n2;
        while (n5 < n6) {
            n = n5++;
            bl = false;
            int n7 = n;
            arrayList = arrayList2;
            boolean bl5 = false;
            object = Offset.box-impl((long)((Offset)((Map.Entry)entries.get(it)).getValue()).unbox-impl());
            arrayList.add((Offset)object);
        }
        arrayList = arrayList2;
        n2 = entries.size();
        bl3 = false;
        bl2 = false;
        arrayList2 = new ArrayList(n2);
        bl4 = false;
        n5 = 0;
        n5 = 0;
        n6 = n2;
        while (n5 < n6) {
            n = n5++;
            bl = false;
            it = n;
            object = arrayList2;
            boolean bl6 = false;
            Integer n8 = ((Number)((Map.Entry)entries.get(it)).getKey()).intValue();
            ((ArrayList)object).add(n8);
        }
        object = arrayList2;
        androidInputDispatcher.batchMotionEvent(l2, l, n4, n3, arrayList, (List<Integer>)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void batchMotionEvent(long downTime, long eventTime, int action, int actionIndex, List<Offset> coordinates, List<Integer> pointerIds) {
        Object object = this.batchLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d6;
            MotionEvent.PointerProperties[] pointerPropertiesArray;
            boolean bl3;
            boolean bl4;
            MotionEvent.PointerProperties pointerProperties;
            int n;
            long l;
            boolean bl5 = false;
            boolean bl6 = this.acceptEvents;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "Can't enqueue event (downTime=" + downTime + ", eventTime=" + eventTime + ", action=" + action + ", actionIndex=" + actionIndex + ", pointerIds=" + pointerIds + ", coordinates=" + coordinates + "), events have already been (or are being) dispatched or disposed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (this.firstEventTime == Long.MAX_VALUE) {
                this.firstEventTime = eventTime;
            }
            if (this.root != null) {
                int[] nArray = new int[]{0, 0};
                int[] array = nArray;
                this.root.getView().getLocationOnScreen(array);
                l = OffsetKt.Offset((float)array[0], (float)array[1]);
            } else {
                l = Offset.Companion.getZero-F1C5BW0();
            }
            long positionInScreen = l;
            int n2 = 0;
            int n3 = coordinates.size();
            MotionEvent.PointerProperties[] pointerPropertiesArray2 = new MotionEvent.PointerProperties[n3];
            int n4 = coordinates.size();
            int n5 = action + (actionIndex << 8);
            long l2 = eventTime;
            long l3 = downTime;
            List<MotionEvent> list = this.batchedEvents;
            while (n2 < n3) {
                n = n2++;
                pointerProperties = new MotionEvent.PointerProperties();
                bl4 = false;
                bl3 = false;
                MotionEvent.PointerProperties pointerProperties2 = pointerProperties;
                int n6 = n;
                pointerPropertiesArray = pointerPropertiesArray2;
                boolean bl10 = false;
                $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d4.id = ((Number)pointerIds.get(n)).intValue();
                Unit unit = Unit.INSTANCE;
                pointerPropertiesArray[n6] = pointerProperties;
            }
            MotionEvent.PointerProperties[] pointerPropertiesArray3 = pointerPropertiesArray2;
            n2 = 0;
            n3 = coordinates.size();
            pointerPropertiesArray2 = new MotionEvent.PointerCoords[n3];
            pointerPropertiesArray = pointerPropertiesArray3;
            while (n2 < n3) {
                n = n2++;
                pointerProperties = new MotionEvent.PointerCoords();
                bl4 = false;
                bl3 = false;
                MotionEvent.PointerProperties $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d4 = pointerProperties;
                int n7 = n;
                MotionEvent.PointerProperties[] pointerPropertiesArray4 = pointerPropertiesArray2;
                boolean bl11 = false;
                $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d5.x = Offset.getX-impl((long)positionInScreen) + Offset.getX-impl((long)coordinates.get(n).unbox-impl());
                $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d5.y = Offset.getY-impl((long)positionInScreen) + Offset.getY-impl((long)coordinates.get(n).unbox-impl());
                Unit unit = Unit.INSTANCE;
                pointerPropertiesArray4[n7] = pointerProperties;
            }
            MotionEvent motionEvent = MotionEvent.obtain((long)l3, (long)l2, (int)n5, (int)n4, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerPropertiesArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0, (int)0, (int)0);
            n3 = 0;
            boolean bl12 = false;
            MotionEvent motionEvent2 = motionEvent;
            boolean bl13 = false;
            $this$batchMotionEvent_u24lambda_u2d7_u24lambda_u2d6.offsetLocation(-Offset.getX-impl((long)positionInScreen), -Offset.getY-impl((long)positionInScreen));
            Unit unit = Unit.INSTANCE;
            MotionEvent motionEvent3 = motionEvent;
            Intrinsics.checkNotNullExpressionValue((Object)motionEvent3, (String)"obtain(\n                \u2026reen.y)\n                }");
            bl2 = list.add(motionEvent3);
        }
    }

    @Override
    public void sendAllSynchronous() {
        this.testContext.getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidInputDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                AndroidInputDispatcher.access$checkAndStopAcceptingEvents(this.this$0);
                long lastEventTime = 0L;
                Object object = AndroidInputDispatcher.access$getPreviousLastEventTime$p(this.this$0);
                lastEventTime = object == null ? AndroidInputDispatcher.access$getFirstEventTime$p(this.this$0) : (Long)object;
                object = AndroidInputDispatcher.access$getBatchedEvents$p(this.this$0);
                AndroidInputDispatcher androidInputDispatcher = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    MotionEvent event = (MotionEvent)element$iv;
                    boolean bl = false;
                    long l = lastEventTime;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    long l2 = l;
                    long l3 = event.getEventTime();
                    AndroidInputDispatcher androidInputDispatcher2 = androidInputDispatcher;
                    boolean bl4 = false;
                    lastEventTime = event.getEventTime();
                    Unit unit = Unit.INSTANCE;
                    AndroidInputDispatcher.access$pumpClock(androidInputDispatcher2, l3 - l);
                    AndroidInputDispatcher.access$sendAndRecycleEvent(androidInputDispatcher, event);
                }
            }
        });
    }

    private final void pumpClock(long millis) {
        if (millis > 0L) {
            this.testContext.getTestOwner$ui_test_release().getMainClock().advanceTimeBy(millis, true);
        }
    }

    @Override
    protected void onDispose() {
        this.stopAcceptingEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAndStopAcceptingEvents() {
        Object object = this.batchLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = this.acceptEvents;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Events have already been (or are being) dispatched or disposed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.acceptEvents = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean stopAcceptingEvents() {
        Object object = this.batchLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = this.acceptEvents;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean it = bl4;
            boolean bl7 = false;
            this.acceptEvents = false;
            boolean bl8 = bl4;
            return bl8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendAndRecycleEvent(MotionEvent event) {
        try {
            this.sendEvent.invoke((Object)event);
        }
        finally {
            event.recycle();
        }
    }

    public static final /* synthetic */ void access$checkAndStopAcceptingEvents(AndroidInputDispatcher $this) {
        $this.checkAndStopAcceptingEvents();
    }

    public static final /* synthetic */ Long access$getPreviousLastEventTime$p(AndroidInputDispatcher $this) {
        return $this.previousLastEventTime;
    }

    public static final /* synthetic */ long access$getFirstEventTime$p(AndroidInputDispatcher $this) {
        return $this.firstEventTime;
    }

    public static final /* synthetic */ List access$getBatchedEvents$p(AndroidInputDispatcher $this) {
        return $this.batchedEvents;
    }

    public static final /* synthetic */ void access$pumpClock(AndroidInputDispatcher $this, long millis) {
        $this.pumpClock(millis);
    }

    public static final /* synthetic */ void access$sendAndRecycleEvent(AndroidInputDispatcher $this, MotionEvent event) {
        $this.sendAndRecycleEvent(event);
    }
}

