/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.test.InputDispatcher;
import androidx.compose.ui.test.InputDispatcherState;
import androidx.compose.ui.test.PartialGesture;
import androidx.compose.ui.test.TestContext;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0019\b \u0018\u0000 D2\u00020\u0001:\u0001DB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u001b\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010\u000fJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000bJ#\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ5\u0010(\u001a\u00020\u00192\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e0*2\u0006\u0010!\u001a\u00020\u000b2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0,\u00f8\u0001\u0000J+\u0010(\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b/\u00100J;\u00101\u001a\u00020\u00192\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e0*0,2\u0006\u0010!\u001a\u00020\u000b2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0,\u00f8\u0001\u0000J\u0018\u00103\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u0010\u00104\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u001e\u00105\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\b6J\u0010\u00107\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000bH\u0002J#\u00108\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b9\u0010&J\b\u0010:\u001a\u00020\u0019H\u0014J\u0012\u0010;\u001a\u00020\u00192\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\b\u0010<\u001a\u00020\u0019H&J5\u0010=\u001a\u00020\u00192\u0018\u0010>\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e0*0,2\u0006\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0013H$J\u0014\u0010\"\u001a\u00020\u0019*\u00020\u00132\u0006\u0010#\u001a\u00020$H$J\f\u0010'\u001a\u00020\u0019*\u00020\u0013H$J\u0014\u00103\u001a\u00020\u0019*\u00020\u00132\u0006\u0010#\u001a\u00020$H$J\f\u0010A\u001a\u00020\u0019*\u00020\u0013H\u0002J\u0016\u0010B\u001a\u00020\u0019*\u00020\u00132\b\b\u0002\u0010C\u001a\u00020\u000bH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006E"}, d2={"Landroidx/compose/ui/test/InputDispatcher;", "", "testContext", "Landroidx/compose/ui/test/TestContext;", "root", "Landroidx/compose/ui/node/RootForTest;", "(Landroidx/compose/ui/test/TestContext;Landroidx/compose/ui/node/RootForTest;)V", "isGestureInProgress", "", "()Z", "nextDownTime", "", "getNextDownTime", "()J", "setNextDownTime", "(J)V", "now", "getNow", "partialGesture", "Landroidx/compose/ui/test/PartialGesture;", "getPartialGesture", "()Landroidx/compose/ui/test/PartialGesture;", "setPartialGesture", "(Landroidx/compose/ui/test/PartialGesture;)V", "dispose", "", "enqueueCancel", "delay", "enqueueClick", "position", "Landroidx/compose/ui/geometry/Offset;", "enqueueClick-k-4lQ0M", "enqueueDelay", "durationMillis", "enqueueDown", "pointerId", "", "enqueueDown-Uv8p0NA", "(IJ)V", "enqueueMove", "enqueueSwipe", "curve", "Lkotlin/Function1;", "keyTimes", "", "start", "end", "enqueueSwipe-Wko1d7g", "(JJJ)V", "enqueueSwipes", "curves", "enqueueUp", "generateDownTime", "getCurrentPosition", "getCurrentPosition-x-9fifI", "moveNextDownTime", "movePointer", "movePointer-Uv8p0NA", "onDispose", "saveState", "sendAllSynchronous", "sendPartialSwipes", "fs", "t0", "tN", "flushPointerUpdates", "increaseEventTime", "time", "Companion", "ui-test_release"})
public abstract class InputDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestContext testContext;
    @Nullable
    private final RootForTest root;
    private long nextDownTime;
    @Nullable
    private PartialGesture partialGesture;
    private static long eventPeriodMillis = 10L;
    private static final long DownTimeNotSet = -1L;

    public InputDispatcher(@NotNull TestContext testContext, @Nullable RootForTest root) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        this.testContext = testContext;
        this.root = root;
        this.nextDownTime = -1L;
        Object object = this.testContext.getStates$ui_test_release();
        RootForTest rootForTest = this.root;
        boolean bl = false;
        Map<RootForTest, InputDispatcherState> map = object;
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        InputDispatcherState state = (InputDispatcherState)TypeIntrinsics.asMutableMap(map).remove(rootForTest);
        object = state;
        if ((object == null ? null : ((InputDispatcherState)object).getPartialGesture()) != null) {
            this.nextDownTime = state.getNextDownTime();
            this.partialGesture = state.getPartialGesture();
        }
    }

    protected final long getNextDownTime() {
        return this.nextDownTime;
    }

    protected final void setNextDownTime(long l) {
        this.nextDownTime = l;
    }

    @Nullable
    protected final PartialGesture getPartialGesture() {
        return this.partialGesture;
    }

    protected final void setPartialGesture(@Nullable PartialGesture partialGesture) {
        this.partialGesture = partialGesture;
    }

    public final boolean isGestureInProgress() {
        return this.partialGesture != null;
    }

    protected abstract long getNow();

    protected void saveState(@Nullable RootForTest root) {
        if (root != null) {
            Map<RootForTest, InputDispatcherState> map = this.testContext.getStates$ui_test_release();
            InputDispatcherState inputDispatcherState = new InputDispatcherState(this.nextDownTime, this.partialGesture);
            boolean bl = false;
            map.put(root, inputDispatcherState);
        }
    }

    private final long generateDownTime(long durationMillis) {
        long downTime = this.nextDownTime == -1L ? this.getNow() : this.nextDownTime;
        this.nextDownTime = downTime + durationMillis;
        return downTime;
    }

    private final void moveNextDownTime(long durationMillis) {
        this.generateDownTime(durationMillis);
    }

    private final void increaseEventTime(PartialGesture $this$increaseEventTime, long time) {
        this.moveNextDownTime(time);
        PartialGesture partialGesture = $this$increaseEventTime;
        partialGesture.setLastEventTime(partialGesture.getLastEventTime() + time);
    }

    static /* synthetic */ void increaseEventTime$default(InputDispatcher inputDispatcher, PartialGesture partialGesture, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: increaseEventTime");
        }
        if ((n & 1) != 0) {
            l = eventPeriodMillis;
        }
        inputDispatcher.increaseEventTime(partialGesture, l);
    }

    @Nullable
    public final Offset getCurrentPosition-x-9fifI(int pointerId) {
        Offset offset;
        PartialGesture partialGesture = this.partialGesture;
        if (partialGesture == null) {
            offset = null;
        } else {
            Map<Integer, Offset> map = partialGesture.getLastPositions();
            offset = map.get(pointerId);
        }
        return offset;
    }

    public final void enqueueClick-k-4lQ0M(long position) {
        this.enqueueDown-Uv8p0NA(0, position);
        InputDispatcher.enqueueMove$default(this, 0L, 1, null);
        InputDispatcher.enqueueUp$default(this, 0, 0L, 2, null);
    }

    public final void enqueueSwipe-Wko1d7g(long start, long end, long durationMillis) {
        float durationFloat = durationMillis;
        InputDispatcher.enqueueSwipe$default(this, (Function1)new Function1<Long, Offset>(start, end, durationFloat){
            final /* synthetic */ long $start;
            final /* synthetic */ long $end;
            final /* synthetic */ float $durationFloat;
            {
                this.$start = $start;
                this.$end = $end;
                this.$durationFloat = $durationFloat;
                super(1);
            }

            public final long invoke-tuRUvjQ(long it) {
                return OffsetKt.lerp-Wko1d7g((long)this.$start, (long)this.$end, (float)((float)it / this.$durationFloat));
            }
        }, durationMillis, null, 4, null);
    }

    public final void enqueueSwipe(@NotNull Function1<? super Long, Offset> curve, long durationMillis, @NotNull List<Long> keyTimes) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter(keyTimes, (String)"keyTimes");
        this.enqueueSwipes(CollectionsKt.listOf(curve), durationMillis, keyTimes);
    }

    public static /* synthetic */ void enqueueSwipe$default(InputDispatcher inputDispatcher, Function1 function1, long l, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enqueueSwipe");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        inputDispatcher.enqueueSwipe((Function1<? super Long, Offset>)function1, l, list);
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueueSwipes(@NotNull List<? extends Function1<? super Long, Offset>> curves, long durationMillis, @NotNull List<Long> keyTimes) {
        int n;
        int n2;
        boolean bl;
        boolean $i$f$all;
        long endTime;
        long startTime;
        block13: {
            boolean bl2;
            block12: {
                Intrinsics.checkNotNullParameter(curves, (String)"curves");
                Intrinsics.checkNotNullParameter(keyTimes, (String)"keyTimes");
                startTime = 0L;
                endTime = durationMillis;
                boolean bl3 = durationMillis >= 1L;
                boolean bl4 = false;
                boolean bl5 = false;
                if (!bl3) {
                    boolean bl622 = false;
                    String string = Intrinsics.stringPlus((String)"duration must be at least 1 millisecond, not ", (Object)durationMillis);
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                LongRange validRange = new LongRange(startTime, endTime);
                Iterable $this$all$iv = keyTimes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        long it = ((Number)element$iv).longValue();
                        boolean bl7 = false;
                        long l = validRange.getFirst();
                        if (it <= validRange.getLast() ? l <= it : false) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
            }
            boolean $this$all$iv = bl2;
            $i$f$all = false;
            boolean bl622 = false;
            if (!$this$all$iv) {
                boolean bl8 = false;
                String bl622 = "keyTimes contains timestamps out of range [" + startTime + ".." + endTime + "]: " + keyTimes;
                throw (Throwable)new IllegalArgumentException(bl622.toString());
            }
            Sequence $this$all$iv2 = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)keyTimes), (Function2)enqueueSwipes.4.INSTANCE);
            $i$f$all = false;
            for (Object element$iv : $this$all$iv2) {
                boolean it = (Boolean)element$iv;
                boolean bl9 = false;
                if (it) continue;
                bl = false;
                break block13;
            }
            bl = true;
        }
        boolean $this$all$iv2 = bl;
        $i$f$all = false;
        boolean bl622 = false;
        if (!$this$all$iv2) {
            boolean bl10 = false;
            String bl622 = Intrinsics.stringPlus((String)"keyTimes must be sorted: ", keyTimes);
            throw (Throwable)new IllegalArgumentException(bl622.toString());
        }
        Iterable $this$forEachIndexed$iv = curves;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void curve;
            n2 = index$iv++;
            n = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Function1 function1 = (Function1)item$iv;
            int i = n2;
            boolean bl11 = false;
            this.enqueueDown-Uv8p0NA(i, ((Offset)curve.invoke((Object)startTime)).unbox-impl());
        }
        long currTime = startTime;
        int key = 0;
        while (currTime < endTime) {
            while (key < keyTimes.size() && ((Number)keyTimes.get(key)).longValue() <= currTime) {
                int bl10 = key;
                key = bl10 + 1;
            }
            long tNext = key < keyTimes.size() ? ((Number)keyTimes.get(key)).longValue() : endTime;
            this.sendPartialSwipes(curves, currTime, tNext);
            currTime = tNext;
        }
        int n3 = curves.size();
        boolean bl12 = false;
        n2 = 0;
        n2 = 0;
        n = n3;
        while (n2 < n) {
            int it = n2++;
            boolean bl13 = false;
            InputDispatcher.enqueueUp$default(this, it, 0L, 2, null);
        }
    }

    public static /* synthetic */ void enqueueSwipes$default(InputDispatcher inputDispatcher, List list, long l, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enqueueSwipes");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        inputDispatcher.enqueueSwipes(list, l, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendPartialSwipes(List<? extends Function1<? super Long, Offset>> fs, long t0, long tN) {
        int step = 0;
        int n = 1;
        int n2 = MathKt.roundToInt((float)((float)(tN - t0) / (float)eventPeriodMillis));
        int n3 = 0;
        int steps = Math.max(n, n2);
        long tPrev = t0;
        while (true) {
            n3 = step;
            step = n3 + 1;
            if (n3 >= steps) break;
            float progress = (float)step / (float)steps;
            long t = MathHelpersKt.lerp((long)t0, (long)tN, (float)progress);
            Iterable $this$forEachIndexed$iv = fs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void f;
                int n4 = index$iv++;
                boolean bl = false;
                if (n4 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Function1 function1 = (Function1)item$iv;
                int i = n4;
                boolean bl2 = false;
                this.movePointer-Uv8p0NA(i, ((Offset)f.invoke((Object)t)).unbox-impl());
            }
            this.enqueueMove(t - tPrev);
            tPrev = t;
        }
    }

    public final void enqueueDelay(long durationMillis) {
        boolean bl = durationMillis >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"duration of a delay can only be positive, not ", (Object)durationMillis);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.moveNextDownTime(durationMillis);
    }

    public final void enqueueDown-Uv8p0NA(int pointerId, long position) {
        PartialGesture gesture = this.partialGesture;
        boolean bl = gesture == null || !gesture.getLastPositions().containsKey(pointerId);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Cannot send DOWN event, a gesture is already in progress for pointer ", (Object)pointerId);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = gesture;
        if (object != null) {
            this.flushPointerUpdates((PartialGesture)object);
        }
        if (gesture == null) {
            this.partialGesture = gesture = new PartialGesture(this.generateDownTime(0L), position, pointerId, null);
        } else {
            object = gesture.getLastPositions();
            Integer n = pointerId;
            Offset offset = Offset.box-impl((long)position);
            boolean bl5 = false;
            object.put(n, offset);
        }
        this.enqueueDown(gesture, pointerId);
    }

    public final void enqueueMove(long delay) {
        PartialGesture partialGesture = this.partialGesture;
        boolean bl = false;
        boolean bl2 = false;
        if (partialGesture == null) {
            boolean bl3 = false;
            String string = "Cannot send MOVE event, no gesture is in progress";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PartialGesture gesture = partialGesture;
        boolean bl4 = delay >= 0L;
        bl = false;
        bl2 = false;
        if (!bl4) {
            boolean bl5 = false;
            String string = "Cannot send MOVE event with a delay of " + delay + " ms";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.increaseEventTime(gesture, delay);
        this.enqueueMove(gesture);
        gesture.setHasPointerUpdates(false);
    }

    public static /* synthetic */ void enqueueMove$default(InputDispatcher inputDispatcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enqueueMove");
        }
        if ((n & 1) != 0) {
            l = eventPeriodMillis;
        }
        inputDispatcher.enqueueMove(l);
    }

    public final void movePointer-Uv8p0NA(int pointerId, long position) {
        PartialGesture gesture = this.partialGesture;
        boolean bl = gesture != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot move pointers, no gesture is in progress";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = gesture.getLastPositions().containsKey(pointerId);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Cannot move pointer " + pointerId + ", it is not active in the current gesture";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<Integer, Offset> map = gesture.getLastPositions();
        Integer n = pointerId;
        Offset offset = Offset.box-impl((long)position);
        boolean bl6 = false;
        map.put(n, offset);
        gesture.setHasPointerUpdates(true);
    }

    public final void enqueueUp(int pointerId, long delay) {
        PartialGesture gesture = this.partialGesture;
        boolean bl = gesture != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot send UP event, no gesture is in progress";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = gesture.getLastPositions().containsKey(pointerId);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Cannot send UP event for pointer " + pointerId + ", it is not active in the current gesture";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = delay >= 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Cannot send UP event with a delay of " + delay + " ms";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.flushPointerUpdates(gesture);
        this.increaseEventTime(gesture, delay);
        this.enqueueUp(gesture, pointerId);
        gesture.getLastPositions().remove(pointerId);
        if (gesture.getLastPositions().isEmpty()) {
            this.partialGesture = null;
        }
    }

    public static /* synthetic */ void enqueueUp$default(InputDispatcher inputDispatcher, int n, long l, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enqueueUp");
        }
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        inputDispatcher.enqueueUp(n, l);
    }

    public final void enqueueCancel(long delay) {
        PartialGesture partialGesture = this.partialGesture;
        boolean bl = false;
        boolean bl2 = false;
        if (partialGesture == null) {
            boolean bl3 = false;
            String string = "Cannot send CANCEL event, no gesture is in progress";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PartialGesture gesture = partialGesture;
        boolean bl4 = delay >= 0L;
        bl = false;
        bl2 = false;
        if (!bl4) {
            boolean bl5 = false;
            String string = "Cannot send CANCEL event with a delay of " + delay + " ms";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.increaseEventTime(gesture, delay);
        this.enqueueCancel(gesture);
        this.partialGesture = null;
    }

    public static /* synthetic */ void enqueueCancel$default(InputDispatcher inputDispatcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enqueueCancel");
        }
        if ((n & 1) != 0) {
            l = eventPeriodMillis;
        }
        inputDispatcher.enqueueCancel(l);
    }

    public abstract void sendAllSynchronous();

    private final void flushPointerUpdates(PartialGesture $this$flushPointerUpdates) {
        if ($this$flushPointerUpdates.getHasPointerUpdates()) {
            this.enqueueMove(eventPeriodMillis);
        }
    }

    protected abstract void enqueueDown(@NotNull PartialGesture var1, int var2);

    protected abstract void enqueueMove(@NotNull PartialGesture var1);

    protected abstract void enqueueUp(@NotNull PartialGesture var1, int var2);

    protected abstract void enqueueCancel(@NotNull PartialGesture var1);

    public final void dispose() {
        this.saveState(this.root);
        this.onDispose();
    }

    protected void onDispose() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/compose/ui/test/InputDispatcher$Companion;", "", "()V", "DownTimeNotSet", "", "<set-?>", "eventPeriodMillis", "getEventPeriodMillis", "()J", "setEventPeriodMillis$ui_test_release", "(J)V", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getEventPeriodMillis() {
            return eventPeriodMillis;
        }

        public final void setEventPeriodMillis$ui_test_release(long l) {
            eventPeriodMillis = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

