/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.test.ComposeTimeoutException;
import androidx.compose.ui.test.MainTestClock;
import androidx.compose.ui.test.TestContext;
import androidx.compose.ui.test.android.FrameCommitCallbackHelper;
import androidx.compose.ui.test.android.PixelCopyHelper;
import androidx.compose.ui.test.android.WindowCapture_androidKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0001\u001a\"\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006\u0012"}, d2={"captureRegionToImage", "Landroidx/compose/ui/graphics/ImageBitmap;", "testContext", "Landroidx/compose/ui/test/TestContext;", "captureRectInWindow", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "waitUntil", "", "Landroidx/compose/ui/test/MainTestClock;", "timeoutMillis", "", "condition", "Lkotlin/Function0;", "", "ui-test_release"})
public final class WindowCapture_androidKt {
    @RequiresApi(value=26)
    @NotNull
    public static final ImageBitmap captureRegionToImage(@NotNull TestContext testContext, @NotNull Rect captureRectInWindow, @NotNull View view, @Nullable Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)captureRectInWindow, (String)"captureRectInWindow");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Window window3 = window;
        if (window3 == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            Activity activity = WindowCapture_androidKt.captureRegionToImage$getActivity(context);
            Intrinsics.checkNotNull((Object)activity);
            window2 = activity.getWindow();
        } else {
            window2 = window3;
        }
        Window windowToCapture = window2;
        Handler handler = new Handler(Looper.getMainLooper());
        Ref.BooleanRef drawDone = new Ref.BooleanRef();
        View view2 = windowToCapture.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"windowToCapture.decorView");
        View decorView = view2;
        handler.post(new Runnable(decorView, drawDone, handler){
            final /* synthetic */ View $decorView;
            final /* synthetic */ Ref.BooleanRef $drawDone;
            final /* synthetic */ Handler $handler;
            {
                this.$decorView = $decorView;
                this.$drawDone = $drawDone;
                this.$handler = $handler;
            }

            public final void run() {
                if (Build.VERSION.SDK_INT >= 29 && this.$decorView.isHardwareAccelerated()) {
                    ViewTreeObserver viewTreeObserver = this.$decorView.getViewTreeObserver();
                    Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"decorView.viewTreeObserver");
                    FrameCommitCallbackHelper.INSTANCE.registerFrameCommitCallback(viewTreeObserver, new Runnable(this.$drawDone){
                        final /* synthetic */ Ref.BooleanRef $drawDone;
                        {
                            this.$drawDone = $drawDone;
                        }

                        public final void run() {
                            this.$drawDone.element = true;
                        }
                    });
                } else {
                    this.$decorView.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener(this.$handler, this.$drawDone, this.$decorView){
                        private boolean handled;
                        final /* synthetic */ Handler $handler;
                        final /* synthetic */ Ref.BooleanRef $drawDone;
                        final /* synthetic */ View $decorView;
                        {
                            this.$handler = $handler;
                            this.$drawDone = $drawDone;
                            this.$decorView = $decorView;
                        }

                        public final boolean getHandled() {
                            return this.handled;
                        }

                        public final void setHandled(boolean bl) {
                            this.handled = bl;
                        }

                        public void onDraw() {
                            if (!this.handled) {
                                this.handled = true;
                                this.$handler.post(new Runnable(this.$drawDone, this.$decorView, this){
                                    final /* synthetic */ Ref.BooleanRef $drawDone;
                                    final /* synthetic */ View $decorView;
                                    final /* synthetic */ captureRegionToImage.2 this$0;
                                    {
                                        this.$drawDone = $drawDone;
                                        this.$decorView = $decorView;
                                        this.this$0 = $receiver;
                                    }

                                    public final void run() {
                                        this.$drawDone.element = true;
                                        this.$decorView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.this$0);
                                    }
                                });
                            }
                        }
                    });
                }
                this.$decorView.invalidate();
            }
        });
        WindowCapture_androidKt.waitUntil(testContext.getTestOwner$ui_test_release().getMainClock(), 2000L, (Function0<Boolean>)((Function0)new Function0<Boolean>(drawDone){
            final /* synthetic */ Ref.BooleanRef $drawDone;
            {
                this.$drawDone = $drawDone;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$drawDone.element;
            }
        }));
        Bitmap destBitmap = Bitmap.createBitmap((int)captureRectInWindow.width(), (int)captureRectInWindow.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(copyResult, latch){
            final /* synthetic */ Ref.IntRef $copyResult;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$copyResult = $copyResult;
                this.$latch = $latch;
            }

            public final void onPixelCopyFinished(int result) {
                this.$copyResult.element = result;
                this.$latch.countDown();
            }
        };
        Intrinsics.checkNotNullExpressionValue((Object)windowToCapture, (String)"windowToCapture");
        Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
        PixelCopyHelper.INSTANCE.request(windowToCapture, captureRectInWindow, destBitmap, onCopyFinished2, handler);
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
        return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)destBitmap);
    }

    public static /* synthetic */ ImageBitmap captureRegionToImage$default(TestContext testContext, Rect rect, View view, Window window, int n, Object object) {
        if ((n & 8) != 0) {
            window = null;
        }
        return WindowCapture_androidKt.captureRegionToImage(testContext, rect, view, window);
    }

    private static final void waitUntil(MainTestClock $this$waitUntil, long timeoutMillis, Function0<Boolean> condition) {
        long startTime = System.nanoTime();
        while (!((Boolean)condition.invoke()).booleanValue()) {
            if ($this$waitUntil.getAutoAdvance()) {
                $this$waitUntil.advanceTimeByFrame();
            }
            Thread.sleep(10L);
            if (System.nanoTime() - startTime <= timeoutMillis * (long)1000000) continue;
            throw new ComposeTimeoutException("Condition still not satisfied after " + timeoutMillis + " ms");
        }
    }

    private static final Activity captureRegionToImage$getActivity(Context $this$captureRegionToImage_u24getActivity) {
        Activity activity;
        Context context = $this$captureRegionToImage_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$captureRegionToImage_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$captureRegionToImage_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = WindowCapture_androidKt.captureRegionToImage$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }
}

