/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.OutputKt;
import androidx.compose.ui.test.SelectionResult;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsSelector;
import androidx.compose.ui.test.SemanticsSelectorKt;
import androidx.compose.ui.test.TestContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u001a\u001a\u00020\u00192\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rJ!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u001eJ\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Landroidx/compose/ui/test/SemanticsNodeInteraction;", "", "testContext", "Landroidx/compose/ui/test/TestContext;", "useUnmergedTree", "", "matcher", "Landroidx/compose/ui/test/SemanticsMatcher;", "(Landroidx/compose/ui/test/TestContext;ZLandroidx/compose/ui/test/SemanticsMatcher;)V", "selector", "Landroidx/compose/ui/test/SemanticsSelector;", "(Landroidx/compose/ui/test/TestContext;ZLandroidx/compose/ui/test/SemanticsSelector;)V", "lastSeenSemantics", "", "getSelector$ui_test_release", "()Landroidx/compose/ui/test/SemanticsSelector;", "getTestContext$ui_test_release", "()Landroidx/compose/ui/test/TestContext;", "getUseUnmergedTree$ui_test_release", "()Z", "assertDoesNotExist", "", "assertExists", "errorMessageOnFail", "fetchOneOrDie", "Landroidx/compose/ui/semantics/SemanticsNode;", "fetchSemanticsNode", "fetchSemanticsNodes", "Landroidx/compose/ui/test/SelectionResult;", "atLeastOneRootRequired", "fetchSemanticsNodes$ui_test_release", "getNodesInUnmergedTree", "", "ui-test_release"})
@StabilityInferred(parameters=0)
public final class SemanticsNodeInteraction {
    @NotNull
    private final TestContext testContext;
    private final boolean useUnmergedTree;
    @NotNull
    private final SemanticsSelector selector;
    @Nullable
    private String lastSeenSemantics;
    public static final int $stable = 8;

    public SemanticsNodeInteraction(@NotNull TestContext testContext, boolean useUnmergedTree, @NotNull SemanticsSelector selector) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.testContext = testContext;
        this.useUnmergedTree = useUnmergedTree;
        this.selector = selector;
    }

    @NotNull
    public final TestContext getTestContext$ui_test_release() {
        return this.testContext;
    }

    public final boolean getUseUnmergedTree$ui_test_release() {
        return this.useUnmergedTree;
    }

    @NotNull
    public final SemanticsSelector getSelector$ui_test_release() {
        return this.selector;
    }

    public SemanticsNodeInteraction(@NotNull TestContext testContext, boolean useUnmergedTree, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this(testContext, useUnmergedTree, SemanticsSelectorKt.SemanticsSelector(matcher));
    }

    @NotNull
    public final SelectionResult fetchSemanticsNodes$ui_test_release(boolean atLeastOneRootRequired, @Nullable String errorMessageOnFail) {
        Iterable<SemanticsNode> iterable = this.testContext.getAllSemanticsNodes$ui_test_release(atLeastOneRootRequired, this.useUnmergedTree);
        String string = errorMessageOnFail;
        if (string == null) {
            string = "";
        }
        return this.selector.map(iterable, string);
    }

    public static /* synthetic */ SelectionResult fetchSemanticsNodes$ui_test_release$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.fetchSemanticsNodes$ui_test_release(bl, string);
    }

    @NotNull
    public final SemanticsNode fetchSemanticsNode(@Nullable String errorMessageOnFail) {
        return this.fetchOneOrDie(errorMessageOnFail);
    }

    public static /* synthetic */ SemanticsNode fetchSemanticsNode$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.fetchSemanticsNode(string);
    }

    public final void assertDoesNotExist() {
        SelectionResult result = this.fetchSemanticsNodes$ui_test_release(false, "Failed: assertDoesNotExist.");
        if (!((Collection)result.getSelectedNodes()).isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch$default("Failed: assertDoesNotExist.", this.selector, result.getSelectedNodes(), 0, null, 16, null));
        }
    }

    @NotNull
    public final SemanticsNodeInteraction assertExists(@Nullable String errorMessageOnFail) {
        this.fetchOneOrDie(errorMessageOnFail);
        return this;
    }

    public static /* synthetic */ SemanticsNodeInteraction assertExists$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.assertExists(string);
    }

    private final SemanticsNode fetchOneOrDie(String errorMessageOnFail) {
        String finalErrorMessage;
        SelectionResult result;
        String string = errorMessageOnFail;
        if (string == null) {
            string = "Failed: assertExists.";
        }
        if (((Collection)(result = this.fetchSemanticsNodes$ui_test_release(true, finalErrorMessage = string)).getSelectedNodes()).size() != 1) {
            if (result.getSelectedNodes().isEmpty() && this.lastSeenSemantics != null) {
                String string2 = this.lastSeenSemantics;
                Intrinsics.checkNotNull((Object)string2);
                throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForNodeMissingInTree(finalErrorMessage, this.selector, string2));
            }
            if (result.getCustomErrorOnNoMatch() != null) {
                throw new AssertionError((Object)(finalErrorMessage + '\n' + result.getCustomErrorOnNoMatch()));
            }
            List<SemanticsNode> list = result.getSelectedNodes();
            SemanticsSelector semanticsSelector = this.selector;
            List<SemanticsNode> list2 = this.getNodesInUnmergedTree(errorMessageOnFail);
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(finalErrorMessage, semanticsSelector, list, 1, list2));
        }
        this.lastSeenSemantics = OutputKt.printToString$default((SemanticsNode)CollectionsKt.first(result.getSelectedNodes()), 0, 1, null);
        return (SemanticsNode)CollectionsKt.first(result.getSelectedNodes());
    }

    static /* synthetic */ SemanticsNode fetchOneOrDie$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.fetchOneOrDie(string);
    }

    private final List<SemanticsNode> getNodesInUnmergedTree(String errorMessageOnFail) {
        List<SemanticsNode> list;
        if (!this.useUnmergedTree) {
            Iterable<SemanticsNode> iterable = this.testContext.getAllSemanticsNodes$ui_test_release(true, true);
            String string = errorMessageOnFail;
            if (string == null) {
                string = "";
            }
            list = this.selector.map(iterable, string).getSelectedNodes();
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

