/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.selection;

import androidx.compose.ui.text.android.CharSequenceCharacterIterator;
import java.text.BreakIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/android/selection/WordIterator;", "", "charSequence", "", "start", "", "end", "locale", "Ljava/util/Locale;", "(Ljava/lang/CharSequence;IILjava/util/Locale;)V", "iterator", "Ljava/text/BreakIterator;", "checkOffsetIsValid", "", "offset", "getBeginning", "getPrevWordBeginningOnTwoWordsBoundary", "", "getEnd", "getNextWordEndOnTwoWordBoundary", "getPunctuationBeginning", "getPunctuationEnd", "isAfterLetterOrDigit", "isAfterPunctuation", "isOnLetterOrDigit", "isOnPunctuation", "isPunctuationEndBoundary", "isPunctuationStartBoundary", "nextBoundary", "prevBoundary", "Companion", "ui-text-android_release"})
public final class WordIterator {
    private final int start;
    private final int end;
    private final BreakIterator iterator;
    private final CharSequence charSequence;
    private static final int WINDOW_WIDTH = 50;
    public static final Companion Companion = new Companion(null);

    public final int nextBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.iterator.following(offset);
    }

    public final int prevBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.iterator.preceding(offset);
    }

    public final int getPrevWordBeginningOnTwoWordsBoundary(int offset) {
        return this.getBeginning(offset, true);
    }

    public final int getNextWordEndOnTwoWordBoundary(int offset) {
        return this.getEnd(offset, true);
    }

    public final int getPunctuationBeginning(int offset) {
        this.checkOffsetIsValid(offset);
        int result = offset;
        while (result != -1 && !this.isPunctuationStartBoundary(result)) {
            result = this.prevBoundary(result);
        }
        return result;
    }

    public final int getPunctuationEnd(int offset) {
        this.checkOffsetIsValid(offset);
        int result = offset;
        while (result != -1 && !this.isPunctuationEndBoundary(result)) {
            result = this.nextBoundary(result);
        }
        return result;
    }

    public final boolean isAfterPunctuation(int offset) {
        int n = offset;
        if (this.start + 1 <= n && this.end >= n) {
            int codePoint = Character.codePointBefore(this.charSequence, offset);
            return Companion.isPunctuation$ui_text_android_release(codePoint);
        }
        return false;
    }

    public final boolean isOnPunctuation(int offset) {
        int n = offset;
        if (this.start <= n && this.end > n) {
            int codePoint = Character.codePointAt(this.charSequence, offset);
            return Companion.isPunctuation$ui_text_android_release(codePoint);
        }
        return false;
    }

    private final int getBeginning(int offset, boolean getPrevWordBeginningOnTwoWordsBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isOnLetterOrDigit(offset)) {
            return this.iterator.isBoundary(offset) && (!this.isAfterLetterOrDigit(offset) || !getPrevWordBeginningOnTwoWordsBoundary) ? offset : this.iterator.preceding(offset);
        }
        if (this.isAfterLetterOrDigit(offset)) {
            return this.iterator.preceding(offset);
        }
        return -1;
    }

    private final int getEnd(int offset, boolean getNextWordEndOnTwoWordBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isAfterLetterOrDigit(offset)) {
            return this.iterator.isBoundary(offset) && (!this.isOnLetterOrDigit(offset) || !getNextWordEndOnTwoWordBoundary) ? offset : this.iterator.following(offset);
        }
        if (this.isOnLetterOrDigit(offset)) {
            return this.iterator.following(offset);
        }
        return -1;
    }

    private final boolean isPunctuationStartBoundary(int offset) {
        return this.isOnPunctuation(offset) && !this.isAfterPunctuation(offset);
    }

    private final boolean isPunctuationEndBoundary(int offset) {
        return !this.isOnPunctuation(offset) && this.isAfterPunctuation(offset);
    }

    private final boolean isAfterLetterOrDigit(int offset) {
        int codePoint;
        int n = offset;
        return this.start + 1 <= n && this.end >= n && Character.isLetterOrDigit(codePoint = Character.codePointBefore(this.charSequence, offset));
    }

    private final boolean isOnLetterOrDigit(int offset) {
        int codePoint;
        int n = offset;
        return this.start <= n && this.end > n && Character.isLetterOrDigit(codePoint = Character.codePointAt(this.charSequence, offset));
    }

    private final void checkOffsetIsValid(int offset) {
        int n = offset;
        n = this.start <= n && this.end >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid offset: " + offset + ". Valid range is [" + this.start + " , " + this.end + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public WordIterator(@NotNull CharSequence charSequence, int start, int end, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        this.charSequence = charSequence;
        int n = start;
        n = 0 <= n && this.charSequence.length() >= n ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "input start index is outside the CharSequence";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = end;
        n = 0 <= n && this.charSequence.length() >= n ? 1 : 0;
        n2 = 0;
        bl = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "input end index is outside the CharSequence";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance(locale);
        Intrinsics.checkNotNullExpressionValue((Object)breakIterator, (String)"BreakIterator.getWordInstance(locale)");
        this.iterator = breakIterator;
        n = 0;
        n2 = start - 50;
        bl = false;
        this.start = Math.max(n, n2);
        n = this.charSequence.length();
        n2 = end + 50;
        bl = false;
        this.end = Math.min(n, n2);
        this.iterator.setText(new CharSequenceCharacterIterator(this.charSequence, start, end));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/android/selection/WordIterator$Companion;", "", "()V", "WINDOW_WIDTH", "", "isPunctuation", "", "cp", "isPunctuation$ui_text_android_release", "ui-text-android_release"})
    public static final class Companion {
        public final boolean isPunctuation$ui_text_android_release(int cp) {
            int type = Character.getType(cp);
            return type == 23 || type == 20 || type == 22 || type == 30 || type == 29 || type == 24 || type == 21;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

