/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.text.Layout;
import android.text.Spanned;
import android.text.TextPaint;
import androidx.compose.ui.text.android.CharSequenceCharacterIterator;
import androidx.compose.ui.text.android.SpannedExtensionsKt;
import androidx.compose.ui.text.android.style.LetterSpacingSpanEm;
import androidx.compose.ui.text.android.style.LetterSpacingSpanPx;
import java.text.BreakIterator;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"minIntrinsicWidth", "", "text", "", "paint", "Landroid/text/TextPaint;", "shouldIncreaseMaxIntrinsic", "", "desiredWidth", "charSequence", "textPaint", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nLayoutIntrinsics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutIntrinsics.kt\nandroidx/compose/ui/text/android/LayoutIntrinsicsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1855#2,2:170\n*S KotlinDebug\n*F\n+ 1 LayoutIntrinsics.kt\nandroidx/compose/ui/text/android/LayoutIntrinsicsKt\n*L\n139#1:170,2\n*E\n"})
public final class LayoutIntrinsicsKt {
    public static final float minIntrinsicWidth(@NotNull CharSequence text, @NotNull TextPaint paint) {
        BreakIterator iterator = BreakIterator.getLineInstance(paint.getTextLocale());
        iterator.setText(new CharSequenceCharacterIterator(text, 0, text.length()));
        int heapSize = 10;
        PriorityQueue<Pair> longestWordCandidates = new PriorityQueue<Pair>(heapSize, LayoutIntrinsicsKt::minIntrinsicWidth$lambda$0);
        int start = 0;
        int end = 0;
        end = iterator.next();
        while (end != -1) {
            if (longestWordCandidates.size() < heapSize) {
                longestWordCandidates.add(new Pair((Object)start, (Object)end));
            } else if ((Pair)longestWordCandidates.peek() != null) {
                Pair minPair;
                boolean bl = false;
                if (((Number)minPair.getSecond()).intValue() - ((Number)minPair.getFirst()).intValue() < end - start) {
                    longestWordCandidates.poll();
                    longestWordCandidates.add(new Pair((Object)start, (Object)end));
                }
            }
            start = end;
            end = iterator.next();
        }
        float minWidth = 0.0f;
        Iterable $this$forEach$iv = longestWordCandidates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int start2 = ((Number)pair.component1()).intValue();
            int end2 = ((Number)pair.component2()).intValue();
            float width = Layout.getDesiredWidth((CharSequence)text, (int)start2, (int)end2, (TextPaint)paint);
            minWidth = Math.max(minWidth, width);
        }
        return minWidth;
    }

    private static final boolean shouldIncreaseMaxIntrinsic(float desiredWidth, CharSequence charSequence, TextPaint textPaint) {
        return !(desiredWidth == 0.0f) && (charSequence instanceof Spanned && (SpannedExtensionsKt.hasSpan((Spanned)charSequence, LetterSpacingSpanPx.class) || SpannedExtensionsKt.hasSpan((Spanned)charSequence, LetterSpacingSpanEm.class)) || !(textPaint.getLetterSpacing() == 0.0f));
    }

    private static final int minIntrinsicWidth$lambda$0(Pair left, Pair right) {
        return ((Number)left.getSecond()).intValue() - ((Number)left.getFirst()).intValue() - (((Number)right.getSecond()).intValue() - ((Number)right.getFirst()).intValue());
    }

    public static final /* synthetic */ boolean access$shouldIncreaseMaxIntrinsic(float desiredWidth, CharSequence charSequence, TextPaint textPaint) {
        return LayoutIntrinsicsKt.shouldIncreaseMaxIntrinsic(desiredWidth, charSequence, textPaint);
    }
}

