/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.animation;

import android.text.Layout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.CharSequenceCharacterIterator;
import androidx.compose.ui.text.android.LayoutCompat_androidKt;
import androidx.compose.ui.text.android.LayoutHelper;
import androidx.compose.ui.text.android.animation.Segment;
import androidx.compose.ui.text.android.animation.SegmentType;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/android/animation/SegmentBreaker;", "", "()V", "breakInWords", "", "", "layoutHelper", "Landroidx/compose/ui/text/android/LayoutHelper;", "breakOffsets", "segmentType", "Landroidx/compose/ui/text/android/animation/SegmentType;", "breakSegmentWithChar", "Landroidx/compose/ui/text/android/animation/Segment;", "dropSpaces", "", "breakSegmentWithDocument", "breakSegmentWithLine", "breakSegmentWithParagraph", "breakSegmentWithWord", "breakSegments", "breakWithBreakIterator", "text", "", "breaker", "Ljava/text/BreakIterator;", "ui-text_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nSegmentBreaker.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentBreaker.android.kt\nandroidx/compose/ui/text/android/animation/SegmentBreaker\n+ 2 ListUtils.android.kt\nandroidx/compose/ui/text/android/ListUtils_androidKt\n*L\n1#1,308:1\n33#2,6:309\n74#2,11:315\n74#2,11:326\n*S KotlinDebug\n*F\n+ 1 SegmentBreaker.android.kt\nandroidx/compose/ui/text/android/animation/SegmentBreaker\n*L\n61#1:309,6\n221#1:315,11\n270#1:326,11\n*E\n"})
public final class SegmentBreaker {
    @NotNull
    public static final SegmentBreaker INSTANCE = new SegmentBreaker();
    public static final int $stable;

    private SegmentBreaker() {
    }

    private final List<Integer> breakInWords(LayoutHelper layoutHelper2) {
        TreeSet<Integer> treeSet;
        CharSequence text = layoutHelper2.getLayout().getText();
        List<Integer> words = this.breakWithBreakIterator(text, BreakIterator.getLineInstance(Locale.getDefault()));
        TreeSet<Integer> $this$breakInWords_u24lambda_u241 = treeSet = new TreeSet<Integer>();
        boolean bl = false;
        List<Integer> $this$fastForEach$iv = words;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Integer item$iv = $this$fastForEach$iv.get(index$iv);
            int it = ((Number)item$iv).intValue();
            boolean bl2 = false;
            $this$breakInWords_u24lambda_u241.add(it);
        }
        TreeSet<Integer> set = treeSet;
        int n2 = layoutHelper2.getParagraphCount();
        for (int paraIndex = 0; paraIndex < n2; ++paraIndex) {
            Bidi bidi;
            if (layoutHelper2.analyzeBidi(paraIndex) == null) continue;
            int paragraphStart = layoutHelper2.getParagraphStart(paraIndex);
            int n3 = bidi.getRunCount();
            for (int i = 0; i < n3; ++i) {
                set.add(bidi.getRunStart(i) + paragraphStart);
            }
        }
        return CollectionsKt.toList((Iterable)set);
    }

    private final List<Integer> breakWithBreakIterator(CharSequence text, BreakIterator breaker) {
        CharSequenceCharacterIterator iter = new CharSequenceCharacterIterator(text, 0, text.length());
        Object[] objectArray = new Integer[]{0};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        breaker.setText(iter);
        while (breaker.next() != -1) {
            res.add(breaker.current());
        }
        return res;
    }

    @NotNull
    public final List<Integer> breakOffsets(@NotNull LayoutHelper layoutHelper2, @NotNull SegmentType segmentType) {
        Object object;
        Layout layout = layoutHelper2.getLayout();
        CharSequence text = layout.getText();
        switch (WhenMappings.$EnumSwitchMapping$0[segmentType.ordinal()]) {
            case 1: {
                Object[] objectArray = new Integer[]{0, text.length()};
                object = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object object2 = new Integer[]{0};
                Object it = object2 = CollectionsKt.mutableListOf((Object[])object2);
                boolean bl = false;
                int n = layoutHelper2.getParagraphCount();
                for (int i = 0; i < n; ++i) {
                    it.add(layoutHelper2.getParagraphEnd(i));
                }
                object = object2;
                break;
            }
            case 3: {
                Object object3 = new Integer[]{0};
                Object it = object3 = CollectionsKt.mutableListOf((Object[])object3);
                boolean bl = false;
                int n = layout.getLineCount();
                for (int i = 0; i < n; ++i) {
                    it.add(layout.getLineEnd(i));
                }
                object = object3;
                break;
            }
            case 4: {
                object = this.breakInWords(layoutHelper2);
                break;
            }
            case 5: {
                object = this.breakWithBreakIterator(text, BreakIterator.getCharacterInstance(Locale.getDefault()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @NotNull
    public final List<Segment> breakSegments(@NotNull LayoutHelper layoutHelper2, @NotNull SegmentType segmentType, boolean dropSpaces) {
        List<Segment> list;
        switch (WhenMappings.$EnumSwitchMapping$0[segmentType.ordinal()]) {
            case 1: {
                list = this.breakSegmentWithDocument(layoutHelper2);
                break;
            }
            case 2: {
                list = this.breakSegmentWithParagraph(layoutHelper2);
                break;
            }
            case 3: {
                list = this.breakSegmentWithLine(layoutHelper2, dropSpaces);
                break;
            }
            case 4: {
                list = this.breakSegmentWithWord(layoutHelper2, dropSpaces);
                break;
            }
            case 5: {
                list = this.breakSegmentWithChar(layoutHelper2, dropSpaces);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<Segment> breakSegmentWithDocument(LayoutHelper layoutHelper2) {
        return CollectionsKt.listOf((Object)new Segment(0, layoutHelper2.getLayout().getText().length(), 0, 0, layoutHelper2.getLayout().getWidth(), layoutHelper2.getLayout().getHeight()));
    }

    private final List<Segment> breakSegmentWithParagraph(LayoutHelper layoutHelper2) {
        List result2 = new ArrayList();
        Layout layout = layoutHelper2.getLayout();
        int n = layoutHelper2.getParagraphCount();
        for (int i = 0; i < n; ++i) {
            int paraStart = layoutHelper2.getParagraphStart(i);
            int paraEnd = layoutHelper2.getParagraphEnd(i);
            int paraFirstLine = LayoutCompat_androidKt.getLineForOffset(layout, paraStart, false);
            int paraLastLine = LayoutCompat_androidKt.getLineForOffset(layout, paraEnd, true);
            result2.add(new Segment(paraStart, paraEnd, 0, layout.getLineTop(paraFirstLine), layout.getWidth(), layout.getLineBottom(paraLastLine)));
        }
        return result2;
    }

    private final List<Segment> breakSegmentWithLine(LayoutHelper layoutHelper2, boolean dropSpaces) {
        List result2 = new ArrayList();
        Layout layout = layoutHelper2.getLayout();
        int n = layoutHelper2.getLayout().getLineCount();
        for (int i = 0; i < n; ++i) {
            result2.add(new Segment(layout.getLineStart(i), layout.getLineEnd(i), dropSpaces ? (int)Math.ceil(layout.getLineLeft(i)) : 0, layout.getLineTop(i), dropSpaces ? (int)Math.ceil(layout.getLineRight(i)) : layout.getWidth(), layout.getLineBottom(i)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithWord(LayoutHelper layoutHelper2, boolean dropSpaces) {
        List list;
        Layout layout = layoutHelper2.getLayout();
        int wsWidth = (int)Math.ceil(layout.getPaint().measureText(" "));
        List<Integer> $this$fastZipWithNext$iv = this.breakOffsets(layoutHelper2, SegmentType.Word);
        boolean $i$f$fastZipWithNext = false;
        if ($this$fastZipWithNext$iv.size() == 0 || $this$fastZipWithNext$iv.size() == 1) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Integer current$iv = $this$fastZipWithNext$iv.get(0);
            int n = CollectionsKt.getLastIndex($this$fastZipWithNext$iv);
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                int lineEnd;
                void end;
                void start;
                Integer next$iv = $this$fastZipWithNext$iv.get(i$iv + 1);
                int n2 = ((Number)next$iv).intValue();
                int n3 = ((Number)current$iv).intValue();
                List list2 = result$iv;
                boolean bl = false;
                int lineNo = LayoutCompat_androidKt.getLineForOffset(layout, (int)start, false);
                boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                boolean runRtl = layout.isRtlCharAt((int)start);
                int startPos = (int)Math.ceil(layoutHelper2.getHorizontalPosition((int)start, runRtl == paraRTL, false));
                int endPos = (int)Math.ceil(layoutHelper2.getHorizontalPosition((int)end, runRtl == paraRTL, true));
                int left = Math.min(startPos, endPos);
                int right = Math.max(startPos, endPos);
                if (dropSpaces && end != false && layout.getText().charAt((int)(end - true)) == ' ' && (lineEnd = layout.getLineEnd(lineNo)) != end) {
                    if (runRtl) {
                        left += wsWidth;
                    } else {
                        right -= wsWidth;
                    }
                }
                list2.add(new Segment((int)start, (int)end, left, layout.getLineTop(lineNo), right, layout.getLineBottom(lineNo)));
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> breakSegmentWithChar(LayoutHelper layoutHelper2, boolean dropSpaces) {
        List res = new ArrayList();
        List<Integer> $this$fastZipWithNext$iv = this.breakOffsets(layoutHelper2, SegmentType.Character);
        boolean $i$f$fastZipWithNext = false;
        if ($this$fastZipWithNext$iv.size() == 0 || $this$fastZipWithNext$iv.size() == 1) {
            CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Integer current$iv = $this$fastZipWithNext$iv.get(0);
            int n = CollectionsKt.getLastIndex($this$fastZipWithNext$iv);
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void start;
                void end;
                Integer next$iv = $this$fastZipWithNext$iv.get(i$iv + 1);
                int n2 = ((Number)next$iv).intValue();
                int n3 = ((Number)current$iv).intValue();
                List list = result$iv;
                boolean bl = false;
                Layout layout = layoutHelper2.getLayout();
                if (!dropSpaces || end != start + true || !layoutHelper2.isLineEndSpace(layout.getText().charAt((int)start))) {
                    int lineNo = LayoutCompat_androidKt.getLineForOffset(layout, (int)start, false);
                    boolean paraRTL = layout.getParagraphDirection(lineNo) == -1;
                    boolean runRtl = layout.isRtlCharAt((int)start);
                    int startPos = (int)Math.ceil(layoutHelper2.getHorizontalPosition((int)start, runRtl == paraRTL, false));
                    int endPos = (int)Math.ceil(layoutHelper2.getHorizontalPosition((int)end, runRtl == paraRTL, true));
                    res.add(new Segment((int)start, (int)end, Math.min(startPos, endPos), layout.getLineTop(lineNo), Math.max(startPos, endPos), layout.getLineBottom(lineNo)));
                }
                list.add(Unit.INSTANCE);
                current$iv = next$iv;
            }
        }
        return res;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SegmentType.values().length];
            try {
                nArray[SegmentType.Document.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.Paragraph.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.Line.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.Word.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.Character.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

