/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 :2\u00020\u0001:\u00039:;B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0096\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J$\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0007J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000J\u0016\u0010-\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\u001e\u0010.\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\b\u0010/\u001a\u00020\u0013H\u0016J\u0011\u00100\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0087\u0002J\u0018\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J\u0018\u00101\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u00020\u0003H\u0016R$\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\"\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "spanStylesOrNull", "paragraphStylesOrNull", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text_release", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getParagraphStylesOrNull$ui_text_release", "getSpanStyles", "getSpanStylesOrNull$ui_text_release", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getLinkAnnotations", "Landroidx/compose/ui/text/LinkAnnotation;", "start", "end", "getStringAnnotations", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "hasEqualsAnnotations", "hasLinkAnnotations", "hasStringAnnotations", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Companion", "Range", "ui-text_release"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1253:1\n1045#2:1254\n33#3,6:1255\n235#3,3:1262\n33#3,4:1265\n238#3,2:1269\n38#3:1271\n240#3:1272\n101#3,2:1273\n33#3,6:1275\n103#3:1281\n235#3,3:1282\n33#3,4:1285\n238#3,2:1289\n38#3:1291\n240#3:1292\n235#3,3:1293\n33#3,4:1296\n238#3,2:1300\n38#3:1302\n240#3:1303\n235#3,3:1304\n33#3,4:1307\n238#3,2:1311\n38#3:1313\n240#3:1314\n235#3,3:1315\n33#3,4:1318\n238#3,2:1322\n38#3:1324\n240#3:1325\n101#3,2:1326\n33#3,6:1328\n103#3:1334\n1#4:1261\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n88#1:1254\n88#1:1255,6\n161#1:1262,3\n161#1:1265,4\n161#1:1269,2\n161#1:1271\n161#1:1272\n169#1:1273,2\n169#1:1275,6\n169#1:1281\n184#1:1282,3\n184#1:1285,4\n184#1:1289,2\n184#1:1291\n184#1:1292\n199#1:1293,3\n199#1:1296,4\n199#1:1300,2\n199#1:1302\n199#1:1303\n215#1:1304,3\n215#1:1307,4\n215#1:1311,2\n215#1:1313\n215#1:1314\n230#1:1315,3\n230#1:1318,4\n230#1:1322,2\n230#1:1324\n230#1:1325\n238#1:1326,2\n238#1:1328,6\n238#1:1334\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @Nullable
    private final List<Range<SpanStyle>> spanStylesOrNull;
    @Nullable
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    @Nullable
    private final List<Range<? extends Object>> annotations;
    public static final int $stable;
    @NotNull
    private static final Saver<AnnotatedString, ?> Saver;

    public AnnotatedString(@NotNull String text, @Nullable List<Range<SpanStyle>> spanStylesOrNull, @Nullable List<Range<ParagraphStyle>> paragraphStylesOrNull, @Nullable List<? extends Range<? extends Object>> annotations) {
        block4: {
            this.text = text;
            this.spanStylesOrNull = spanStylesOrNull;
            this.paragraphStylesOrNull = paragraphStylesOrNull;
            this.annotations = annotations;
            int lastStyleEnd = 0;
            lastStyleEnd = -1;
            List list = this.paragraphStylesOrNull;
            if (list == null) break block4;
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (Range)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            });
            if (list != null) {
                List $this$fastForEach$iv = list;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Object item$iv = $this$fastForEach$iv.get(index$iv);
                    Range paragraphStyle = (Range)item$iv;
                    boolean bl = false;
                    if (!(paragraphStyle.getStart() >= lastStyleEnd)) {
                        boolean $i$a$-require-AnnotatedString$4$32 = false;
                        String $i$a$-require-AnnotatedString$4$32 = "ParagraphStyle should not overlap";
                        throw new IllegalArgumentException($i$a$-require-AnnotatedString$4$32.toString());
                    }
                    if (!(paragraphStyle.getEnd() <= this.text.length())) {
                        boolean bl2 = false;
                        String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                        throw new IllegalArgumentException(string.toString());
                    }
                    lastStyleEnd = paragraphStyle.getEnd();
                }
            }
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            list3 = null;
        }
        this(string, list, list2, list3);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text_release() {
        return this.spanStylesOrNull;
    }

    @Nullable
    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text_release() {
        return this.paragraphStylesOrNull;
    }

    @Nullable
    public final List<Range<? extends Object>> getAnnotations$ui_text_release() {
        return this.annotations;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        List list = this.spanStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list = this.paragraphStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Collection collection;
        Collection collection2;
        List list;
        AnnotatedString annotatedString;
        String string;
        AnnotatedString annotatedString2 = this;
        String string2 = text;
        Collection collection3 = spanStyles;
        if (collection3.isEmpty()) {
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            list = null;
            annotatedString2 = annotatedString;
            string2 = string;
            collection2 = list;
        } else {
            collection2 = collection3;
        }
        List list2 = (List)collection2;
        collection3 = paragraphStyles;
        if (collection3.isEmpty()) {
            list = list2;
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            Object var9_9 = null;
            annotatedString2 = annotatedString;
            string2 = string;
            list2 = list;
            collection = var9_9;
        } else {
            collection = collection3;
        }
        annotatedString2(string2, list2, (List)collection, null);
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index) {
        return this.text.charAt(index);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String text = string;
        return new AnnotatedString(text, AnnotatedStringKt.access$filterRanges(this.spanStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.paragraphStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex));
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long range2) {
        return this.subSequence(TextRange.getMin-impl(range2), TextRange.getMax-impl(range2));
    }

    @Stable
    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Builder $this$plus_u24lambda_u247 = new Builder(this);
        boolean bl = false;
        $this$plus_u24lambda_u247.append(other);
        return $this$plus_u24lambda_u247.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list;
    }

    public final boolean hasStringAnnotations(@NotNull String tag, int start, int end) {
        boolean bl;
        block3: {
            List<Range<? extends Object>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Object>> $this$fastAny$iv = list;
                boolean $i$f$fastAny = false;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> item$iv$iv;
                    Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Object> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list;
    }

    @NotNull
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.TtsAnnotation>>");
        return list;
    }

    @ExperimentalTextApi
    @NotNull
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list;
    }

    @NotNull
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start, int end) {
        List list;
        List<Range<? extends Object>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list;
    }

    public final boolean hasLinkAnnotations(int start, int end) {
        boolean bl;
        block3: {
            List<Range<? extends Object>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Object>> $this$fastAny$iv = list;
                boolean $i$f$fastAny = false;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> item$iv$iv;
                    Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Object> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStylesOrNull, ((AnnotatedString)other).spanStylesOrNull)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStylesOrNull, ((AnnotatedString)other).paragraphStylesOrNull)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        List<Range<SpanStyle>> list = this.spanStylesOrNull;
        result2 = 31 * result2 + (list != null ? ((Object)list).hashCode() : 0);
        List<Range<ParagraphStyle>> list2 = this.paragraphStylesOrNull;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        List<Range<? extends Object>> list3 = this.annotations;
        result2 = 31 * result2 + (list3 != null ? ((Object)list3).hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    public final boolean hasEqualsAnnotations(@NotNull AnnotatedString other) {
        return Intrinsics.areEqual(this.annotations, other.annotations);
    }

    static {
        Saver = SaversKt.getAnnotatedStringSaver();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ&\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ \u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J \u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0006J\u001e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/H\u0016J\"\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\b,J\u0006\u00101\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0013J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0015J\u000e\u00108\u001a\u00020\t2\u0006\u0010'\u001a\u00020(J\u0010\u00109\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0007J\u0006\u0010:\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addLink", "", "clickable", "Landroidx/compose/ui/text/LinkAnnotation$Clickable;", "start", "end", "url", "Landroidx/compose/ui/text/LinkAnnotation$Url;", "addStringAnnotation", "tag", "annotation", "addStyle", "style", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "append", "char", "", "", "deprecated_append_returning_void", "pop", "index", "pushLink", "link", "Landroidx/compose/ui/text/LinkAnnotation;", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "pushUrlAnnotation", "toAnnotatedString", "MutableRange", "ui-text_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1253:1\n33#2,6:1254\n33#2,6:1260\n33#2,6:1266\n33#2,6:1272\n33#2,6:1278\n33#2,6:1284\n151#2,3:1291\n33#2,4:1294\n154#2,2:1298\n38#2:1300\n156#2:1301\n151#2,3:1302\n33#2,4:1305\n154#2,2:1309\n38#2:1311\n156#2:1312\n151#2,3:1313\n33#2,4:1316\n154#2,2:1320\n38#2:1322\n156#2:1323\n1#3:1290\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n435#1:1254,6\n438#1:1260,6\n442#1:1266,6\n462#1:1272,6\n465#1:1278,6\n469#1:1284,6\n735#1:1291,3\n735#1:1294,4\n735#1:1298,2\n735#1:1300\n735#1:1301\n738#1:1302,3\n738#1:1305,4\n738#1:1309,2\n738#1:1311\n738#1:1312\n741#1:1313,3\n741#1:1316,4\n741#1:1320,2\n741#1:1322\n741#1:1323\n*E\n"})
    public static final class Builder
    implements Appendable {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<SpanStyle>> spanStyles;
        @NotNull
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        @NotNull
        private final List<MutableRange<? extends Object>> annotations;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;
        public static final int $stable = 8;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            this.spanStyles = new ArrayList();
            this.paragraphStyles = new ArrayList();
            this.annotations = new ArrayList();
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text) {
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            this(0, 1, null);
            this.append(text);
        }

        public final int getLength() {
            return this.text.length();
        }

        public final void append(@NotNull String text) {
            this.text.append(text);
        }

        @Deprecated(message="Replaced by the append(Char) method that returns an Appendable. This method must be kept around for binary compatibility.", level=DeprecationLevel.HIDDEN)
        @JvmName(name="append")
        public final /* synthetic */ void append(char c) {
            this.append(c);
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text);
            } else {
                this.text.append(text);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text, int start, int end) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text, start, end);
            } else {
                this.text.append(text, start, end);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(char c) {
            this.text.append(c);
            return this;
        }

        public final void append(@NotNull AnnotatedString text) {
            block5: {
                Range<Object> it;
                Range<Object> item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List<Range<Object>> $this$fastForEach$iv;
                int start = this.text.length();
                this.text.append(text.getText());
                List<Range<SpanStyle>> list = text.getSpanStylesOrNull$ui_text_release();
                if (list != null) {
                    $this$fastForEach$iv = list;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                    }
                }
                List<Range<ParagraphStyle>> list2 = text.getParagraphStylesOrNull$ui_text_release();
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                    }
                }
                List<Range<? extends Object>> list3 = text.getAnnotations$ui_text_release();
                if (list3 == null) break block5;
                $this$fastForEach$iv = list3;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<Object>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void append(@NotNull AnnotatedString text, int start, int end) {
            block5: {
                Range it;
                Object item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List $this$fastForEach$iv;
                int insertionStart = this.text.length();
                this.text.append(text.getText(), start, end);
                List list = AnnotatedStringKt.access$getLocalSpanStyles(text, start, end);
                if (list != null) {
                    $this$fastForEach$iv = list;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list2 = AnnotatedStringKt.access$getLocalParagraphStyles(text, start, end);
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list3 = AnnotatedStringKt.access$getLocalAnnotations(text, start, end);
                if (list3 == null) break block5;
                $this$fastForEach$iv = list3;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    item$iv = $this$fastForEach$iv.get(index$iv);
                    it = (Range)item$iv;
                    boolean bl = false;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start, int end) {
            this.spanStyles.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end) {
            this.paragraphStyles.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStringAnnotation(@NotNull String tag, @NotNull String annotation, int start, int end) {
            this.annotations.add(new MutableRange<String>(annotation, start, end, tag));
        }

        @ExperimentalTextApi
        public final void addTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation, int start, int end) {
            this.annotations.add(new MutableRange(ttsAnnotation, start, end, null, 8, null));
        }

        @ExperimentalTextApi
        public final void addUrlAnnotation(@NotNull UrlAnnotation urlAnnotation, int start, int end) {
            this.annotations.add(new MutableRange(urlAnnotation, start, end, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Url url, int start, int end) {
            this.annotations.add(new MutableRange(url, start, end, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Clickable clickable, int start, int end) {
            this.annotations.add(new MutableRange(clickable, start, end, null, 8, null));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.spanStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(annotation, this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        @ExperimentalTextApi
        public final int pushUrlAnnotation(@NotNull UrlAnnotation urlAnnotation) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(urlAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushLink(@NotNull LinkAnnotation link) {
            MutableRange mutableRange;
            MutableRange it = mutableRange = new MutableRange(link, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            if (!(!((Collection)this.styleStack).isEmpty())) {
                boolean bl = false;
                String string = "Nothing to pop.";
                throw new IllegalStateException(string.toString());
            }
            MutableRange<? extends Object> item = this.styleStack.remove(this.styleStack.size() - 1);
            item.setEnd(this.text.length());
        }

        public final void pop(int index) {
            if (!(index < this.styleStack.size())) {
                boolean bl = false;
                String string = index + " should be less than " + this.styleStack.size();
                throw new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index) {
                this.pop();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            Collection<MutableRange<SpanStyle>> collection;
            Collection collection2;
            Collection collection3;
            Collection collection4;
            List<MutableRange<ParagraphStyle>> list;
            MutableRange it;
            Collection collection5;
            boolean bl;
            Object it$iv;
            Object item$iv$iv;
            int index$iv$iv;
            Collection<MutableRange<ParagraphStyle>> $this$fastMap$iv;
            Collection<MutableRange<SpanStyle>> collection6 = this.spanStyles;
            String string = this.text.toString();
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            Collection<MutableRange<ParagraphStyle>> $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                MutableRange mutableRange = (MutableRange)it$iv;
                collection5 = target$iv;
                boolean bl2 = false;
                collection5.add(it.toRange(this.text.length()));
            }
            String string2 = string;
            $this$fastMap$iv = target$iv;
            if ($this$fastMap$iv.isEmpty()) {
                string = string2;
                boolean bl3 = false;
                list = null;
                string2 = string;
            } else {
                list = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.paragraphStyles;
            collection5 = list;
            string = string2;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection4 = target$iv;
                boolean bl4 = false;
                collection4.add(it.toRange(this.text.length()));
            }
            collection4 = target$iv;
            String string3 = string;
            Collection collection7 = collection5;
            $this$fastMap$iv = collection4;
            if ($this$fastMap$iv.isEmpty()) {
                collection5 = collection7;
                string = string3;
                boolean bl5 = false;
                collection4 = null;
                string3 = string;
                collection7 = collection5;
                collection3 = collection4;
            } else {
                collection3 = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.annotations;
            collection4 = (List)collection3;
            collection5 = collection7;
            string = string3;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection2 = target$iv;
                boolean bl6 = false;
                collection2.add(it.toRange(this.text.length()));
            }
            collection2 = target$iv;
            String string4 = string;
            Collection collection8 = collection5;
            Collection collection9 = collection4;
            collection6 = collection2;
            if (collection6.isEmpty()) {
                collection4 = collection9;
                collection5 = collection8;
                string = string4;
                boolean bl7 = false;
                collection2 = null;
                string4 = string;
                collection8 = collection5;
                collection9 = collection4;
                collection = collection2;
            } else {
                collection = collection6;
            }
            List list2 = (List)collection;
            Collection collection10 = collection9;
            Collection collection11 = collection8;
            String string5 = string4;
            return new AnnotatedString(string5, (List<Range<SpanStyle>>)collection11, (List<Range<ParagraphStyle>>)collection10, list2);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text_release"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1253:1\n1#2:1254\n*E\n"})
        private static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item, int start, int end, @NotNull String tag) {
                this.item = item;
                this.start = start;
                this.end = end;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                if (!(end != Integer.MIN_VALUE)) {
                    boolean bl = false;
                    String string = "Item.end should be set first";
                    throw new IllegalStateException(string.toString());
                }
                return new Range<T>(this.item, this.start, end, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.tag;
            }

            @NotNull
            public final MutableRange<T> copy(T item, int start, int end, @NotNull String tag) {
                return new MutableRange<T>(item, start, end, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public int hashCode() {
                int result2 = this.item == null ? 0 : this.item.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.end);
                result2 = result2 * 31 + this.tag.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/ui/text/AnnotatedString;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<AnnotatedString, ?> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text_release"})
    @Immutable
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1253:1\n1#2:1254\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;
        public static final int $stable;

        public Range(T item, int start, int end, @NotNull String tag) {
            this.item = item;
            this.start = start;
            this.end = end;
            this.tag = tag;
            if (!(this.start <= this.end)) {
                boolean bl = false;
                String string = "Reversed range is not supported";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item, int start, int end) {
            this(item, start, end, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Range<T> copy(T item, int start, int end, @NotNull String tag) {
            return new Range<T>(item, start, end, tag);
        }

        public static /* synthetic */ Range copy$default(Range range2, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range2.item;
            }
            if ((n3 & 2) != 0) {
                n = range2.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range2.end;
            }
            if ((n3 & 8) != 0) {
                string = range2.tag;
            }
            return range2.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result2 = this.item == null ? 0 : this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + this.tag.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range2 = (Range)other;
            if (!Intrinsics.areEqual(this.item, range2.item)) {
                return false;
            }
            if (this.start != range2.start) {
                return false;
            }
            if (this.end != range2.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range2.tag);
        }
    }
}

