/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import android.graphics.Typeface;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotationContentHandler;
import androidx.compose.ui.text.AnnotationSpan;
import androidx.compose.ui.text.Html_androidKt;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.LinkInteractionListener;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.font.AndroidTypeface_androidKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.TextUnitKt;
import androidx.core.text.HtmlCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000g\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002\u001aV\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001aF\u0010\u0018\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001aN\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001aH\u0010\u001f\u001a\u00020\u001c*\u00020\u001a2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0001\u001a\f\u0010 \u001a\u00020!*\u00020\"H\u0002\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0012*\u00020$H\u0002\u001a\f\u0010#\u001a\u00020\u0012*\u00020%H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006&"}, d2={"AnnotationTag", "", "ContentHandlerReplacementTag", "TagHandler", "androidx/compose/ui/text/Html_androidKt$TagHandler$1", "Landroidx/compose/ui/text/Html_androidKt$TagHandler$1;", "optionalFontFamilyFromName", "Landroidx/compose/ui/text/font/FontFamily;", "familyName", "addSpan", "", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "span", "", "start", "", "end", "linkStyle", "Landroidx/compose/ui/text/SpanStyle;", "linkFocusedStyle", "linkHoveredStyle", "linkPressedStyle", "linkInteractionListener", "Landroidx/compose/ui/text/LinkInteractionListener;", "addSpans", "spanned", "Landroid/text/Spanned;", "fromHtml", "Landroidx/compose/ui/text/AnnotatedString;", "Landroidx/compose/ui/text/AnnotatedString$Companion;", "htmlString", "toAnnotatedString", "toParagraphStyle", "Landroidx/compose/ui/text/ParagraphStyle;", "Landroid/text/style/AlignmentSpan;", "toSpanStyle", "Landroid/text/style/StyleSpan;", "Landroid/text/style/TypefaceSpan;", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nHtml.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Html.android.kt\nandroidx/compose/ui/text/Html_androidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,319:1\n1#2:320\n13579#3,2:321\n*S KotlinDebug\n*F\n+ 1 Html.android.kt\nandroidx/compose/ui/text/Html_androidKt\n*L\n107#1:321,2\n*E\n"})
public final class Html_androidKt {
    @NotNull
    private static final TagHandler.1 TagHandler = new Html.TagHandler(){

        public void handleTag(boolean opening, @Nullable String tag, @Nullable Editable output, @Nullable XMLReader xmlReader) {
            if (xmlReader == null || output == null) {
                return;
            }
            if (opening && Intrinsics.areEqual((Object)tag, (Object)"ContentHandlerReplacementTag")) {
                ContentHandler currentContentHandler = xmlReader.getContentHandler();
                xmlReader.setContentHandler(new AnnotationContentHandler(currentContentHandler, output));
            }
        }
    };
    @NotNull
    private static final String ContentHandlerReplacementTag = "ContentHandlerReplacementTag";
    @NotNull
    private static final String AnnotationTag = "annotation";

    @NotNull
    public static final AnnotatedString fromHtml(@NotNull AnnotatedString.Companion $this$fromHtml, @NotNull String htmlString, @Nullable SpanStyle linkStyle, @Nullable SpanStyle linkFocusedStyle, @Nullable SpanStyle linkHoveredStyle, @Nullable SpanStyle linkPressedStyle, @Nullable LinkInteractionListener linkInteractionListener) {
        String stringToParse = "<ContentHandlerReplacementTag />" + htmlString;
        Spanned spanned = HtmlCompat.fromHtml((String)stringToParse, (int)63, null, (Html.TagHandler)TagHandler);
        return Html_androidKt.toAnnotatedString(spanned, linkStyle, linkFocusedStyle, linkHoveredStyle, linkPressedStyle, linkInteractionListener);
    }

    public static /* synthetic */ AnnotatedString fromHtml$default(AnnotatedString.Companion companion, String string, SpanStyle spanStyle, SpanStyle spanStyle2, SpanStyle spanStyle3, SpanStyle spanStyle4, LinkInteractionListener linkInteractionListener, int n, Object object) {
        if ((n & 2) != 0) {
            spanStyle = null;
        }
        if ((n & 4) != 0) {
            spanStyle2 = null;
        }
        if ((n & 8) != 0) {
            spanStyle3 = null;
        }
        if ((n & 0x10) != 0) {
            spanStyle4 = null;
        }
        if ((n & 0x20) != 0) {
            linkInteractionListener = null;
        }
        return Html_androidKt.fromHtml(companion, string, spanStyle, spanStyle2, spanStyle3, spanStyle4, linkInteractionListener);
    }

    @VisibleForTesting
    @NotNull
    public static final AnnotatedString toAnnotatedString(@NotNull Spanned $this$toAnnotatedString, @Nullable SpanStyle linkStyle, @Nullable SpanStyle linkFocusedStyle, @Nullable SpanStyle linkHoveredStyle, @Nullable SpanStyle linkPressedStyle, @Nullable LinkInteractionListener linkInteractionListener) {
        AnnotatedString.Builder builder;
        AnnotatedString.Builder it = builder = new AnnotatedString.Builder($this$toAnnotatedString.length()).append((CharSequence)$this$toAnnotatedString);
        boolean bl = false;
        Html_androidKt.addSpans(it, $this$toAnnotatedString, linkStyle, linkFocusedStyle, linkHoveredStyle, linkPressedStyle, linkInteractionListener);
        return builder.toAnnotatedString();
    }

    public static /* synthetic */ AnnotatedString toAnnotatedString$default(Spanned spanned, SpanStyle spanStyle, SpanStyle spanStyle2, SpanStyle spanStyle3, SpanStyle spanStyle4, LinkInteractionListener linkInteractionListener, int n, Object object) {
        if ((n & 1) != 0) {
            spanStyle = null;
        }
        if ((n & 2) != 0) {
            spanStyle2 = null;
        }
        if ((n & 4) != 0) {
            spanStyle3 = null;
        }
        if ((n & 8) != 0) {
            spanStyle4 = null;
        }
        if ((n & 0x10) != 0) {
            linkInteractionListener = null;
        }
        return Html_androidKt.toAnnotatedString(spanned, spanStyle, spanStyle2, spanStyle3, spanStyle4, linkInteractionListener);
    }

    private static final void addSpans(AnnotatedString.Builder $this$addSpans, Spanned spanned, SpanStyle linkStyle, SpanStyle linkFocusedStyle, SpanStyle linkHoveredStyle, SpanStyle linkPressedStyle, LinkInteractionListener linkInteractionListener) {
        Object[] $this$forEach$iv = spanned.getSpans(0, $this$addSpans.getLength(), Object.class);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object span = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            long range2 = TextRangeKt.TextRange(spanned.getSpanStart(span), spanned.getSpanEnd(span));
            Html_androidKt.addSpan($this$addSpans, span, TextRange.getStart-impl(range2), TextRange.getEnd-impl(range2), linkStyle, linkFocusedStyle, linkHoveredStyle, linkPressedStyle, linkInteractionListener);
        }
    }

    private static final void addSpan(AnnotatedString.Builder $this$addSpan, Object span, int start, int end, SpanStyle linkStyle, SpanStyle linkFocusedStyle, SpanStyle linkHoveredStyle, SpanStyle linkPressedStyle, LinkInteractionListener linkInteractionListener) {
        block1: {
            Object object;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block3: {
                                                    block2: {
                                                        object = span;
                                                        if (object instanceof AbsoluteSizeSpan) break block1;
                                                        if (!(object instanceof AlignmentSpan)) break block2;
                                                        $this$addSpan.addStyle(Html_androidKt.toParagraphStyle((AlignmentSpan)span), start, end);
                                                        break block1;
                                                    }
                                                    if (!(object instanceof AnnotationSpan)) break block3;
                                                    $this$addSpan.addStringAnnotation(((AnnotationSpan)span).getKey(), ((AnnotationSpan)span).getValue(), start, end);
                                                    break block1;
                                                }
                                                if (!(object instanceof BackgroundColorSpan)) break block4;
                                                $this$addSpan.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, ColorKt.Color((int)((BackgroundColorSpan)span).getBackgroundColor()), null, null, null, null, 63487, null), start, end);
                                                break block1;
                                            }
                                            if (!(object instanceof ForegroundColorSpan)) break block5;
                                            $this$addSpan.addStyle(new SpanStyle(ColorKt.Color((int)((ForegroundColorSpan)span).getForegroundColor()), 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65534, null), start, end);
                                            break block1;
                                        }
                                        if (!(object instanceof RelativeSizeSpan)) break block6;
                                        $this$addSpan.addStyle(new SpanStyle(0L, TextUnitKt.getEm((float)((RelativeSizeSpan)span).getSizeChange()), null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65533, null), start, end);
                                        break block1;
                                    }
                                    if (!(object instanceof StrikethroughSpan)) break block7;
                                    $this$addSpan.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, TextDecoration.Companion.getLineThrough(), null, null, null, 61439, null), start, end);
                                    break block1;
                                }
                                if (!(object instanceof StyleSpan)) break block8;
                                SpanStyle spanStyle = Html_androidKt.toSpanStyle((StyleSpan)span);
                                if (spanStyle == null) break block1;
                                SpanStyle it = spanStyle;
                                boolean bl = false;
                                $this$addSpan.addStyle(it, start, end);
                                break block1;
                            }
                            if (!(object instanceof SubscriptSpan)) break block9;
                            $this$addSpan.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, BaselineShift.box-impl(BaselineShift.Companion.getSubscript-y9eOQZs()), null, null, 0L, null, null, null, null, 65279, null), start, end);
                            break block1;
                        }
                        if (!(object instanceof SuperscriptSpan)) break block10;
                        $this$addSpan.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, BaselineShift.box-impl(BaselineShift.Companion.getSuperscript-y9eOQZs()), null, null, 0L, null, null, null, null, 65279, null), start, end);
                        break block1;
                    }
                    if (!(object instanceof TypefaceSpan)) break block11;
                    $this$addSpan.addStyle(Html_androidKt.toSpanStyle((TypefaceSpan)span), start, end);
                    break block1;
                }
                if (!(object instanceof UnderlineSpan)) break block12;
                $this$addSpan.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, TextDecoration.Companion.getUnderline(), null, null, null, 61439, null), start, end);
                break block1;
            }
            if (!(object instanceof URLSpan)) break block1;
            String string = ((URLSpan)span).getURL();
            if (string != null) {
                String url = string;
                boolean bl = false;
                LinkAnnotation.Url link = new LinkAnnotation.Url(url, linkStyle, linkFocusedStyle, linkHoveredStyle, linkPressedStyle, linkInteractionListener);
                $this$addSpan.addLink(link, start, end);
            }
        }
    }

    private static final ParagraphStyle toParagraphStyle(AlignmentSpan $this$toParagraphStyle) {
        int n;
        Layout.Alignment alignment = $this$toParagraphStyle.getAlignment();
        switch (alignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 1: {
                n = TextAlign.Companion.getStart-e0LSkKk();
                break;
            }
            case 2: {
                n = TextAlign.Companion.getCenter-e0LSkKk();
                break;
            }
            case 3: {
                n = TextAlign.Companion.getEnd-e0LSkKk();
                break;
            }
            default: {
                n = TextAlign.Companion.getUnspecified-e0LSkKk();
            }
        }
        int alignment2 = n;
        return new ParagraphStyle(alignment2, 0, 0L, null, null, null, 0, 0, null, 510, null);
    }

    private static final SpanStyle toSpanStyle(StyleSpan $this$toSpanStyle) {
        SpanStyle spanStyle;
        switch ($this$toSpanStyle.getStyle()) {
            case 1: {
                spanStyle = new SpanStyle(0L, 0L, FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65531, null);
                break;
            }
            case 2: {
                spanStyle = new SpanStyle(0L, 0L, null, FontStyle.box-impl(FontStyle.Companion.getItalic-_-LCdwA()), null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65527, null);
                break;
            }
            case 3: {
                spanStyle = new SpanStyle(0L, 0L, FontWeight.Companion.getBold(), FontStyle.box-impl(FontStyle.Companion.getItalic-_-LCdwA()), null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65523, null);
                break;
            }
            default: {
                spanStyle = null;
            }
        }
        return spanStyle;
    }

    private static final SpanStyle toSpanStyle(TypefaceSpan $this$toSpanStyle) {
        String string = $this$toSpanStyle.getFamily();
        FontFamily fontFamily = Intrinsics.areEqual((Object)string, (Object)FontFamily.Companion.getCursive().getName()) ? (FontFamily)FontFamily.Companion.getCursive() : (Intrinsics.areEqual((Object)string, (Object)FontFamily.Companion.getMonospace().getName()) ? (FontFamily)FontFamily.Companion.getMonospace() : (Intrinsics.areEqual((Object)string, (Object)FontFamily.Companion.getSansSerif().getName()) ? (FontFamily)FontFamily.Companion.getSansSerif() : (Intrinsics.areEqual((Object)string, (Object)FontFamily.Companion.getSerif().getName()) ? (FontFamily)FontFamily.Companion.getSerif() : Html_androidKt.optionalFontFamilyFromName($this$toSpanStyle.getFamily()))));
        return new SpanStyle(0L, 0L, null, null, null, fontFamily, null, 0L, null, null, null, 0L, null, null, null, null, 65503, null);
    }

    private static final FontFamily optionalFontFamilyFromName(String familyName) {
        FontFamily fontFamily;
        Typeface typeface2;
        Typeface typeface3;
        Typeface typeface4;
        CharSequence charSequence = familyName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Typeface it = typeface4 = (typeface3 = Typeface.create((String)familyName, (int)0));
        boolean bl = false;
        Object object = typeface2 = !Intrinsics.areEqual((Object)typeface3, (Object)Typeface.DEFAULT) && !Intrinsics.areEqual((Object)typeface3, (Object)Typeface.create((Typeface)Typeface.DEFAULT, (int)0)) ? typeface4 : null;
        if (typeface2 != null) {
            it = typeface2;
            boolean bl2 = false;
            fontFamily = AndroidTypeface_androidKt.FontFamily(it);
        } else {
            fontFamily = null;
        }
        return fontFamily;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Layout.Alignment.values().length];
            try {
                nArray[Layout.Alignment.ALIGN_NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.Alignment.ALIGN_CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.Alignment.ALIGN_OPPOSITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

