/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"canReuse", "", "Landroidx/compose/ui/text/TextLayoutResult;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "maxLines", "", "softWrap", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "ui-text_release"})
public final class TextLayoutHelperKt {
    public static final boolean canReuse(@NotNull TextLayoutResult $this$canReuse, @NotNull AnnotatedString text, @NotNull TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$canReuse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        TextLayoutInput layoutInput = $this$canReuse.getLayoutInput();
        if (!(Intrinsics.areEqual((Object)layoutInput.getText(), (Object)text) && Intrinsics.areEqual((Object)layoutInput.getStyle(), (Object)style) && layoutInput.getMaxLines() == maxLines && layoutInput.getSoftWrap() == softWrap && layoutInput.getOverflow() == overflow && Intrinsics.areEqual((Object)layoutInput.getDensity(), (Object)density) && layoutInput.getLayoutDirection() == layoutDirection && Intrinsics.areEqual((Object)layoutInput.getResourceLoader(), (Object)resourceLoader))) {
            return false;
        }
        if (constraints.getMinWidth() != layoutInput.getConstraints().getMinWidth()) {
            return false;
        }
        if (!softWrap && overflow != TextOverflow.Ellipsis) {
            return true;
        }
        return constraints.getMaxWidth() == layoutInput.getConstraints().getMaxWidth();
    }
}

