/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/TextPainter;", "", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "ui-text_release"})
public final class TextPainter {
    @NotNull
    public static final TextPainter INSTANCE = new TextPainter();

    private TextPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        boolean needClipping;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        boolean bl = needClipping = textLayoutResult.getHasVisualOverflow() && textLayoutResult.getLayoutInput().getOverflow() == TextOverflow.Clip;
        if (needClipping) {
            float width = textLayoutResult.getSize().getWidth();
            float height = textLayoutResult.getSize().getHeight();
            Rect bounds = RectKt.Rect-MrV732k((Offset)Offset.Companion.getZero(), (long)SizeKt.Size((float)width, (float)height));
            canvas.save();
            Canvas.DefaultImpls.clipRect$default((Canvas)canvas, (Rect)bounds, null, (int)2, null);
        }
        try {
            textLayoutResult.getMultiParagraph$ui_text_release().paint(canvas);
        }
        finally {
            if (needClipping) {
                canvas.restore();
            }
        }
    }
}

