/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.input.EditOperation;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextFieldValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016J#\u0010\f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0082\bJ\u001c\u0010\u000f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016JR\u0010\u0016\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0004\u0012\u00020\n0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\u0014\u0010 \u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/ui/text/input/TextInputService;", "", "platformTextInputService", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "(Landroidx/compose/ui/text/input/PlatformTextInputService;)V", "currentSessionToken", "", "Landroidx/compose/ui/text/input/InputSessionToken;", "nextSessionToken", "hideSoftwareKeyboard", "", "token", "ignoreIfExpired", "block", "Lkotlin/Function0;", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "onStateUpdated", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "showSoftwareKeyboard", "startInput", "keyboardType", "Landroidx/compose/ui/text/input/KeyboardType;", "imeAction", "Landroidx/compose/ui/text/input/ImeAction;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditOperation;", "onImeActionPerformed", "stopInput", "ui-text_release"})
public class TextInputService {
    private final PlatformTextInputService platformTextInputService;
    private int nextSessionToken;
    private int currentSessionToken;

    public TextInputService(@NotNull PlatformTextInputService platformTextInputService) {
        Intrinsics.checkNotNullParameter((Object)platformTextInputService, (String)"platformTextInputService");
        this.platformTextInputService = platformTextInputService;
        this.nextSessionToken = 1;
    }

    private final void ignoreIfExpired(int token, Function0<Unit> block) {
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this.currentSessionToken) {
            block.invoke();
        }
    }

    public int startInput(@NotNull TextFieldValue value, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super List<? extends EditOperation>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)keyboardType), (String)"keyboardType");
        Intrinsics.checkNotNullParameter((Object)((Object)imeAction), (String)"imeAction");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.platformTextInputService.startInput(value, keyboardType, imeAction, onEditCommand, onImeActionPerformed);
        TextInputService textInputService = this;
        int n = textInputService.nextSessionToken;
        textInputService.nextSessionToken = n + 1;
        this.currentSessionToken = n;
        return this.currentSessionToken;
    }

    public void stopInput(int token) {
        TextInputService this_$iv = this;
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            boolean bl = false;
            this.platformTextInputService.stopInput();
        }
    }

    public void showSoftwareKeyboard(int token) {
        TextInputService this_$iv = this;
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            boolean bl = false;
            this.platformTextInputService.showSoftwareKeyboard();
        }
    }

    public void hideSoftwareKeyboard(int token) {
        TextInputService this_$iv = this;
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            boolean bl = false;
            this.platformTextInputService.hideSoftwareKeyboard();
        }
    }

    public void onStateUpdated(int token, @NotNull TextFieldValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextInputService this_$iv = this;
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            boolean bl = false;
            this.platformTextInputService.onStateUpdated(value);
        }
    }

    public void notifyFocusedRect(int token, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        TextInputService this_$iv = this;
        boolean $i$f$ignoreIfExpired = false;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            boolean bl = false;
            this.platformTextInputService.notifyFocusedRect(rect);
        }
    }
}

