/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.InternalTextApi;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphConstraints;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutHelperKt;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextPainter;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalTextApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u00a2\u0006\u0002\u0010\u0014J(\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002H80:H\u0082\b\u00a2\u0006\u0002\u0010;J,\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00182\n\b\u0002\u0010A\u001a\u0004\u0018\u00010=\u00f8\u0001\u0000\u00a2\u0006\u0004\bB\u0010CJ\u000e\u0010D\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0018J \u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010@\u001a\u00020\u0018H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R&\u0010%\u001a\u0004\u0018\u00010&8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006L"}, d2={"Landroidx/compose/ui/text/TextDelegate;", "", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "density", "Landroidx/compose/ui/unit/Density;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;IZLandroidx/compose/ui/text/style/TextOverflow;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/Font$ResourceLoader;Ljava/util/List;)V", "getDensity", "()Landroidx/compose/ui/unit/Density;", "intrinsicsLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getIntrinsicsLayoutDirection$ui_text_release", "()Landroidx/compose/ui/unit/LayoutDirection;", "setIntrinsicsLayoutDirection$ui_text_release", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "()I", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/compose/ui/text/style/TextOverflow;", "paragraphIntrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "getParagraphIntrinsics$ui_text_release$annotations$ui_text_release", "()V", "getParagraphIntrinsics$ui_text_release", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_release", "(Landroidx/compose/ui/text/MultiParagraphIntrinsics;)V", "getPlaceholders", "()Ljava/util/List;", "getResourceLoader", "()Landroidx/compose/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getStyle", "()Landroidx/compose/ui/text/TextStyle;", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "layout", "Landroidx/compose/ui/text/TextLayoutResult;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "layoutDirection", "prevResult", "layout-BAnaFRY", "(JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/text/TextLayoutResult;)Landroidx/compose/ui/text/TextLayoutResult;", "layoutIntrinsics", "", "layoutText", "Landroidx/compose/ui/text/MultiParagraph;", "minWidth", "", "maxWidth", "Companion", "ui-text_release"})
@Stable
public final class TextDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final AnnotatedString text;
    private final TextStyle style;
    private final int maxLines;
    private final boolean softWrap;
    private final TextOverflow overflow;
    private final Density density;
    private final Font.ResourceLoader resourceLoader;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private MultiParagraphIntrinsics paragraphIntrinsics;
    private LayoutDirection intrinsicsLayoutDirection;

    public TextDelegate(@NotNull AnnotatedString text, @NotNull TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        this.text = text;
        this.style = style;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.resourceLoader = resourceLoader;
        this.placeholders = placeholders;
        boolean bl = this.maxLines > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n, boolean bl, TextOverflow textOverflow, Density density, Font.ResourceLoader resourceLoader, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            textOverflow = TextOverflow.Clip;
        }
        if ((n2 & 0x80) != 0) {
            boolean bl2 = false;
            list = CollectionsKt.emptyList();
        }
        this(annotatedString, textStyle, n, bl, textOverflow, density, resourceLoader, list);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    @VisibleForTesting
    public static /* synthetic */ void getParagraphIntrinsics$ui_text_release$annotations$ui_text_release() {
    }

    @Nullable
    public final LayoutDirection getIntrinsicsLayoutDirection$ui_text_release() {
        return this.intrinsicsLayoutDirection;
    }

    public final void setIntrinsicsLayoutDirection$ui_text_release(@Nullable LayoutDirection layoutDirection) {
        this.intrinsicsLayoutDirection = layoutDirection;
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    public final int getMinIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        float f = it.getMinIntrinsicWidth();
        boolean bl2 = false;
        return (int)Math.ceil(f);
    }

    public final int getMaxIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        float f = it.getMaxIntrinsicWidth();
        boolean bl2 = false;
        return (int)Math.ceil(f);
    }

    public final void layoutIntrinsics(@NotNull LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        if (this.paragraphIntrinsics == null || layoutDirection != this.intrinsicsLayoutDirection) {
            this.intrinsicsLayoutDirection = layoutDirection;
            AnnotatedString annotatedString = this.text;
            TextStyle textStyle = TextStyleKt.resolveDefaults(this.style, layoutDirection);
            Density density = this.density;
            Font.ResourceLoader resourceLoader = this.resourceLoader;
            List<AnnotatedString.Range<Placeholder>> list = this.placeholders;
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list, density, resourceLoader);
        } else {
            multiParagraphIntrinsics = this.paragraphIntrinsics;
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth, LayoutDirection layoutDirection) {
        this.layoutIntrinsics(layoutDirection);
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics paragraphIntrinsics = multiParagraphIntrinsics;
        boolean bl = false;
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.getMaxLines(), this.getOverflow() == TextOverflow.Ellipsis, new ParagraphConstraints(width));
    }

    @NotNull
    public final TextLayoutResult layout-BAnaFRY(long constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResult) {
        float maxWidth;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        float minWidth = Constraints.getMinWidth-impl((long)constraints);
        boolean widthMatters = this.softWrap || this.overflow == TextOverflow.Ellipsis;
        float f = maxWidth = widthMatters && Constraints.getHasBoundedWidth-impl((long)constraints) ? (float)Constraints.getMaxWidth-impl((long)constraints) : Float.POSITIVE_INFINITY;
        if (prevResult != null && TextLayoutHelperKt.canReuse-b7138KI(prevResult, this.text, this.style, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.resourceLoader, constraints)) {
            boolean bl = false;
            boolean bl2 = false;
            TextLayoutResult $this$layout_BAnaFRY_u24lambda_u2d3 = prevResult;
            boolean bl3 = false;
            float f2 = $this$layout_BAnaFRY_u24lambda_u2d3.getMultiParagraph$ui_text_release().getWidth();
            boolean bl4 = false;
            int n = (int)Math.ceil(f2);
            f2 = $this$layout_BAnaFRY_u24lambda_u2d3.getMultiParagraph$ui_text_release().getHeight();
            bl4 = false;
            return TextLayoutResult.copy-2H_Vf2E$default($this$layout_BAnaFRY_u24lambda_u2d3, TextLayoutInput.copy-ih31NyA$default($this$layout_BAnaFRY_u24lambda_u2d3.getLayoutInput(), null, this.getStyle(), null, 0, false, null, null, null, null, constraints, 509, null), null, ConstraintsKt.constrain-m9CmiCs((long)constraints, (long)IntSizeKt.IntSize((int)n, (int)((int)Math.ceil(f2)))), 2, null);
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth, maxWidth, layoutDirection);
        float f3 = multiParagraph.getWidth();
        boolean bl = false;
        int n = (int)Math.ceil(f3);
        f3 = multiParagraph.getHeight();
        bl = false;
        long size = ConstraintsKt.constrain-m9CmiCs((long)constraints, (long)IntSizeKt.IntSize((int)n, (int)((int)Math.ceil(f3))));
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.resourceLoader, constraints, null), multiParagraph, size, null);
    }

    public static /* synthetic */ TextLayoutResult layout-BAnaFRY$default(TextDelegate textDelegate, long l, LayoutDirection layoutDirection, TextLayoutResult textLayoutResult, int n, Object object) {
        if ((n & 4) != 0) {
            textLayoutResult = null;
        }
        return textDelegate.layout-BAnaFRY(l, layoutDirection, textLayoutResult);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/text/TextDelegate$Companion;", "", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "paintBackground", "start", "", "end", "Landroidx/compose/ui/graphics/Paint;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        public final void paintBackground(int start, int end, @NotNull Paint paint, @NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            if (start == end) {
                return;
            }
            Path selectionPath = textLayoutResult.getMultiParagraph$ui_text_release().getPathForRange(start, end);
            canvas.drawPath(selectionPath, paint);
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

