/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.savedinstancestate.ListSaverKt;
import androidx.compose.runtime.savedinstancestate.Saver;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\t\u001a\u0004\b\r\u0010\u000bR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\t\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Landroidx/compose/ui/text/input/TextFieldValue;", "", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "composition", "(Ljava/lang/String;Landroidx/compose/ui/text/TextRange;Landroidx/compose/ui/text/TextRange;)V", "getComposition$annotations", "()V", "getComposition", "()Landroidx/compose/ui/text/TextRange;", "getSelection$annotations", "getSelection", "getText$annotations", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "ui-text_release"})
@Immutable
public final class TextFieldValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String text;
    private final TextRange selection;
    private final TextRange composition;
    private static final Saver<TextFieldValue, Object> Saver = ListSaverKt.listSaver((Function2)Companion.Saver.1.INSTANCE, (Function1)Companion.Saver.2.INSTANCE);

    public TextFieldValue(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.text = text;
        this.selection = selection;
        this.composition = composition;
        boolean bl = this.selection.getEnd() <= this.text.length();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Selection is out of bounds. [selection: " + this.getSelection() + ", text.length = " + this.getText().length() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TextRange textRange = this.composition;
        if (textRange != null) {
            TextRange textRange2 = textRange;
            bl3 = false;
            boolean bl5 = false;
            TextRange it = textRange2;
            boolean bl6 = false;
            boolean bl7 = this.getComposition().getEnd() <= this.getText().length();
            boolean bl8 = false;
            boolean bl9 = false;
            if (!bl7) {
                boolean bl10 = false;
                String string = "Composition is out of bounds. [composition: " + this.getSelection() + ", text.length = " + this.getText().length() + ']';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ TextFieldValue(String string, TextRange textRange, TextRange textRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            textRange = TextRange.Companion.getZero();
        }
        if ((n & 4) != 0) {
            textRange2 = null;
        }
        this(string, textRange, textRange2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Stable
    public static /* synthetic */ void getText$annotations() {
    }

    @NotNull
    public final TextRange getSelection() {
        return this.selection;
    }

    @Stable
    public static /* synthetic */ void getSelection$annotations() {
    }

    @Nullable
    public final TextRange getComposition() {
        return this.composition;
    }

    @Stable
    public static /* synthetic */ void getComposition$annotations() {
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final TextRange component2() {
        return this.selection;
    }

    @Nullable
    public final TextRange component3() {
        return this.composition;
    }

    @NotNull
    public final TextFieldValue copy(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return new TextFieldValue(text, selection, composition);
    }

    public static /* synthetic */ TextFieldValue copy$default(TextFieldValue textFieldValue, String string, TextRange textRange, TextRange textRange2, int n, Object object) {
        if ((n & 1) != 0) {
            string = textFieldValue.text;
        }
        if ((n & 2) != 0) {
            textRange = textFieldValue.selection;
        }
        if ((n & 4) != 0) {
            textRange2 = textFieldValue.composition;
        }
        return textFieldValue.copy(string, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "TextFieldValue(text=" + this.text + ", selection=" + this.selection + ", composition=" + this.composition + ')';
    }

    public int hashCode() {
        return (this.text.hashCode() * 31 + this.selection.hashCode()) * 31 + (this.composition == null ? 0 : this.composition.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextFieldValue)) {
            return false;
        }
        Object object = other;
        TextFieldValue textFieldValue = (TextFieldValue)object;
        if (!Intrinsics.areEqual((Object)this.text, (Object)textFieldValue.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selection, (Object)textFieldValue.selection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.composition, (Object)textFieldValue.composition);
    }

    public TextFieldValue() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/text/input/TextFieldValue$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/savedinstancestate/Saver;", "Landroidx/compose/ui/text/input/TextFieldValue;", "getSaver", "()Landroidx/compose/runtime/savedinstancestate/Saver;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<TextFieldValue, Object> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

