/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.AndroidTypeface;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/text/platform/AndroidDefaultTypeface;", "Landroidx/compose/ui/text/platform/AndroidTypeface;", "()V", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "getFontFamily", "()Landroidx/compose/ui/text/font/FontFamily;", "getNativeTypeface", "Landroid/graphics/Typeface;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "synthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "ui-text_release"})
public final class AndroidDefaultTypeface
implements AndroidTypeface {
    private final FontFamily fontFamily = FontFamily.Companion.getDefault();

    @Override
    @NotNull
    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Override
    @NotNull
    public Typeface getNativeTypeface(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis synthesis) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkNotNullParameter((Object)((Object)synthesis), (String)"synthesis");
        if (Build.VERSION.SDK_INT < 28) {
            Typeface typeface2 = Typeface.defaultFromStyle((int)TypefaceAdapter.Companion.getTypefaceStyle(fontWeight, fontStyle));
            Intrinsics.checkNotNullExpressionValue((Object)typeface2, (String)"{\n            Typeface.defaultFromStyle(\n                TypefaceAdapter.getTypefaceStyle(fontWeight, fontStyle))\n        }");
            typeface = typeface2;
        } else {
            Typeface typeface3 = Typeface.create((Typeface)Typeface.DEFAULT, (int)fontWeight.getWeight(), (fontStyle == FontStyle.Italic ? 1 : 0) != 0);
            Intrinsics.checkNotNullExpressionValue((Object)typeface3, (String)"{\n            Typeface.create(Typeface.DEFAULT, fontWeight.weight, fontStyle == FontStyle.Italic)\n        }");
            typeface = typeface3;
        }
        return typeface;
    }
}

