/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.text.ParagraphStyleKt;
import androidx.compose.ui.text.SpanStyleKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0000\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"DefaultBackgroundColor", "Landroidx/compose/ui/graphics/Color;", "J", "DefaultColor", "DefaultFontSize", "Landroidx/compose/ui/unit/TextUnit;", "DefaultLetterSpacing", "DefaultLineHeight", "lerp", "Landroidx/compose/ui/text/TextStyle;", "start", "stop", "fraction", "", "resolveDefaults", "style", "direction", "Landroidx/compose/ui/unit/LayoutDirection;", "resolveTextDirection", "Landroidx/compose/ui/text/style/TextDirection;", "layoutDirection", "textDirection", "ui-text_release"})
public final class TextStyleKt {
    private static final long DefaultFontSize = TextUnitKt.getSp((int)14);
    private static final long DefaultLetterSpacing = TextUnitKt.getSp((int)0);
    private static final long DefaultBackgroundColor = Color.Companion.getTransparent-0d7_KjU();
    private static final long DefaultLineHeight = TextUnit.Companion.getUnspecified-XSAIIZE();
    private static final long DefaultColor = Color.Companion.getBlack-0d7_KjU();

    @NotNull
    public static final TextStyle lerp(@NotNull TextStyle start, @NotNull TextStyle stop, float fraction) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        return new TextStyle(SpanStyleKt.lerp(start.toSpanStyle(), stop.toSpanStyle(), fraction), ParagraphStyleKt.lerp(start.toParagraphStyle(), stop.toParagraphStyle(), fraction));
    }

    @NotNull
    public static final TextStyle resolveDefaults(@NotNull TextStyle style, @NotNull LayoutDirection direction) {
        long l;
        long l2;
        long l3;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        long $this$takeOrElse$iv22 = style.getColor-0d7_KjU();
        boolean bl = false;
        boolean bl2 = false;
        if ($this$takeOrElse$iv22 != Color.Companion.getUnspecified-0d7_KjU()) {
            l3 = $this$takeOrElse$iv22;
        } else {
            boolean bl3 = false;
            l3 = l2 = DefaultColor;
        }
        long l4 = TextUnitKt.isUnspecified--R2X_6o((long)style.getFontSize-XSAIIZE()) ? DefaultFontSize : style.getFontSize-XSAIIZE();
        Object $this$takeOrElse$iv22 = style.getFontWeight();
        Object object = $this$takeOrElse$iv22 == null ? FontWeight.Companion.getNormal() : $this$takeOrElse$iv22;
        $this$takeOrElse$iv22 = style.getFontStyle();
        Object object2 = $this$takeOrElse$iv22 == null ? FontStyle.Normal : $this$takeOrElse$iv22;
        $this$takeOrElse$iv22 = style.getFontSynthesis();
        Object object3 = $this$takeOrElse$iv22 == null ? FontSynthesis.All : $this$takeOrElse$iv22;
        $this$takeOrElse$iv22 = style.getFontFamily();
        Object object4 = $this$takeOrElse$iv22 == null ? (FontFamily)FontFamily.Companion.getDefault() : $this$takeOrElse$iv22;
        $this$takeOrElse$iv22 = style.getFontFeatureSettings();
        Object object5 = $this$takeOrElse$iv22 == null ? "" : $this$takeOrElse$iv22;
        long l5 = TextUnitKt.isUnspecified--R2X_6o((long)style.getLetterSpacing-XSAIIZE()) ? DefaultLetterSpacing : style.getLetterSpacing-XSAIIZE();
        $this$takeOrElse$iv22 = style.getBaselineShift-5SSeXJ0();
        BaselineShift baselineShift = BaselineShift.box-impl($this$takeOrElse$iv22 == null ? BaselineShift.Companion.getNone-y9eOQZs() : ((BaselineShift)$this$takeOrElse$iv22).unbox-impl());
        $this$takeOrElse$iv22 = style.getTextGeometricTransform();
        Object object6 = $this$takeOrElse$iv22 == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : $this$takeOrElse$iv22;
        $this$takeOrElse$iv22 = style.getLocaleList();
        Object object7 = $this$takeOrElse$iv22 == null ? LocaleList.Companion.getCurrent() : $this$takeOrElse$iv22;
        long $this$takeOrElse$iv = style.getBackground-0d7_KjU();
        bl = false;
        bl2 = false;
        if ($this$takeOrElse$iv != Color.Companion.getUnspecified-0d7_KjU()) {
            l = $this$takeOrElse$iv;
        } else {
            Object object8 = object7;
            Object object9 = object6;
            BaselineShift baselineShift2 = baselineShift;
            long l6 = l5;
            Object object10 = object5;
            Object object11 = object4;
            Object object12 = object3;
            Object object13 = object2;
            FontWeight fontWeight = object;
            long l7 = l4;
            l2 = l3;
            boolean bl4 = false;
            long l8 = DefaultBackgroundColor;
            l3 = l2;
            l4 = l7;
            object = fontWeight;
            object2 = object13;
            object3 = object12;
            object4 = object11;
            object5 = object10;
            l5 = l6;
            baselineShift = baselineShift2;
            object6 = object9;
            object7 = object8;
            l = l8;
        }
        Object object14 = style.getTextDecoration();
        TextDecoration textDecoration = object14 == null ? TextDecoration.Companion.getNone() : object14;
        object14 = style.getShadow();
        TextDecoration textDecoration2 = object14 == null ? Shadow.Companion.getNone() : object14;
        object14 = style.getTextAlign();
        Object object15 = object14 == null ? TextAlign.Start : object14;
        object14 = style.getTextIndent();
        DefaultConstructorMarker defaultConstructorMarker = null;
        Object object16 = object14 == null ? TextIndent.Companion.getNone() : object14;
        long l9 = TextUnitKt.isUnspecified--R2X_6o((long)style.getLineHeight-XSAIIZE()) ? DefaultLineHeight : style.getLineHeight-XSAIIZE();
        TextDirection textDirection = TextStyleKt.resolveTextDirection(direction, style.getTextDirection());
        Object object17 = object15;
        TextDecoration textDecoration3 = textDecoration2;
        TextDecoration textDecoration4 = textDecoration;
        long l10 = l;
        Object object18 = object7;
        Object object19 = object6;
        BaselineShift baselineShift3 = baselineShift;
        long l11 = l5;
        Object object20 = object5;
        Object object21 = object4;
        Object object22 = object3;
        Object object23 = object2;
        FontWeight fontWeight = object;
        long l12 = l4;
        long l13 = l3;
        return new TextStyle(l13, l12, fontWeight, (FontStyle)((Object)object23), (FontSynthesis)((Object)object22), (FontFamily)object21, (String)object20, l11, baselineShift3, (TextGeometricTransform)object19, (LocaleList)object18, l10, textDecoration4, (Shadow)textDecoration3, (TextAlign)((Object)object17), textDirection, l9, (TextIndent)object16, defaultConstructorMarker);
    }

    @NotNull
    public static final TextDirection resolveTextDirection(@NotNull LayoutDirection layoutDirection, @Nullable TextDirection textDirection) {
        TextDirection textDirection2;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        TextDirection textDirection3 = textDirection;
        int n = textDirection3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[textDirection3.ordinal()];
        block0 : switch (n) {
            case 1: {
                LayoutDirection layoutDirection2 = layoutDirection;
                int n2 = WhenMappings.$EnumSwitchMapping$1[layoutDirection2.ordinal()];
                switch (n2) {
                    case 1: {
                        textDirection2 = TextDirection.ContentOrLtr;
                        break block0;
                    }
                    case 2: {
                        textDirection2 = TextDirection.ContentOrRtl;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case -1: {
                LayoutDirection layoutDirection3 = layoutDirection;
                int n3 = WhenMappings.$EnumSwitchMapping$1[layoutDirection3.ordinal()];
                switch (n3) {
                    case 1: {
                        textDirection2 = TextDirection.Ltr;
                        break block0;
                    }
                    case 2: {
                        textDirection2 = TextDirection.Rtl;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                textDirection2 = textDirection;
            }
        }
        return textDirection2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TextDirection.values().length];
            nArray[TextDirection.Content.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LayoutDirection.values().length];
            nArray[LayoutDirection.Ltr.ordinal()] = 1;
            nArray[LayoutDirection.Rtl.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

