/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.text.Layout;
import android.text.Spanned;
import android.text.TextPaint;
import androidx.compose.ui.text.android.CharSequenceCharacterIterator;
import androidx.compose.ui.text.android.LayoutIntrinsicsKt;
import androidx.compose.ui.text.android.SpannedExtensionsKt;
import androidx.compose.ui.text.android.style.LetterSpacingSpanEm;
import androidx.compose.ui.text.android.style.LetterSpacingSpanPx;
import androidx.compose.ui.text.android.style.LineHeightSpan;
import java.text.BreakIterator;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"minIntrinsicWidth", "", "text", "", "paint", "Landroid/text/TextPaint;", "shouldIncreaseMaxIntrinsic", "", "desiredWidth", "charSequence", "textPaint", "ui-text_release"})
public final class LayoutIntrinsicsKt {
    public static final float minIntrinsicWidth(@NotNull CharSequence text, @NotNull TextPaint paint) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        BreakIterator iterator = BreakIterator.getLineInstance(paint.getTextLocale());
        iterator.setText(new CharSequenceCharacterIterator(text, 0, text.length()));
        int heapSize = 10;
        PriorityQueue<Pair> longestWordCandidates2 = new PriorityQueue<Pair>(heapSize, minIntrinsicWidth.longestWordCandidates.1.INSTANCE);
        int start = 0;
        int end = 0;
        end = iterator.next();
        while (end != -1) {
            if (longestWordCandidates2.size() < heapSize) {
                longestWordCandidates2.add(new Pair((Object)start, (Object)end));
            } else {
                Pair pair = (Pair)longestWordCandidates2.peek();
                if (pair != null) {
                    Pair pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair minPair = pair2;
                    boolean bl3 = false;
                    if (((Number)minPair.getSecond()).intValue() - ((Number)minPair.getFirst()).intValue() < end - start) {
                        longestWordCandidates2.poll();
                        longestWordCandidates2.add(new Pair((Object)start, (Object)end));
                    }
                }
            }
            start = end;
            end = iterator.next();
        }
        float minWidth = 0.0f;
        Iterable $this$forEach$iv = longestWordCandidates2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$start$end = (Pair)element$iv;
            boolean bl = false;
            int start2 = ((Number)$dstr$start$end.component1()).intValue();
            int end2 = ((Number)$dstr$start$end.component2()).intValue();
            float width = Layout.getDesiredWidth((CharSequence)text, (int)start2, (int)end2, (TextPaint)paint);
            float f = minWidth;
            boolean bl4 = false;
            minWidth = Math.max(f, width);
        }
        return minWidth;
    }

    private static final boolean shouldIncreaseMaxIntrinsic(float desiredWidth, CharSequence charSequence, TextPaint textPaint) {
        return !(desiredWidth == 0.0f) && charSequence instanceof Spanned && (!(textPaint.getLetterSpacing() == 0.0f) || SpannedExtensionsKt.hasSpan((Spanned)charSequence, LetterSpacingSpanPx.class) || SpannedExtensionsKt.hasSpan((Spanned)charSequence, LetterSpacingSpanEm.class)) && SpannedExtensionsKt.hasSpan((Spanned)charSequence, LineHeightSpan.class);
    }

    public static final /* synthetic */ boolean access$shouldIncreaseMaxIntrinsic(float desiredWidth, CharSequence charSequence, TextPaint textPaint) {
        return LayoutIntrinsicsKt.shouldIncreaseMaxIntrinsic(desiredWidth, charSequence, textPaint);
    }
}

