/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.android.LayoutIntrinsics;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.selection.WordBoundary;
import androidx.compose.ui.text.android.style.PlaceholderSpan;
import androidx.compose.ui.text.platform.AndroidParagraphIntrinsics;
import androidx.compose.ui.text.platform.AndroidParagraph_androidKt;
import androidx.compose.ui.text.platform.AndroidTextPaint;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bg\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016B%\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010O\u001a\u0002082\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010P\u001a\u0002082\u0006\u0010N\u001a\u00020\rH\u0016J\u0018\u0010Q\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\r2\u0006\u0010R\u001a\u00020\u000fH\u0016J\u0010\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u0018\u0010U\u001a\u00020\r2\u0006\u0010T\u001a\u00020\r2\u0006\u0010V\u001a\u00020\u000fH\u0016J\u0010\u0010W\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010X\u001a\u00020\r2\u0006\u0010Y\u001a\u00020\u0011H\u0016J\u0010\u0010Z\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u0010\u0010[\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u0010\u0010\\\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u0010\u0010]\u001a\u00020\r2\u0006\u0010T\u001a\u00020\rH\u0016J\u0010\u0010^\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u0010\u0010_\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\rH\u0016J\u001d\u0010`\u001a\u00020\r2\u0006\u0010a\u001a\u00020bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bc\u0010dJ\u0010\u0010e\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0016J\u0018\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\r2\u0006\u0010i\u001a\u00020\rH\u0016J \u0010H\u001a\u00020j2\u0006\u0010N\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bk\u0010lJ\u0015\u0010m\u001a\u00020\u000f2\u0006\u0010T\u001a\u00020\rH\u0001\u00a2\u0006\u0002\bnJ\u0010\u0010o\u001a\u00020\u000f2\u0006\u0010T\u001a\u00020\rH\u0016J9\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020u2\b\u0010v\u001a\u0004\u0018\u00010w2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bz\u0010{R\u001a\u0010\u001a\u001a\u00020\u001b8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0014\u0010$\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010&R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010/R\u0014\u00103\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010&R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020<8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b=\u0010\u001d\u001a\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020A8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010\u001d\u001a\u0004\bC\u0010DR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010&R\u001b\u0010F\u001a\u00020G8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bH\u0010I\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006|"}, d2={"Landroidx/compose/ui/text/platform/AndroidParagraph;", "Landroidx/compose/ui/text/Paragraph;", "text", "", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "maxLines", "", "ellipsis", "", "width", "", "typefaceAdapter", "Landroidx/compose/ui/text/platform/TypefaceAdapter;", "density", "Landroidx/compose/ui/unit/Density;", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;IZFLandroidx/compose/ui/text/platform/TypefaceAdapter;Landroidx/compose/ui/unit/Density;)V", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;", "(Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;IZF)V", "charSequence", "", "getCharSequence$ui_text_release$annotations", "()V", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "firstBaseline", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layout", "Landroidx/compose/ui/text/android/TextLayout;", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "getParagraphIntrinsics", "()Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;", "placeholderRects", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "textLocale", "Ljava/util/Locale;", "getTextLocale$ui_text_release$annotations", "getTextLocale$ui_text_release", "()Ljava/util/Locale;", "textPaint", "Landroidx/compose/ui/text/platform/AndroidTextPaint;", "getTextPaint$ui_text_release$annotations", "getTextPaint$ui_text_release", "()Landroidx/compose/ui/text/platform/AndroidTextPaint;", "getWidth", "wordBoundary", "Landroidx/compose/ui/text/android/selection/WordBoundary;", "getWordBoundary", "()Landroidx/compose/ui/text/android/selection/WordBoundary;", "wordBoundary$delegate", "Lkotlin/Lazy;", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "Landroidx/compose/ui/text/TextRange;", "getWordBoundary--jx7JFs", "(I)J", "isEllipsisApplied", "isEllipsisApplied$ui_text_release", "isLineEllipsized", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "ui-text_release"})
public final class AndroidParagraph
implements Paragraph {
    @NotNull
    private final AndroidParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final boolean ellipsis;
    private final float width;
    @NotNull
    private final TextLayout layout;
    @NotNull
    private final List<Rect> placeholderRects;
    @NotNull
    private final Lazy wordBoundary$delegate;

    /*
     * WARNING - void declaration
     */
    public AndroidParagraph(@NotNull AndroidParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, float width) {
        List list;
        void $this$placeholderRects_u24lambda_u2d5;
        Intrinsics.checkNotNullParameter((Object)paragraphIntrinsics, (String)"paragraphIntrinsics");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.width = width;
        boolean bl = this.maxLines >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxLines should be greater than 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getWidth() >= 0.0f;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "width should not be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TextStyle style = this.paragraphIntrinsics.getStyle();
        int alignment = AndroidParagraph_androidKt.access$toLayoutAlign(style.getTextAlign());
        TextAlign bl5 = style.getTextAlign();
        int n = bl5 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bl5.ordinal()];
        int justificationMode = n == 1 ? 1 : 0;
        Object ellipsize = this.ellipsis ? TextUtils.TruncateAt.END : (TextUtils.TruncateAt)null;
        CharSequence charSequence = this.paragraphIntrinsics.getCharSequence$ui_text_release();
        float f = this.getWidth();
        AndroidTextPaint androidTextPaint = this.getTextPaint$ui_text_release();
        int n2 = this.paragraphIntrinsics.getTextDirectionHeuristic$ui_text_release();
        int n3 = this.maxLines;
        LayoutIntrinsics layoutIntrinsics = this.paragraphIntrinsics.getLayoutIntrinsics$ui_text_release();
        this.layout = new TextLayout(charSequence, f, androidTextPaint, alignment, (TextUtils.TruncateAt)ellipsize, n2, 1.0f, 0.0f, false, n3, 0, 0, justificationMode, null, null, layoutIntrinsics, 28032, null);
        CharSequence charSequence2 = this.paragraphIntrinsics.getCharSequence$ui_text_release();
        bl2 = false;
        bl3 = false;
        ellipsize = charSequence2;
        AndroidParagraph androidParagraph = this;
        boolean bl6 = false;
        if (!($this$placeholderRects_u24lambda_u2d5 instanceof Spanned)) {
            boolean bl7 = false;
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Object[] objectArray = ((Spanned)$this$placeholderRects_u24lambda_u2d5).getSpans(0, $this$placeholderRects_u24lambda_u2d5.length(), PlaceholderSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(0, length, PlaceholderSpan::class.java)");
            Object[] $this$map$iv = objectArray;
            boolean $i$f$map = false;
            Object[] objectArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                Rect rect;
                boolean isPlaceholderSpanTruncated;
                void span;
                PlaceholderSpan placeholderSpan = (PlaceholderSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                int start = ((Spanned)$this$placeholderRects_u24lambda_u2d5).getSpanStart((Object)span);
                int end = ((Spanned)$this$placeholderRects_u24lambda_u2d5).getSpanEnd((Object)span);
                int line = this.layout.getLineForOffset(start);
                boolean isPlaceholderSpanEllipsized = this.layout.getLineEllipsisCount(line) > 0 && end > this.layout.getLineEllipsisOffset(line);
                boolean bl9 = isPlaceholderSpanTruncated = end > this.layout.getLineEnd(line);
                if (isPlaceholderSpanEllipsized || isPlaceholderSpanTruncated) {
                    rect = null;
                } else {
                    float f2;
                    float f3;
                    ResolvedTextDirection direction;
                    ResolvedTextDirection resolvedTextDirection = direction = this.getBidiRunDirection(start);
                    int n4 = WhenMappings.$EnumSwitchMapping$1[resolvedTextDirection.ordinal()];
                    switch (n4) {
                        case 1: {
                            f3 = this.getHorizontalPosition(start, true);
                            break;
                        }
                        case 2: {
                            f3 = this.getHorizontalPosition(start, true) - (float)span.getWidthPx();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    float left = f3;
                    float right = left + (float)span.getWidthPx();
                    TextLayout textLayout = this.layout;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    TextLayout $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = textLayout;
                    boolean bl12 = false;
                    int n5 = span.getVerticalAlign();
                    switch (n5) {
                        case 0: {
                            f2 = $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBaseline(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 1: {
                            f2 = $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineTop(line);
                            break;
                        }
                        case 2: {
                            f2 = $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBottom(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 3: {
                            f2 = ($this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineTop(line) + $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBottom(line) - (float)span.getHeightPx()) / (float)2;
                            break;
                        }
                        case 4: {
                            f2 = (float)span.getFontMetrics().ascent + $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBaseline(line);
                            break;
                        }
                        case 5: {
                            f2 = (float)span.getFontMetrics().descent + $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBaseline(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 6: {
                            Paint.FontMetricsInt fontMetricsInt = span.getFontMetrics();
                            boolean bl13 = false;
                            boolean bl14 = false;
                            Paint.FontMetricsInt $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = fontMetricsInt;
                            boolean bl15 = false;
                            f2 = (float)(($this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.ascent + $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.descent - span.getHeightPx()) / 2) + $this$placeholderRects_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getLineBaseline(line);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unexpected verticalAlignment");
                        }
                    }
                    float top = f2;
                    float bottom = top + (float)span.getHeightPx();
                    rect = new Rect(left, top, right, bottom);
                }
                Rect rect2 = rect;
                collection.add(rect2);
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        androidParagraph.placeholderRects = list2;
        this.wordBoundary$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<WordBoundary>(this){
            final /* synthetic */ AndroidParagraph this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WordBoundary invoke() {
                return new WordBoundary(this.this$0.getTextLocale$ui_text_release(), AndroidParagraph.access$getLayout$p(this.this$0).getText());
            }
        }));
    }

    @NotNull
    public final AndroidParagraphIntrinsics getParagraphIntrinsics() {
        return this.paragraphIntrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public AndroidParagraph(@NotNull String text, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, int maxLines, boolean ellipsis, float width, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this(new AndroidParagraphIntrinsics(text, style, spanStyles, placeholders, typefaceAdapter, density), maxLines, ellipsis, width);
    }

    @Override
    public float getHeight() {
        return this.layout.getHeight();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        return this.layout.getLineBaseline(0);
    }

    @Override
    public float getLastBaseline() {
        return this.maxLines < this.getLineCount() ? this.layout.getLineBaseline(this.maxLines - 1) : this.layout.getLineBaseline(this.getLineCount() - 1);
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.layout.getDidExceedMaxLines();
    }

    @NotNull
    public final Locale getTextLocale$ui_text_release() {
        Locale locale = this.paragraphIntrinsics.getTextPaint$ui_text_release().getTextLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"paragraphIntrinsics.textPaint.textLocale");
        return locale;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTextLocale$ui_text_release$annotations() {
    }

    @Override
    public int getLineCount() {
        return this.layout.getLineCount();
    }

    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.paragraphIntrinsics.getCharSequence$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void getCharSequence$ui_text_release$annotations() {
    }

    @NotNull
    public final AndroidTextPaint getTextPaint$ui_text_release() {
        return this.paragraphIntrinsics.getTextPaint$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void getTextPaint$ui_text_release$annotations() {
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        return this.layout.getLineForVertical((int)vertical);
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        int line = this.layout.getLineForVertical((int)Offset.getY-impl((long)position));
        return this.layout.getOffsetForHorizontal(line, Offset.getX-impl((long)position));
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        float left = this.layout.getPrimaryHorizontal(offset);
        float right = this.layout.getPrimaryHorizontal(offset + 1);
        int line = this.layout.getLineForOffset(offset);
        float top = this.layout.getLineTop(line);
        float bottom = this.layout.getLineBottom(line);
        return new Rect(left, top, right, bottom);
    }

    @Override
    @NotNull
    public Path getPathForRange(int start, int end) {
        if (!(0 <= start ? start <= end : false) || end > this.getCharSequence$ui_text_release().length()) {
            throw new AssertionError((Object)("Start(" + start + ") or End(" + end + ") is out of Range(0.." + this.getCharSequence$ui_text_release().length() + "), or start > end!"));
        }
        android.graphics.Path path = new android.graphics.Path();
        this.layout.getSelectionPath(start, end, path);
        return AndroidPath_androidKt.asComposePath((android.graphics.Path)path);
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        if (!(0 <= offset ? offset <= this.getCharSequence$ui_text_release().length() : false)) {
            throw new AssertionError((Object)("offset(" + offset + ") is out of bounds (0," + this.getCharSequence$ui_text_release().length()));
        }
        float horizontal = this.layout.getPrimaryHorizontal(offset);
        int line = this.layout.getLineForOffset(offset);
        return new Rect(horizontal, this.layout.getLineTop(line), horizontal, this.layout.getLineBottom(line));
    }

    private final WordBoundary getWordBoundary() {
        Lazy lazy = this.wordBoundary$delegate;
        boolean bl = false;
        return (WordBoundary)lazy.getValue();
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        return TextRangeKt.TextRange(this.getWordBoundary().getWordStart(offset), this.getWordBoundary().getWordEnd(offset));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex);
    }

    @Override
    public float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex);
    }

    @Override
    public float getLineTop(int lineIndex) {
        return this.layout.getLineTop(lineIndex);
    }

    @Override
    public float getLineBottom(int lineIndex) {
        return this.layout.getLineBottom(lineIndex);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        return this.layout.getLineHeight(lineIndex);
    }

    @Override
    public float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    @Override
    public int getLineStart(int lineIndex) {
        return this.layout.getLineStart(lineIndex);
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        return visibleEnd ? this.layout.getLineVisibleEnd(lineIndex) : this.layout.getLineEnd(lineIndex);
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return this.layout.isLineEllipsized(lineIndex);
    }

    @Override
    public int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        return usePrimaryDirection ? this.layout.getPrimaryHorizontal(offset) : this.layout.getSecondaryHorizontal(offset);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        int lineIndex = this.layout.getLineForOffset(offset);
        int direction = this.layout.getParagraphDirection(lineIndex);
        return direction == 1 ? ResolvedTextDirection.Ltr : ResolvedTextDirection.Rtl;
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        return this.layout.isRtlCharAt(offset) ? ResolvedTextDirection.Rtl : ResolvedTextDirection.Ltr;
    }

    @VisibleForTesting
    public final boolean isEllipsisApplied$ui_text_release(int lineIndex) {
        return this.layout.isEllipsisApplied(lineIndex);
    }

    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.getTextPaint$ui_text_release().setColor-8_81llA(color);
        this.getTextPaint$ui_text_release().setShadow(shadow);
        this.getTextPaint$ui_text_release().setTextDecoration(textDecoration);
        android.graphics.Canvas nativeCanvas = AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas);
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.save();
            nativeCanvas.clipRect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        this.layout.paint(nativeCanvas);
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.restore();
        }
    }

    public static final /* synthetic */ TextLayout access$getLayout$p(AndroidParagraph $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TextAlign.values().length];
            nArray[TextAlign.Justify.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResolvedTextDirection.values().length];
            nArray[ResolvedTextDirection.Ltr.ordinal()] = 1;
            nArray[ResolvedTextDirection.Rtl.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

