/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform.extensions;

import android.graphics.Typeface;
import android.os.Build;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.intl.Locale;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.platform.AndroidTextPaint;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import androidx.compose.ui.text.platform.extensions.LocaleExtensions_androidKt;
import androidx.compose.ui.text.platform.extensions.LocaleListHelperMethods;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\u0006\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0000\u00a8\u0006\f"}, d2={"createTypeface", "Landroid/graphics/Typeface;", "style", "Landroidx/compose/ui/text/SpanStyle;", "typefaceAdapter", "Landroidx/compose/ui/text/platform/TypefaceAdapter;", "applySpanStyle", "Landroidx/compose/ui/text/platform/AndroidTextPaint;", "density", "Landroidx/compose/ui/unit/Density;", "hasFontAttributes", "", "ui-text_release"})
public final class TextPaintExtensions_androidKt {
    @NotNull
    public static final SpanStyle applySpanStyle(@NotNull AndroidTextPaint $this$applySpanStyle, @NotNull SpanStyle style, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applySpanStyle), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        long l = TextUnit.getType-UIouoOA((long)style.getFontSize-XSAIIZE());
        if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getSp-UIouoOA())) {
            boolean bl = false;
            boolean bl2 = false;
            Density $this$applySpanStyle_u24lambda_u2d0 = density;
            boolean bl3 = false;
            $this$applySpanStyle.setTextSize($this$applySpanStyle_u24lambda_u2d0.toPx--R2X_6o(style.getFontSize-XSAIIZE()));
        } else if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getEm-UIouoOA())) {
            AndroidTextPaint androidTextPaint = $this$applySpanStyle;
            androidTextPaint.setTextSize(androidTextPaint.getTextSize() * TextUnit.getValue-impl((long)style.getFontSize-XSAIIZE()));
        }
        if (TextPaintExtensions_androidKt.hasFontAttributes(style)) {
            $this$applySpanStyle.setTypeface(TextPaintExtensions_androidKt.createTypeface(style, typefaceAdapter));
        }
        if (style.getLocaleList() != null && !Intrinsics.areEqual((Object)style.getLocaleList(), (Object)LocaleList.Companion.getCurrent())) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleListHelperMethods.INSTANCE.setTextLocales($this$applySpanStyle, style.getLocaleList());
            } else {
                Locale locale = style.getLocaleList().isEmpty() ? Locale.Companion.getCurrent() : style.getLocaleList().get(0);
                $this$applySpanStyle.setTextLocale(LocaleExtensions_androidKt.toJavaLocale(locale));
            }
        }
        if (TextUnitType.equals-impl0((long)(l = TextUnit.getType-UIouoOA((long)style.getLetterSpacing-XSAIIZE())), (long)TextUnitType.Companion.getEm-UIouoOA())) {
            $this$applySpanStyle.setLetterSpacing(TextUnit.getValue-impl((long)style.getLetterSpacing-XSAIIZE()));
        } else if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getSp-UIouoOA())) {
            // empty if block
        }
        if (style.getFontFeatureSettings() != null && !Intrinsics.areEqual((Object)style.getFontFeatureSettings(), (Object)"")) {
            $this$applySpanStyle.setFontFeatureSettings(style.getFontFeatureSettings());
        }
        if (style.getTextGeometricTransform() != null && !Intrinsics.areEqual((Object)style.getTextGeometricTransform(), (Object)TextGeometricTransform.Companion.getNone$ui_text_release())) {
            AndroidTextPaint androidTextPaint = $this$applySpanStyle;
            androidTextPaint.setTextScaleX(androidTextPaint.getTextScaleX() * style.getTextGeometricTransform().getScaleX());
            androidTextPaint = $this$applySpanStyle;
            androidTextPaint.setTextSkewX(androidTextPaint.getTextSkewX() + style.getTextGeometricTransform().getSkewX());
        }
        $this$applySpanStyle.setColor-8_81llA(style.getColor-0d7_KjU());
        $this$applySpanStyle.setShadow(style.getShadow());
        $this$applySpanStyle.setTextDecoration(style.getTextDecoration());
        long l2 = TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)style.getLetterSpacing-XSAIIZE()), (long)TextUnitType.Companion.getSp-UIouoOA()) && !(TextUnit.getValue-impl((long)style.getLetterSpacing-XSAIIZE()) == 0.0f) ? style.getLetterSpacing-XSAIIZE() : TextUnit.Companion.getUnspecified-XSAIIZE();
        long l3 = Color.equals-impl0((long)style.getBackground-0d7_KjU(), (long)Color.Companion.getTransparent-0d7_KjU()) ? Color.Companion.getUnspecified-0d7_KjU() : style.getBackground-0d7_KjU();
        BaselineShift baselineShift = style.getBaselineShift-5SSeXJ0();
        float f = BaselineShift.Companion.getNone-y9eOQZs();
        BaselineShift baselineShift2 = (baselineShift == null ? false : BaselineShift.equals-impl0(baselineShift.unbox-impl(), f)) ? (BaselineShift)null : style.getBaselineShift-5SSeXJ0();
        return new SpanStyle(0L, 0L, null, null, null, null, null, l2, baselineShift2, null, null, l3, null, null, 13951, null);
    }

    public static final boolean hasFontAttributes(@NotNull SpanStyle $this$hasFontAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFontAttributes, (String)"<this>");
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle-4Lr2A7w() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    private static final Typeface createTypeface(SpanStyle style, TypefaceAdapter typefaceAdapter) {
        Object object = style.getFontWeight();
        Object object2 = object == null ? FontWeight.Companion.getNormal() : object;
        object = style.getFontStyle-4Lr2A7w();
        int n = object == null ? FontStyle.Companion.getNormal-_-LCdwA() : ((FontStyle)object).unbox-impl();
        object = style.getFontSynthesis-ZQGJjVo();
        return typefaceAdapter.create-DPcqOEQ(style.getFontFamily(), (FontWeight)object2, n, object == null ? FontSynthesis.Companion.getAll-GVVA2EU() : ((FontSynthesis)object).unbox-impl());
    }
}

