/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.collection.LruCache;
import androidx.compose.ui.text.font.AndroidFont;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontMatcher;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.font.ResourceFont;
import androidx.compose.ui.text.platform.AndroidTypeface;
import androidx.compose.ui.text.platform.TypefaceAdapterHelperMethods;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0010\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J;\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J5\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006 "}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter;", "", "fontMatcher", "Landroidx/compose/ui/text/font/FontMatcher;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/text/font/FontMatcher;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "getFontMatcher", "()Landroidx/compose/ui/text/font/FontMatcher;", "getResourceLoader", "()Landroidx/compose/ui/text/font/Font$ResourceLoader;", "create", "Landroid/graphics/Typeface;", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "create-DPcqOEQ", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;II)Landroid/graphics/Typeface;", "Landroidx/compose/ui/text/font/FontListFontFamily;", "create-xC2X5gM", "(ILandroidx/compose/ui/text/font/FontWeight;Landroidx/compose/ui/text/font/FontListFontFamily;I)Landroid/graphics/Typeface;", "genericFontFamily", "", "create-RetOiIg", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroid/graphics/Typeface;", "CacheKey", "Companion", "ui-text_release"})
public class TypefaceAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontMatcher fontMatcher;
    @NotNull
    private final Font.ResourceLoader resourceLoader;
    @NotNull
    private static final FontWeight ANDROID_BOLD = FontWeight.Companion.getW600();
    @NotNull
    private static final LruCache<CacheKey, Typeface> typefaceCache = new LruCache(16);

    public TypefaceAdapter(@NotNull FontMatcher fontMatcher, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)fontMatcher, (String)"fontMatcher");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.fontMatcher = fontMatcher;
        this.resourceLoader = resourceLoader;
    }

    public /* synthetic */ TypefaceAdapter(FontMatcher fontMatcher, Font.ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fontMatcher = new FontMatcher();
        }
        this(fontMatcher, resourceLoader);
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public Typeface create-DPcqOEQ(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle, int fontSynthesis) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        CacheKey cacheKey = new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis, null);
        Typeface cachedTypeface = (Typeface)typefaceCache.get((Object)cacheKey);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            typeface = this.create-xC2X5gM(fontStyle, fontWeight, (FontListFontFamily)fontFamily, fontSynthesis);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            typeface = this.create-RetOiIg(((GenericFontFamily)fontFamily).getName(), fontWeight, fontStyle);
        } else if (fontFamily2 instanceof DefaultFontFamily ? true : fontFamily2 == null) {
            typeface = this.create-RetOiIg(null, fontWeight, fontStyle);
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            typeface = ((AndroidTypeface)((LoadedFontFamily)fontFamily).getTypeface()).getNativeTypeface-PYhJU0U(fontWeight, fontStyle, fontSynthesis);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface2 = typeface;
        typefaceCache.put((Object)cacheKey, (Object)typeface2);
        return typeface2;
    }

    public static /* synthetic */ Typeface create-DPcqOEQ$default(TypefaceAdapter typefaceAdapter, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create-DPcqOEQ");
        }
        if ((n3 & 1) != 0) {
            fontFamily = null;
        }
        if ((n3 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n3 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        if ((n3 & 8) != 0) {
            n2 = FontSynthesis.Companion.getAll-GVVA2EU();
        }
        return typefaceAdapter.create-DPcqOEQ(fontFamily, fontWeight, n, n2);
    }

    private final Typeface create-RetOiIg(String genericFontFamily, FontWeight fontWeight, int fontStyle) {
        Object object;
        CharSequence charSequence;
        if (FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getNormal-_-LCdwA()) && Intrinsics.areEqual((Object)fontWeight, (Object)FontWeight.Companion.getNormal())) {
            charSequence = genericFontFamily;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                charSequence = Typeface.DEFAULT;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"DEFAULT");
                return charSequence;
            }
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = Companion.getTypefaceStyle-FO1MlWM(fontWeight, fontStyle);
            CharSequence charSequence2 = genericFontFamily;
            boolean bl = false;
            boolean bl3 = false;
            charSequence = charSequence2 == null || charSequence2.length() == 0 ? Typeface.defaultFromStyle((int)targetStyle) : Typeface.create((String)genericFontFamily, (int)targetStyle);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"{\n            val targetStyle = getTypefaceStyle(fontWeight, fontStyle)\n            if (genericFontFamily.isNullOrEmpty()) {\n                Typeface.defaultFromStyle(targetStyle)\n            } else {\n                Typeface.create(genericFontFamily, targetStyle)\n            }\n        }");
            object = charSequence;
        } else {
            Typeface familyTypeface = genericFontFamily == null ? Typeface.DEFAULT : Typeface.create((String)genericFontFamily, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)familyTypeface, (String)"familyTypeface");
            object = TypefaceAdapterHelperMethods.INSTANCE.create(familyTypeface, fontWeight.getWeight(), FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getItalic-_-LCdwA()));
        }
        return object;
    }

    static /* synthetic */ Typeface create-RetOiIg$default(TypefaceAdapter typefaceAdapter, String string, FontWeight fontWeight, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create-RetOiIg");
        }
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return typefaceAdapter.create-RetOiIg(string, fontWeight, n);
    }

    private final Typeface create-xC2X5gM(int fontStyle, FontWeight fontWeight, FontListFontFamily fontFamily, int fontSynthesis) {
        boolean loadedFontIsSameAsRequest;
        Font font;
        Font font2 = this.fontMatcher.matchFont-RetOiIg(fontFamily, fontWeight, fontStyle);
        try {
            Typeface typeface;
            font = font2;
            if (font instanceof ResourceFont) {
                typeface = (Typeface)this.resourceLoader.load(font2);
            } else if (font instanceof AndroidFont) {
                typeface = ((AndroidFont)font2).getTypeface();
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown font type: ", (Object)font2));
            }
            font = typeface;
        }
        catch (Exception e) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot create Typeface from ", (Object)font2), e);
        }
        Font typeface = font;
        boolean bl = loadedFontIsSameAsRequest = Intrinsics.areEqual((Object)fontWeight, (Object)font2.getWeight()) && FontStyle.equals-impl0(fontStyle, font2.getStyle-_-LCdwA());
        if (FontSynthesis.equals-impl0(fontSynthesis, FontSynthesis.Companion.getNone-GVVA2EU()) || loadedFontIsSameAsRequest) {
            return typeface;
        }
        return Companion.synthesize-Wqqsr6A((Typeface)typeface, font2, fontWeight, fontStyle, fontSynthesis);
    }

    static /* synthetic */ Typeface create-xC2X5gM$default(TypefaceAdapter typefaceAdapter, int n, FontWeight fontWeight, FontListFontFamily fontListFontFamily, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create-xC2X5gM");
        }
        if ((n3 & 1) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        if ((n3 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n3 & 8) != 0) {
            n2 = FontSynthesis.Companion.getAll-GVVA2EU();
        }
        return typefaceAdapter.create-xC2X5gM(n, fontWeight, fontListFontFamily, n2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B,\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0019\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u0019\u0010\u0017\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u000eJ@\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006#"}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter$CacheKey;", "", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;IILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getFontFamily", "()Landroidx/compose/ui/text/font/FontFamily;", "getFontStyle-_-LCdwA", "()I", "I", "getFontSynthesis-GVVA2EU", "getFontWeight", "()Landroidx/compose/ui/text/font/FontWeight;", "component1", "component2", "component3", "component3-_-LCdwA", "component4", "component4-GVVA2EU", "copy", "copy-DPcqOEQ", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;II)Landroidx/compose/ui/text/platform/TypefaceAdapter$CacheKey;", "equals", "", "other", "hashCode", "", "toString", "", "ui-text_release"})
    public static final class CacheKey {
        @Nullable
        private final FontFamily fontFamily;
        @NotNull
        private final FontWeight fontWeight;
        private final int fontStyle;
        private final int fontSynthesis;

        private CacheKey(FontFamily fontFamily, FontWeight fontWeight, int fontStyle, int fontSynthesis) {
            this.fontFamily = fontFamily;
            this.fontWeight = fontWeight;
            this.fontStyle = fontStyle;
            this.fontSynthesis = fontSynthesis;
        }

        public /* synthetic */ CacheKey(FontFamily fontFamily, FontWeight fontWeight, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                fontFamily = null;
            }
            this(fontFamily, fontWeight, n, n2, null);
        }

        @Nullable
        public final FontFamily getFontFamily() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight getFontWeight() {
            return this.fontWeight;
        }

        public final int getFontStyle-_-LCdwA() {
            return this.fontStyle;
        }

        public final int getFontSynthesis-GVVA2EU() {
            return this.fontSynthesis;
        }

        @Nullable
        public final FontFamily component1() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight component2() {
            return this.fontWeight;
        }

        public final int component3-_-LCdwA() {
            return this.fontStyle;
        }

        public final int component4-GVVA2EU() {
            return this.fontSynthesis;
        }

        @NotNull
        public final CacheKey copy-DPcqOEQ(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle, int fontSynthesis) {
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            return new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis, null);
        }

        public static /* synthetic */ CacheKey copy-DPcqOEQ$default(CacheKey cacheKey, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                fontFamily = cacheKey.fontFamily;
            }
            if ((n3 & 2) != 0) {
                fontWeight = cacheKey.fontWeight;
            }
            if ((n3 & 4) != 0) {
                n = cacheKey.fontStyle;
            }
            if ((n3 & 8) != 0) {
                n2 = cacheKey.fontSynthesis;
            }
            return cacheKey.copy-DPcqOEQ(fontFamily, fontWeight, n, n2);
        }

        @NotNull
        public String toString() {
            return "CacheKey(fontFamily=" + this.fontFamily + ", fontWeight=" + this.fontWeight + ", fontStyle=" + FontStyle.toString-impl(this.fontStyle) + ", fontSynthesis=" + FontSynthesis.toString-impl(this.fontSynthesis) + ')';
        }

        public int hashCode() {
            int result = this.fontFamily == null ? 0 : this.fontFamily.hashCode();
            result = result * 31 + this.fontWeight.hashCode();
            result = result * 31 + FontStyle.hashCode-impl(this.fontStyle);
            result = result * 31 + FontSynthesis.hashCode-impl(this.fontSynthesis);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)cacheKey.fontFamily)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fontWeight, (Object)cacheKey.fontWeight)) {
                return false;
            }
            if (!FontStyle.equals-impl0(this.fontStyle, cacheKey.fontStyle)) {
                return false;
            }
            return FontSynthesis.equals-impl0(this.fontSynthesis, cacheKey.fontSynthesis);
        }

        public /* synthetic */ CacheKey(FontFamily fontFamily, FontWeight fontWeight, int fontStyle, int fontSynthesis, DefaultConstructorMarker $constructor_marker) {
            this(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J;\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001d"}, d2={"Landroidx/compose/ui/text/platform/TypefaceAdapter$Companion;", "", "()V", "ANDROID_BOLD", "Landroidx/compose/ui/text/font/FontWeight;", "typefaceCache", "Landroidx/collection/LruCache;", "Landroidx/compose/ui/text/platform/TypefaceAdapter$CacheKey;", "Landroid/graphics/Typeface;", "getTypefaceCache", "()Landroidx/collection/LruCache;", "getTypefaceStyle", "", "fontWeight", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "getTypefaceStyle-FO1MlWM", "(Landroidx/compose/ui/text/font/FontWeight;I)I", "isBold", "", "isItalic", "synthesize", "typeface", "font", "Landroidx/compose/ui/text/font/Font;", "fontSynthesis", "Landroidx/compose/ui/text/font/FontSynthesis;", "synthesize-Wqqsr6A", "(Landroid/graphics/Typeface;Landroidx/compose/ui/text/font/Font;Landroidx/compose/ui/text/font/FontWeight;II)Landroid/graphics/Typeface;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LruCache<CacheKey, Typeface> getTypefaceCache() {
            return typefaceCache;
        }

        @NotNull
        public final Typeface synthesize-Wqqsr6A(@NotNull Typeface typeface, @NotNull Font font, @NotNull FontWeight fontWeight, int fontStyle, int fontSynthesis) {
            Typeface typeface2;
            boolean synthesizeStyle;
            Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            boolean synthesizeWeight = FontSynthesis.isWeightOn-impl$ui_text_release(fontSynthesis) && fontWeight.compareTo(ANDROID_BOLD) >= 0 && font.getWeight().compareTo(ANDROID_BOLD) < 0;
            boolean bl = synthesizeStyle = FontSynthesis.isStyleOn-impl$ui_text_release(fontSynthesis) && !FontStyle.equals-impl0(fontStyle, font.getStyle-_-LCdwA());
            if (!synthesizeStyle && !synthesizeWeight) {
                return typeface;
            }
            if (Build.VERSION.SDK_INT < 28) {
                int targetStyle = this.getTypefaceStyle(synthesizeWeight, synthesizeStyle && FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getItalic-_-LCdwA()));
                Typeface typeface3 = Typeface.create((Typeface)typeface, (int)targetStyle);
                Intrinsics.checkNotNullExpressionValue((Object)typeface3, (String)"{\n                val targetStyle = getTypefaceStyle(\n                    isBold = synthesizeWeight,\n                    isItalic = synthesizeStyle && fontStyle == FontStyle.Italic\n                )\n                Typeface.create(typeface, targetStyle)\n            }");
                typeface2 = typeface3;
            } else {
                int finalFontWeight = synthesizeWeight ? fontWeight.getWeight() : font.getWeight().getWeight();
                boolean finalFontStyle = synthesizeStyle ? FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getItalic-_-LCdwA()) : FontStyle.equals-impl0(font.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA());
                typeface2 = TypefaceAdapterHelperMethods.INSTANCE.create(typeface, finalFontWeight, finalFontStyle);
            }
            return typeface2;
        }

        public final int getTypefaceStyle-FO1MlWM(@NotNull FontWeight fontWeight, int fontStyle) {
            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
            return this.getTypefaceStyle(fontWeight.compareTo(ANDROID_BOLD) >= 0, FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getItalic-_-LCdwA()));
        }

        private final int getTypefaceStyle(boolean isBold, boolean isItalic) {
            return isItalic && isBold ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

