/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.content.Context;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamilyKt;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.font.Typeface;
import androidx.compose.ui.text.platform.AndroidDefaultTypeface;
import androidx.compose.ui.text.platform.AndroidFontListTypeface;
import androidx.compose.ui.text.platform.AndroidGenericFontFamilyTypeface;
import androidx.compose.ui.text.platform.AndroidTypefaceWrapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a7\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u001c\b\u0002\u0010\t\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0018\u00010\n\u00f8\u0001\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"FontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "typeface", "Landroid/graphics/Typeface;", "Typeface", "Landroidx/compose/ui/text/font/Typeface;", "context", "Landroid/content/Context;", "fontFamily", "styles", "", "Lkotlin/Pair;", "Landroidx/compose/ui/text/font/FontWeight;", "Landroidx/compose/ui/text/font/FontStyle;", "ui-text_release"})
public final class AndroidTypeface_androidKt {
    @NotNull
    public static final Typeface Typeface(@NotNull Context context, @NotNull FontFamily fontFamily, @Nullable List<Pair<FontWeight, FontStyle>> styles) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            typeface = new AndroidFontListTypeface((FontListFontFamily)fontFamily, context, styles, null, 8, null);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            typeface = new AndroidGenericFontFamilyTypeface((GenericFontFamily)fontFamily);
        } else if (fontFamily2 instanceof DefaultFontFamily) {
            typeface = new AndroidDefaultTypeface();
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            typeface = ((LoadedFontFamily)fontFamily).getTypeface();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return typeface;
    }

    public static /* synthetic */ Typeface Typeface$default(Context context, FontFamily fontFamily, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return AndroidTypeface_androidKt.Typeface(context, fontFamily, list);
    }

    @NotNull
    public static final Typeface Typeface(@NotNull android.graphics.Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        return new AndroidTypefaceWrapper(typeface);
    }

    @NotNull
    public static final FontFamily FontFamily(@NotNull android.graphics.Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        return FontFamilyKt.FontFamily(AndroidTypeface_androidKt.Typeface(typeface));
    }
}

