/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "(II)V", "getLengthAfterCursor", "()I", "getLengthBeforeCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text_release"})
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;

    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        this.lengthBeforeCursor = lengthBeforeCursor;
        this.lengthAfterCursor = lengthAfterCursor;
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        int trail;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = 0;
        int n2 = this.lengthBeforeCursor;
        while (n < n2) {
            char lead;
            int i = n++;
            int n3 = beforeLenInChars;
            beforeLenInChars = n3 + 1;
            if (buffer.getSelectionStart$ui_text_release() > beforeLenInChars && EditCommandKt.access$isSurrogatePair(lead = buffer.get$ui_text_release(buffer.getSelectionStart$ui_text_release() - beforeLenInChars - 1), (char)(trail = (int)buffer.get$ui_text_release(buffer.getSelectionStart$ui_text_release() - beforeLenInChars)))) {
                int n4 = beforeLenInChars;
                beforeLenInChars = n4 + 1;
            }
            if (beforeLenInChars != buffer.getSelectionStart$ui_text_release()) continue;
        }
        int afterLenInChars = 0;
        n2 = 0;
        int n5 = this.lengthAfterCursor;
        while (n2 < n5) {
            char trail2;
            char lead;
            int i = n2++;
            trail = afterLenInChars;
            afterLenInChars = trail + 1;
            if (buffer.getSelectionEnd$ui_text_release() + afterLenInChars < buffer.getLength$ui_text_release() && EditCommandKt.access$isSurrogatePair(lead = buffer.get$ui_text_release(buffer.getSelectionEnd$ui_text_release() + afterLenInChars - 1), trail2 = buffer.get$ui_text_release(buffer.getSelectionEnd$ui_text_release() + afterLenInChars))) {
                int n6 = afterLenInChars;
                afterLenInChars = n6 + '\u0001';
            }
            if (buffer.getSelectionEnd$ui_text_release() + afterLenInChars != buffer.getLength$ui_text_release()) continue;
        }
        buffer.delete$ui_text_release(buffer.getSelectionEnd$ui_text_release(), buffer.getSelectionEnd$ui_text_release() + afterLenInChars);
        buffer.delete$ui_text_release(buffer.getSelectionStart$ui_text_release() - beforeLenInChars, buffer.getSelectionStart$ui_text_release());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)other).lengthAfterCursor;
    }

    public int hashCode() {
        int result = this.lengthBeforeCursor;
        result = 31 * result + this.lengthAfterCursor;
        return result;
    }

    @NotNull
    public String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ')';
    }
}

