/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RestrictTo;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.InternalTextApi;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.platform.Api28Impl;
import androidx.compose.ui.text.platform.TypefaceAdapter;
import androidx.compose.ui.text.platform.extensions.SpannableExtensions_androidKt;
import androidx.compose.ui.text.platform.extensions.TtsAnnotationExtensions_androidKt;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\u0002*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"setSpanStyle", "", "Landroid/text/SpannableString;", "spanStyle", "Landroidx/compose/ui/text/SpanStyle;", "start", "", "end", "density", "Landroidx/compose/ui/unit/Density;", "typefaceAdapter", "Landroidx/compose/ui/text/platform/TypefaceAdapter;", "toAccessibilitySpannableString", "Landroidx/compose/ui/text/AnnotatedString;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "ui-text_release"})
public final class AndroidAccessibilitySpannableString_androidKt {
    @InternalTextApi
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final SpannableString toAccessibilitySpannableString(@NotNull AnnotatedString $this$toAccessibilitySpannableString, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        int end;
        int start;
        AnnotatedString.Range<Object> item$iv;
        int index$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toAccessibilitySpannableString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        SpannableString spannableString = new SpannableString((CharSequence)$this$toAccessibilitySpannableString.getText());
        TypefaceAdapter typefaceAdapter = new TypefaceAdapter(null, resourceLoader, 1, null);
        List<AnnotatedString.Range<Object>> $this$fastForEach$iv = $this$toAccessibilitySpannableString.getSpanStyles();
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            index$iv = n++;
            item$iv = $this$fastForEach$iv.get(index$iv);
            AnnotatedString.Range<SpanStyle> $dstr$style$start$end = item$iv;
            boolean bl = false;
            SpanStyle style = $dstr$style$start$end.component1();
            start = $dstr$style$start$end.component2();
            end = $dstr$style$start$end.component3();
            AndroidAccessibilitySpannableString_androidKt.setSpanStyle(spannableString, style, start, end, density, typefaceAdapter);
        }
        $this$fastForEach$iv = $this$toAccessibilitySpannableString.getTtsAnnotations(0, $this$toAccessibilitySpannableString.length());
        $i$f$fastForEach = false;
        n = 0;
        n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            index$iv = n++;
            AnnotatedString.Range<Object> $dstr$ttsAnnotation$start$end = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            TtsAnnotation ttsAnnotation = (TtsAnnotation)$dstr$ttsAnnotation$start$end.component1();
            start = $dstr$ttsAnnotation$start$end.component2();
            end = $dstr$ttsAnnotation$start$end.component3();
            spannableString.setSpan((Object)TtsAnnotationExtensions_androidKt.toSpan(ttsAnnotation), start, end, 33);
        }
        return spannableString;
    }

    private static final void setSpanStyle(SpannableString $this$setSpanStyle, SpanStyle spanStyle, int start, int end, Density density, TypefaceAdapter typefaceAdapter) {
        SpannableExtensions_androidKt.setColor-RPmYEkk((Spannable)$this$setSpanStyle, spanStyle.getColor-0d7_KjU(), start, end);
        SpannableExtensions_androidKt.setFontSize-KmRG4DE((Spannable)$this$setSpanStyle, spanStyle.getFontSize-XSAIIZE(), density, start, end);
        if (spanStyle.getFontWeight() != null || spanStyle.getFontStyle-4Lr2A7w() != null) {
            FontWeight fontWeight = spanStyle.getFontWeight();
            if (fontWeight == null) {
                fontWeight = FontWeight.Companion.getNormal();
            }
            FontWeight fontWeight2 = fontWeight;
            FontStyle fontStyle = spanStyle.getFontStyle-4Lr2A7w();
            int fontStyle2 = fontStyle == null ? FontStyle.Companion.getNormal-_-LCdwA() : fontStyle.unbox-impl();
            $this$setSpanStyle.setSpan((Object)new StyleSpan(TypefaceAdapter.Companion.getTypefaceStyle-FO1MlWM(fontWeight2, fontStyle2)), start, end, 33);
        }
        if (spanStyle.getFontFamily() != null) {
            if (spanStyle.getFontFamily() instanceof GenericFontFamily) {
                $this$setSpanStyle.setSpan((Object)new TypefaceSpan(((GenericFontFamily)spanStyle.getFontFamily()).getName()), start, end, 33);
            } else if (Build.VERSION.SDK_INT >= 28) {
                FontSynthesis fontSynthesis = spanStyle.getFontSynthesis-ZQGJjVo();
                Typeface typeface = TypefaceAdapter.create-DPcqOEQ$default(typefaceAdapter, spanStyle.getFontFamily(), null, 0, fontSynthesis == null ? FontSynthesis.Companion.getAll-GVVA2EU() : fontSynthesis.unbox-impl(), 6, null);
                $this$setSpanStyle.setSpan((Object)Api28Impl.INSTANCE.createTypefaceSpan(typeface), start, end, 33);
            }
        }
        if (spanStyle.getTextDecoration() != null) {
            if (spanStyle.getTextDecoration().contains(TextDecoration.Companion.getUnderline())) {
                $this$setSpanStyle.setSpan((Object)new UnderlineSpan(), start, end, 33);
            }
            if (spanStyle.getTextDecoration().contains(TextDecoration.Companion.getLineThrough())) {
                $this$setSpanStyle.setSpan((Object)new StrikethroughSpan(), start, end, 33);
            }
        }
        if (spanStyle.getTextGeometricTransform() != null) {
            $this$setSpanStyle.setSpan((Object)new ScaleXSpan(spanStyle.getTextGeometricTransform().getScaleX()), start, end, 33);
        }
        SpannableExtensions_androidKt.setLocaleList((Spannable)$this$setSpanStyle, spanStyle.getLocaleList(), start, end);
        SpannableExtensions_androidKt.setBackground-RPmYEkk((Spannable)$this$setSpanStyle, spanStyle.getBackground-0d7_KjU(), start, end);
    }
}

