/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Rect;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import androidx.compose.ui.text.android.PaintExtensionsKt;
import androidx.compose.ui.text.android.TextLayout;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"getTextDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "textDirectionHeuristic", "", "getVerticalPaddings", "Lkotlin/Pair;", "Landroidx/compose/ui/text/android/TextLayout;", "ui-text_release"})
public final class TextLayoutKt {
    @NotNull
    public static final TextDirectionHeuristic getTextDirectionHeuristic(int textDirectionHeuristic) {
        TextDirectionHeuristic textDirectionHeuristic2;
        switch (textDirectionHeuristic) {
            case 0: {
                TextDirectionHeuristic textDirectionHeuristic3 = TextDirectionHeuristics.LTR;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic3, (String)"LTR");
                textDirectionHeuristic2 = textDirectionHeuristic3;
                break;
            }
            case 5: {
                TextDirectionHeuristic textDirectionHeuristic4 = TextDirectionHeuristics.LOCALE;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic4, (String)"LOCALE");
                textDirectionHeuristic2 = textDirectionHeuristic4;
                break;
            }
            case 1: {
                TextDirectionHeuristic textDirectionHeuristic5 = TextDirectionHeuristics.RTL;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic5, (String)"RTL");
                textDirectionHeuristic2 = textDirectionHeuristic5;
                break;
            }
            case 3: {
                TextDirectionHeuristic textDirectionHeuristic6 = TextDirectionHeuristics.FIRSTSTRONG_RTL;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic6, (String)"FIRSTSTRONG_RTL");
                textDirectionHeuristic2 = textDirectionHeuristic6;
                break;
            }
            case 4: {
                TextDirectionHeuristic textDirectionHeuristic7 = TextDirectionHeuristics.ANYRTL_LTR;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic7, (String)"ANYRTL_LTR");
                textDirectionHeuristic2 = textDirectionHeuristic7;
                break;
            }
            case 2: {
                TextDirectionHeuristic textDirectionHeuristic8 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic8, (String)"FIRSTSTRONG_LTR");
                textDirectionHeuristic2 = textDirectionHeuristic8;
                break;
            }
            default: {
                TextDirectionHeuristic textDirectionHeuristic9 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic9, (String)"FIRSTSTRONG_LTR");
                textDirectionHeuristic2 = textDirectionHeuristic9;
            }
        }
        return textDirectionHeuristic2;
    }

    private static final Pair<Integer, Integer> getVerticalPaddings(TextLayout $this$getVerticalPaddings) {
        Rect rect;
        int topPadding;
        if ($this$getVerticalPaddings.getIncludePadding() || $this$getVerticalPaddings.isFallbackLinespacingApplied$ui_text_release()) {
            return new Pair((Object)0, (Object)0);
        }
        TextPaint paint = $this$getVerticalPaddings.getLayout().getPaint();
        CharSequence text = $this$getVerticalPaddings.getLayout().getText();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"paint");
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        Rect firstLineTextBounds = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(0), $this$getVerticalPaddings.getLayout().getLineEnd(0));
        int ascent = $this$getVerticalPaddings.getLayout().getLineAscent(0);
        int n = topPadding = firstLineTextBounds.top < ascent ? ascent - firstLineTextBounds.top : $this$getVerticalPaddings.getLayout().getTopPadding();
        if ($this$getVerticalPaddings.getLineCount() == 1) {
            rect = firstLineTextBounds;
        } else {
            int line = $this$getVerticalPaddings.getLayout().getLineCount() - 1;
            rect = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(line), $this$getVerticalPaddings.getLayout().getLineEnd(line));
        }
        Rect lastLineTextBounds = rect;
        int descent = $this$getVerticalPaddings.getLayout().getLineDescent($this$getVerticalPaddings.getLayout().getLineCount() - 1);
        int bottomPadding = lastLineTextBounds.bottom > descent ? lastLineTextBounds.bottom - descent : $this$getVerticalPaddings.getLayout().getBottomPadding();
        return new Pair((Object)topPadding, (Object)bottomPadding);
    }

    public static final /* synthetic */ Pair access$getVerticalPaddings(TextLayout $receiver) {
        return TextLayoutKt.getVerticalPaddings($receiver);
    }
}

