/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.graphics.Typeface;
import android.os.Build;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.font.AndroidFontUtils_androidKt;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamilyTypefaceAdapter;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.font.PlatformFontLoader;
import androidx.compose.ui.text.font.TypefaceHelperMethodsApi28;
import androidx.compose.ui.text.font.TypefaceRequest;
import androidx.compose.ui.text.font.TypefaceResult;
import androidx.compose.ui.text.platform.AndroidTypeface;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalTextApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJB\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00180\u0014H\u0016\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/font/PlatformFontFamilyTypefaceAdapter;", "Landroidx/compose/ui/text/font/FontFamilyTypefaceAdapter;", "()V", "create", "Landroid/graphics/Typeface;", "genericFontFamily", "", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "create-RetOiIg", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroid/graphics/Typeface;", "resolve", "Landroidx/compose/ui/text/font/TypefaceResult;", "typefaceRequest", "Landroidx/compose/ui/text/font/TypefaceRequest;", "platformFontLoader", "Landroidx/compose/ui/text/font/PlatformFontLoader;", "onAsyncCompletion", "Lkotlin/Function1;", "Landroidx/compose/ui/text/font/TypefaceResult$Immutable;", "", "createDefaultTypeface", "", "ui-text_release"})
public final class PlatformFontFamilyTypefaceAdapter
implements FontFamilyTypefaceAdapter {
    @Override
    @Nullable
    public TypefaceResult resolve(@NotNull TypefaceRequest typefaceRequest, @NotNull PlatformFontLoader platformFontLoader, @NotNull Function1<? super TypefaceResult.Immutable, Unit> onAsyncCompletion, @NotNull Function1<? super TypefaceRequest, ? extends Object> createDefaultTypeface2) {
        Typeface typeface2;
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)typefaceRequest, (String)"typefaceRequest");
        Intrinsics.checkNotNullParameter((Object)platformFontLoader, (String)"platformFontLoader");
        Intrinsics.checkNotNullParameter(onAsyncCompletion, (String)"onAsyncCompletion");
        Intrinsics.checkNotNullParameter(createDefaultTypeface2, (String)"createDefaultTypeface");
        FontFamily fontFamily2 = fontFamily = typefaceRequest.getFontFamily();
        if (fontFamily2 == null ? true : fontFamily2 instanceof DefaultFontFamily) {
            typeface2 = this.create-RetOiIg(null, typefaceRequest.getFontWeight(), typefaceRequest.getFontStyle-_-LCdwA());
        } else if (fontFamily instanceof GenericFontFamily) {
            typeface2 = this.create-RetOiIg(((GenericFontFamily)typefaceRequest.getFontFamily()).getName(), typefaceRequest.getFontWeight(), typefaceRequest.getFontStyle-_-LCdwA());
        } else if (fontFamily instanceof LoadedFontFamily) {
            typeface2 = ((AndroidTypeface)((LoadedFontFamily)typefaceRequest.getFontFamily()).getTypeface()).getNativeTypeface-PYhJU0U(typefaceRequest.getFontWeight(), typefaceRequest.getFontStyle-_-LCdwA(), typefaceRequest.getFontSynthesis-GVVA2EU());
        } else {
            return null;
        }
        Typeface result2 = typeface2;
        return new TypefaceResult.Immutable(result2, false, 2, null);
    }

    private final Typeface create-RetOiIg(String genericFontFamily, FontWeight fontWeight, int fontStyle) {
        Object object;
        CharSequence charSequence;
        if (FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getNormal-_-LCdwA()) && Intrinsics.areEqual((Object)fontWeight, (Object)FontWeight.Companion.getNormal()) && ((charSequence = (CharSequence)genericFontFamily) == null || charSequence.length() == 0)) {
            charSequence = Typeface.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"DEFAULT");
            return charSequence;
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = AndroidFontUtils_androidKt.getAndroidTypefaceStyle-FO1MlWM(fontWeight, fontStyle);
            CharSequence charSequence2 = genericFontFamily;
            charSequence = charSequence2 == null || charSequence2.length() == 0 ? Typeface.defaultFromStyle((int)targetStyle) : Typeface.create((String)genericFontFamily, (int)targetStyle);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"{\n            val target\u2026)\n            }\n        }");
            object = charSequence;
        } else {
            Typeface familyTypeface = genericFontFamily == null ? Typeface.DEFAULT : Typeface.create((String)genericFontFamily, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)familyTypeface, (String)"familyTypeface");
            object = TypefaceHelperMethodsApi28.INSTANCE.create(familyTypeface, fontWeight.getWeight(), FontStyle.equals-impl0(fontStyle, FontStyle.Companion.getItalic-_-LCdwA()));
        }
        return object;
    }

    static /* synthetic */ Typeface create-RetOiIg$default(PlatformFontFamilyTypefaceAdapter platformFontFamilyTypefaceAdapter, String string, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return platformFontFamilyTypefaceAdapter.create-RetOiIg(string, fontWeight, n);
    }
}

