/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.ui.text.platform.Synchronization_jvmKt;
import androidx.compose.ui.text.platform.SynchronizedObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u00012\b\u0010\u001f\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\b\u001a\u00020\u0005J\u0015\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0006\u0010\u0013\u001a\u00020\u0005J\u0015\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010(\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,J'\u0010-\u001a\u0002H.\"\u0004\b\u0002\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000ej\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"Landroidx/compose/ui/text/caches/LruCache;", "K", "V", "", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "keySet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "missCount", "monitor", "Landroidx/compose/ui/text/platform/SynchronizedObject;", "putCount", "<set-?>", "size", "()I", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "synchronizedValue", "R", "block", "Lkotlin/Function0;", "synchronizedValue$ui_text_release", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "", "trimToSize", "ui-text_release"})
public class LruCache<K, V> {
    @NotNull
    private final SynchronizedObject monitor = Synchronization_jvmKt.createSynchronizedObject();
    @NotNull
    private final HashMap<K, V> map;
    @NotNull
    private final LinkedHashSet<K> keySet;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="size")
    public final int size() {
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            int n = this.size;
            return n;
        }
    }

    public LruCache(int maxSize) {
        if (!(maxSize > 0)) {
            boolean bl = false;
            String string = "maxSize <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSize = maxSize;
        this.map = new HashMap(0, 0.75f);
        this.keySet = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int maxSize) {
        if (!(maxSize > 0)) {
            boolean $i$a$-require-LruCache$resize$22 = false;
            String $i$a$-require-LruCache$resize$22 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-LruCache$resize$22.toString());
        }
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            this.maxSize = maxSize;
            Unit unit = Unit.INSTANCE;
        }
        this.trimToSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V get(K key) {
        int n;
        V mapValue = null;
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            block11: {
                boolean bl = false;
                mapValue = this.map.get(key);
                if (mapValue == null) break block11;
                this.keySet.remove(key);
                this.keySet.add(key);
                int n2 = this.hitCount;
                this.hitCount = n2 + 1;
                V v = mapValue;
                return v;
            }
            int n3 = this.missCount;
            this.missCount = n3 + 1;
            n = n3;
        }
        V createdValue = this.create(key);
        if (createdValue == null) {
            return null;
        }
        SynchronizedObject lock$iv2 = this.monitor;
        boolean $i$f$synchronized2 = false;
        synchronized (lock$iv2) {
            boolean bl = false;
            n = this.createCount;
            this.createCount = n + 1;
            V previousValue = this.map.put(key, createdValue);
            this.keySet.remove(key);
            this.keySet.add(key);
            if (previousValue != null) {
                this.map.put(key, previousValue);
                mapValue = previousValue;
            } else {
                this.size = this.size() + this.safeSizeOf(key, createdValue);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            return mapValue;
        }
        this.trimToSize(this.maxSize);
        return createdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        V previous = null;
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size = this.size() + this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.size = this.size() - this.safeSizeOf(key, previous);
            }
            if (this.keySet.contains(key)) {
                this.keySet.remove(key);
            }
            boolean bl2 = this.keySet.add(key);
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            Object key = null;
            V value = null;
            SynchronizedObject lock$iv = this.monitor;
            boolean $i$f$synchronized = false;
            synchronized (lock$iv) {
                boolean bl = false;
                if (this.size() < 0 || this.map.isEmpty() && this.size() != 0 || this.map.isEmpty() != this.keySet.isEmpty()) {
                    throw new IllegalStateException("map/keySet size inconsistency");
                }
                if (this.size() > maxSize && !this.map.isEmpty()) {
                    key = CollectionsKt.first((Iterable)this.keySet);
                    Object v = ((Map)this.map).get(key);
                    if (v == null) {
                        throw new IllegalStateException("inconsistent state");
                    }
                    value = v;
                    ((Map)this.map).remove(key);
                    ((Collection)this.keySet).remove(key);
                    int n = this.size();
                    Object object = key;
                    Intrinsics.checkNotNull((Object)object);
                    this.size = n - this.safeSizeOf(object, value);
                    int n2 = this.evictionCount;
                    this.evictionCount = n2 + 1;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (key == null && value == null) break;
            Object object = key;
            Intrinsics.checkNotNull((Object)object);
            V v = value;
            Intrinsics.checkNotNull(v);
            this.entryRemoved(true, object, v, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        V previous = null;
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            previous = this.map.remove(key);
            this.keySet.remove(key);
            if (previous != null) {
                this.size = this.size() - this.safeSizeOf(key, previous);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, @Nullable V newValue) {
    }

    @Nullable
    protected V create(K key) {
        return null;
    }

    private final int safeSizeOf(K key, V value) {
        int result2 = this.sizeOf(key, value);
        if (!(result2 >= 0)) {
            boolean bl = false;
            String string = "Negative size: " + key + '=' + value;
            throw new IllegalStateException(string.toString());
        }
        return result2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int maxSize() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.maxSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hitCount() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.hitCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int missCount() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.missCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createCount() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.createCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putCount() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.putCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int evictionCount() {
        int n;
        LruCache this_$iv = this;
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv$iv = this_$iv.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            n = this.evictionCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<K, V> snapshot() {
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Object key : this.keySet) {
                V v = this.map.get(key);
                Intrinsics.checkNotNull(v);
                linkedHashMap.put(key, v);
            }
            Map map = linkedHashMap;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            boolean bl = false;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + hitPercent + "%]";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R synchronizedValue$ui_text_release(@NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$synchronizedValue$ui_text_release = false;
        SynchronizedObject lock$iv = this.monitor;
        boolean $i$f$synchronized = false;
        synchronized (lock$iv) {
            Object object;
            try {
                object = block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : lock$iv
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
    }
}

