/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutCache;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurerKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalTextApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u008d\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\t2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Landroidx/compose/ui/text/TextMeasurer;", "", "fallbackFontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "fallbackDensity", "Landroidx/compose/ui/unit/Density;", "fallbackLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "cacheSize", "", "(Landroidx/compose/ui/text/font/FontFamily$Resolver;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;I)V", "textLayoutCache", "Landroidx/compose/ui/text/TextLayoutCache;", "measure", "Landroidx/compose/ui/text/TextLayoutResult;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "softWrap", "", "maxLines", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "layoutDirection", "density", "fontFamilyResolver", "skipCache", "measure-xDpz5zY", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;IZILjava/util/List;JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;Z)Landroidx/compose/ui/text/TextLayoutResult;", "Companion", "ui-text_release"})
@Immutable
public final class TextMeasurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontFamily.Resolver fallbackFontFamilyResolver;
    @NotNull
    private final Density fallbackDensity;
    @NotNull
    private final LayoutDirection fallbackLayoutDirection;
    private final int cacheSize;
    @Nullable
    private final TextLayoutCache textLayoutCache;

    public TextMeasurer(@NotNull FontFamily.Resolver fallbackFontFamilyResolver, @NotNull Density fallbackDensity, @NotNull LayoutDirection fallbackLayoutDirection, int cacheSize) {
        Intrinsics.checkNotNullParameter((Object)fallbackFontFamilyResolver, (String)"fallbackFontFamilyResolver");
        Intrinsics.checkNotNullParameter((Object)fallbackDensity, (String)"fallbackDensity");
        Intrinsics.checkNotNullParameter((Object)fallbackLayoutDirection, (String)"fallbackLayoutDirection");
        this.fallbackFontFamilyResolver = fallbackFontFamilyResolver;
        this.fallbackDensity = fallbackDensity;
        this.fallbackLayoutDirection = fallbackLayoutDirection;
        this.cacheSize = cacheSize;
        this.textLayoutCache = this.cacheSize > 0 ? new TextLayoutCache(this.cacheSize) : null;
    }

    public /* synthetic */ TextMeasurer(FontFamily.Resolver resolver, Density density, LayoutDirection layoutDirection, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = TextMeasurerKt.access$getDefaultCacheSize$p();
        }
        this(resolver, density, layoutDirection, n);
    }

    @Stable
    @NotNull
    public final TextLayoutResult measure-xDpz5zY(@NotNull AnnotatedString text, @NotNull TextStyle style, int overflow, boolean softWrap, int maxLines, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, long constraints, @NotNull LayoutDirection layoutDirection, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver, boolean skipCache) {
        TextLayoutResult textLayoutResult;
        TextLayoutResult cacheResult;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        TextLayoutInput requestedTextLayoutInput = new TextLayoutInput(text, style, placeholders, maxLines, softWrap, overflow, density, layoutDirection, fontFamilyResolver, constraints, null);
        TextLayoutResult textLayoutResult2 = cacheResult = !skipCache && this.textLayoutCache != null ? this.textLayoutCache.get(requestedTextLayoutInput) : null;
        if (cacheResult != null) {
            textLayoutResult = cacheResult.copy-O0kMr_c(requestedTextLayoutInput, ConstraintsKt.constrain-4WqzIAM((long)constraints, (long)IntSizeKt.IntSize((int)ParagraphKt.ceilToInt(cacheResult.getMultiParagraph().getWidth()), (int)ParagraphKt.ceilToInt(cacheResult.getMultiParagraph().getHeight()))));
        } else {
            TextLayoutResult textLayoutResult3;
            TextLayoutResult it = textLayoutResult3 = TextMeasurer.Companion.layout(requestedTextLayoutInput);
            boolean bl = false;
            TextLayoutCache textLayoutCache = this.textLayoutCache;
            if (textLayoutCache != null) {
                textLayoutCache.put(requestedTextLayoutInput, it);
            }
            textLayoutResult = textLayoutResult3;
        }
        return textLayoutResult;
    }

    public static /* synthetic */ TextLayoutResult measure-xDpz5zY$default(TextMeasurer textMeasurer, AnnotatedString annotatedString, TextStyle textStyle, int n, boolean bl, int n2, List list, long l, LayoutDirection layoutDirection, Density density, FontFamily.Resolver resolver, boolean bl2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            textStyle = TextStyle.Companion.getDefault();
        }
        if ((n3 & 4) != 0) {
            n = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        if ((n3 & 0x10) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 0x40) != 0) {
            l = ConstraintsKt.Constraints$default((int)0, (int)0, (int)0, (int)0, (int)15, null);
        }
        if ((n3 & 0x80) != 0) {
            layoutDirection = textMeasurer.fallbackLayoutDirection;
        }
        if ((n3 & 0x100) != 0) {
            density = textMeasurer.fallbackDensity;
        }
        if ((n3 & 0x200) != 0) {
            resolver = textMeasurer.fallbackFontFamilyResolver;
        }
        if ((n3 & 0x400) != 0) {
            bl2 = false;
        }
        return textMeasurer.measure-xDpz5zY(annotatedString, textStyle, n, bl, n2, list, l, layoutDirection, density, resolver, bl2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/TextMeasurer$Companion;", "", "()V", "layout", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutInput", "Landroidx/compose/ui/text/TextLayoutInput;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        private final TextLayoutResult layout(TextLayoutInput textLayoutInput) {
            TextLayoutInput $this$layout_u24lambda_u2d0 = textLayoutInput;
            boolean bl = false;
            AnnotatedString annotatedString = $this$layout_u24lambda_u2d0.getText();
            TextStyle textStyle = TextStyleKt.resolveDefaults($this$layout_u24lambda_u2d0.getStyle(), $this$layout_u24lambda_u2d0.getLayoutDirection());
            Density density = $this$layout_u24lambda_u2d0.getDensity();
            FontFamily.Resolver resolver = $this$layout_u24lambda_u2d0.getFontFamilyResolver();
            List<AnnotatedString.Range<Placeholder>> list = $this$layout_u24lambda_u2d0.getPlaceholders();
            MultiParagraphIntrinsics nonNullIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list, density, resolver);
            int minWidth = Constraints.getMinWidth-impl((long)$this$layout_u24lambda_u2d0.getConstraints-msEJaDk());
            boolean widthMatters = $this$layout_u24lambda_u2d0.getSoftWrap() || TextOverflow.equals-impl0($this$layout_u24lambda_u2d0.getOverflow-gIe3tQ8(), TextOverflow.Companion.getEllipsis-gIe3tQ8());
            int maxWidth = widthMatters && Constraints.getHasBoundedWidth-impl((long)$this$layout_u24lambda_u2d0.getConstraints-msEJaDk()) ? Constraints.getMaxWidth-impl((long)$this$layout_u24lambda_u2d0.getConstraints-msEJaDk()) : Integer.MAX_VALUE;
            boolean overwriteMaxLines = !$this$layout_u24lambda_u2d0.getSoftWrap() && TextOverflow.equals-impl0($this$layout_u24lambda_u2d0.getOverflow-gIe3tQ8(), TextOverflow.Companion.getEllipsis-gIe3tQ8());
            int finalMaxLines = overwriteMaxLines ? 1 : $this$layout_u24lambda_u2d0.getMaxLines();
            int width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((int)ParagraphKt.ceilToInt(nonNullIntrinsics.getMaxIntrinsicWidth()), (int)minWidth, (int)maxWidth);
            MultiParagraph multiParagraph = new MultiParagraph(nonNullIntrinsics, ConstraintsKt.Constraints$default((int)0, (int)width, (int)0, (int)Constraints.getMaxHeight-impl((long)$this$layout_u24lambda_u2d0.getConstraints-msEJaDk()), (int)5, null), finalMaxLines, TextOverflow.equals-impl0($this$layout_u24lambda_u2d0.getOverflow-gIe3tQ8(), TextOverflow.Companion.getEllipsis-gIe3tQ8()), null);
            return new TextLayoutResult(textLayoutInput, multiParagraph, ConstraintsKt.constrain-4WqzIAM((long)$this$layout_u24lambda_u2d0.getConstraints-msEJaDk(), (long)IntSizeKt.IntSize((int)((int)Math.ceil(multiParagraph.getWidth())), (int)((int)Math.ceil(multiParagraph.getHeight())))), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

