/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import androidx.compose.ui.text.android.LayoutCompatKt;
import androidx.compose.ui.text.android.TextLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/android/HorizontalPositionCache;", "", "layout", "Landroidx/compose/ui/text/android/TextLayout;", "(Landroidx/compose/ui/text/android/TextLayout;)V", "cachedKey", "", "cachedValue", "", "getLayout", "()Landroidx/compose/ui/text/android/TextLayout;", "get", "offset", "upstream", "", "cache", "primary", "getPrimaryDownstream", "getPrimaryUpstream", "getSecondaryDownstream", "getSecondaryUpstream", "ui-text_release"})
final class HorizontalPositionCache {
    @NotNull
    private final TextLayout layout;
    private int cachedKey;
    private float cachedValue;

    public HorizontalPositionCache(@NotNull TextLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout;
        this.cachedKey = -1;
    }

    @NotNull
    public final TextLayout getLayout() {
        return this.layout;
    }

    public final float getPrimaryDownstream(int offset) {
        return this.get(offset, false, false, true);
    }

    public final float getPrimaryUpstream(int offset) {
        return this.get(offset, true, true, true);
    }

    public final float getSecondaryDownstream(int offset) {
        return this.get(offset, false, false, false);
    }

    public final float getSecondaryUpstream(int offset) {
        return this.get(offset, true, true, false);
    }

    private final float get(int offset, boolean upstream, boolean cache, boolean primary) {
        float result2;
        boolean upstreamFinal;
        boolean bl;
        if (upstream) {
            int lineNo = LayoutCompatKt.getLineForOffset(this.layout.getLayout(), offset, upstream);
            int lineStart = this.layout.getLineStart(lineNo);
            int lineEnd = this.layout.getLineEnd(lineNo);
            bl = offset == lineStart || offset == lineEnd;
        } else {
            bl = upstreamFinal = false;
        }
        int tmpKey = offset * 4 + (primary ? (upstreamFinal ? 0 : 1) : (upstreamFinal ? 2 : 3));
        if (this.cachedKey == tmpKey) {
            return this.cachedValue;
        }
        float f = result2 = primary ? this.layout.getPrimaryHorizontal(offset, upstream) : this.layout.getSecondaryHorizontal(offset, upstream);
        if (cache) {
            this.cachedKey = tmpKey;
            this.cachedValue = result2;
        }
        return result2;
    }
}

