/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.PlatformTypefaces;
import androidx.compose.ui.text.font.PlatformTypefacesApi;
import androidx.compose.ui.text.font.PlatformTypefacesApi28;
import androidx.compose.ui.text.font.TypefaceCompatApi26;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u001a \u0010\u0007\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a8\u0006\r"}, d2={"PlatformTypefaces", "Landroidx/compose/ui/text/font/PlatformTypefaces;", "getWeightSuffixForFallbackFamilyName", "", "name", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "setFontVariationSettings", "Landroid/graphics/Typeface;", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "context", "Landroid/content/Context;", "ui-text_release"})
public final class PlatformTypefacesKt {
    @NotNull
    public static final PlatformTypefaces PlatformTypefaces() {
        return Build.VERSION.SDK_INT >= 28 ? (PlatformTypefaces)new PlatformTypefacesApi28() : (PlatformTypefaces)new PlatformTypefacesApi();
    }

    @ExperimentalTextApi
    @Nullable
    public static final Typeface setFontVariationSettings(@Nullable Typeface $this$setFontVariationSettings, @NotNull FontVariation.Settings variationSettings, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)variationSettings, (String)"variationSettings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 26 ? TypefaceCompatApi26.INSTANCE.setFontVariationSettings($this$setFontVariationSettings, variationSettings, context) : $this$setFontVariationSettings;
    }

    @VisibleForTesting
    @NotNull
    public static final String getWeightSuffixForFallbackFamilyName(@NotNull String name, @NotNull FontWeight fontWeight) {
        String string;
        block1: {
            int n;
            block4: {
                block3: {
                    block2: {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
                            n = fontWeight.getWeight() / 100;
                            boolean bl = 0 <= n ? n < 2 : false;
                            if (!bl) break block0;
                            string = name + "-thin";
                            break block1;
                        }
                        boolean bl = 2 <= n ? n < 4 : false;
                        if (!bl) break block2;
                        string = name + "-light";
                        break block1;
                    }
                    if (n != 4) break block3;
                    string = name;
                    break block1;
                }
                if (n != 5) break block4;
                string = name + "-medium";
                break block1;
            }
            string = (6 <= n ? n < 8 : false) ? name : ((8 <= n ? n < 11 : false) ? name + "-black" : name);
        }
        return string;
    }
}

