/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RestrictTo;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.InternalTextApi;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import androidx.compose.ui.text.font.AndroidFontUtils_androidKt;
import androidx.compose.ui.text.font.DelegatingFontLoaderForDeprecatedUsage_androidKt;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.platform.Api28Impl;
import androidx.compose.ui.text.platform.extensions.SpannableExtensions_androidKt;
import androidx.compose.ui.text.platform.extensions.TtsAnnotationExtensions_androidKt;
import androidx.compose.ui.text.platform.extensions.UrlAnnotationExtensions_androidKt;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\u0002*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u001c\u0010\f\u001a\u00020\u0002*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0010"}, d2={"setSpanStyle", "", "Landroid/text/SpannableString;", "spanStyle", "Landroidx/compose/ui/text/SpanStyle;", "start", "", "end", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "toAccessibilitySpannableString", "Landroidx/compose/ui/text/AnnotatedString;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "ui-text_release"})
public final class AndroidAccessibilitySpannableString_androidKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @InternalTextApi
    @NotNull
    public static final SpannableString toAccessibilitySpannableString(@NotNull AnnotatedString $this$toAccessibilitySpannableString, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)$this$toAccessibilitySpannableString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        return AndroidAccessibilitySpannableString_androidKt.toAccessibilitySpannableString($this$toAccessibilitySpannableString, density, DelegatingFontLoaderForDeprecatedUsage_androidKt.createFontFamilyResolver(resourceLoader));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @InternalTextApi
    @NotNull
    public static final SpannableString toAccessibilitySpannableString(@NotNull AnnotatedString $this$toAccessibilitySpannableString, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        int end;
        int start;
        AnnotatedString.Range<SpanStyle> range;
        AnnotatedString.Range<Object> item$iv;
        int index$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toAccessibilitySpannableString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        SpannableString spannableString = new SpannableString((CharSequence)$this$toAccessibilitySpannableString.getText());
        List<AnnotatedString.Range<Object>> $this$fastForEach$iv = $this$toAccessibilitySpannableString.getSpanStyles();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            range = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            SpanStyle style = range.component1();
            start = range.component2();
            end = range.component3();
            SpanStyle noFontStyle = SpanStyle.copy-IuqyXdg$default(style, 0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, 16351, null);
            AndroidAccessibilitySpannableString_androidKt.setSpanStyle(spannableString, noFontStyle, start, end, density, fontFamilyResolver);
        }
        $this$fastForEach$iv = $this$toAccessibilitySpannableString.getTtsAnnotations(0, $this$toAccessibilitySpannableString.length());
        $i$f$fastForEach = false;
        n = $this$fastForEach$iv.size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            range = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            TtsAnnotation ttsAnnotation = (TtsAnnotation)((Object)range.component1());
            start = range.component2();
            end = range.component3();
            spannableString.setSpan((Object)TtsAnnotationExtensions_androidKt.toSpan(ttsAnnotation), start, end, 33);
        }
        $this$fastForEach$iv = $this$toAccessibilitySpannableString.getUrlAnnotations(0, $this$toAccessibilitySpannableString.length());
        $i$f$fastForEach = false;
        n = $this$fastForEach$iv.size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            range = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            UrlAnnotation urlAnnotation = (UrlAnnotation)((Object)range.component1());
            start = range.component2();
            end = range.component3();
            spannableString.setSpan((Object)UrlAnnotationExtensions_androidKt.toSpan(urlAnnotation), start, end, 33);
        }
        return spannableString;
    }

    private static final void setSpanStyle(SpannableString $this$setSpanStyle, SpanStyle spanStyle, int start, int end, Density density, FontFamily.Resolver fontFamilyResolver) {
        SpannableExtensions_androidKt.setColor-RPmYEkk((Spannable)$this$setSpanStyle, spanStyle.getColor-0d7_KjU(), start, end);
        SpannableExtensions_androidKt.setFontSize-KmRG4DE((Spannable)$this$setSpanStyle, spanStyle.getFontSize-XSAIIZE(), density, start, end);
        if (spanStyle.getFontWeight() != null || spanStyle.getFontStyle-4Lr2A7w() != null) {
            FontWeight fontWeight = spanStyle.getFontWeight();
            if (fontWeight == null) {
                fontWeight = FontWeight.Companion.getNormal();
            }
            FontWeight fontWeight2 = fontWeight;
            FontStyle fontStyle = spanStyle.getFontStyle-4Lr2A7w();
            int fontStyle2 = fontStyle != null ? fontStyle.unbox-impl() : FontStyle.Companion.getNormal-_-LCdwA();
            $this$setSpanStyle.setSpan((Object)new StyleSpan(AndroidFontUtils_androidKt.getAndroidTypefaceStyle-FO1MlWM(fontWeight2, fontStyle2)), start, end, 33);
        }
        if (spanStyle.getFontFamily() != null) {
            if (spanStyle.getFontFamily() instanceof GenericFontFamily) {
                $this$setSpanStyle.setSpan((Object)new TypefaceSpan(((GenericFontFamily)spanStyle.getFontFamily()).getName()), start, end, 33);
            } else if (Build.VERSION.SDK_INT >= 28) {
                FontSynthesis fontSynthesis = spanStyle.getFontSynthesis-ZQGJjVo();
                Object object = FontFamily.Resolver.resolve-DPcqOEQ$default(fontFamilyResolver, spanStyle.getFontFamily(), null, 0, fontSynthesis != null ? fontSynthesis.unbox-impl() : FontSynthesis.Companion.getAll-GVVA2EU(), 6, null).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.graphics.Typeface");
                Typeface typeface2 = (Typeface)object;
                $this$setSpanStyle.setSpan((Object)Api28Impl.INSTANCE.createTypefaceSpan(typeface2), start, end, 33);
            }
        }
        if (spanStyle.getTextDecoration() != null) {
            if (spanStyle.getTextDecoration().contains(TextDecoration.Companion.getUnderline())) {
                $this$setSpanStyle.setSpan((Object)new UnderlineSpan(), start, end, 33);
            }
            if (spanStyle.getTextDecoration().contains(TextDecoration.Companion.getLineThrough())) {
                $this$setSpanStyle.setSpan((Object)new StrikethroughSpan(), start, end, 33);
            }
        }
        if (spanStyle.getTextGeometricTransform() != null) {
            $this$setSpanStyle.setSpan((Object)new ScaleXSpan(spanStyle.getTextGeometricTransform().getScaleX()), start, end, 33);
        }
        SpannableExtensions_androidKt.setLocaleList((Spannable)$this$setSpanStyle, spanStyle.getLocaleList(), start, end);
        SpannableExtensions_androidKt.setBackground-RPmYEkk((Spannable)$this$setSpanStyle, spanStyle.getBackground-0d7_KjU(), start, end);
    }
}

