/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform.extensions;

import android.graphics.Typeface;
import android.os.Build;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.intl.Locale;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.platform.AndroidTextPaint;
import androidx.compose.ui.text.platform.extensions.LocaleExtensions_androidKt;
import androidx.compose.ui.text.platform.extensions.LocaleListHelperMethods;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.text.style.TextMotion;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001aG\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042&\u0010\u0007\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00f8\u0001\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0004H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"correctBlurRadius", "", "blurRadius", "applySpanStyle", "Landroidx/compose/ui/text/SpanStyle;", "Landroidx/compose/ui/text/platform/AndroidTextPaint;", "style", "resolveTypeface", "Lkotlin/Function4;", "Landroidx/compose/ui/text/font/FontFamily;", "Landroidx/compose/ui/text/font/FontWeight;", "Landroidx/compose/ui/text/font/FontStyle;", "Landroidx/compose/ui/text/font/FontSynthesis;", "Landroid/graphics/Typeface;", "density", "Landroidx/compose/ui/unit/Density;", "hasFontAttributes", "", "setTextMotion", "", "textMotion", "Landroidx/compose/ui/text/style/TextMotion;", "ui-text_release"})
public final class TextPaintExtensions_androidKt {
    @NotNull
    public static final SpanStyle applySpanStyle(@NotNull AndroidTextPaint $this$applySpanStyle, @NotNull SpanStyle style, @NotNull Function4<? super FontFamily, ? super FontWeight, ? super FontStyle, ? super FontSynthesis, ? extends Typeface> resolveTypeface2, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applySpanStyle), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(resolveTypeface2, (String)"resolveTypeface");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        long l = TextUnit.getType-UIouoOA((long)style.getFontSize-XSAIIZE());
        if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getSp-UIouoOA())) {
            Density $this$applySpanStyle_u24lambda_u240 = density;
            boolean bl = false;
            $this$applySpanStyle.setTextSize($this$applySpanStyle_u24lambda_u240.toPx--R2X_6o(style.getFontSize-XSAIIZE()));
        } else if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getEm-UIouoOA())) {
            $this$applySpanStyle.setTextSize($this$applySpanStyle.getTextSize() * TextUnit.getValue-impl((long)style.getFontSize-XSAIIZE()));
        }
        if (TextPaintExtensions_androidKt.hasFontAttributes(style)) {
            FontFamily fontFamily = style.getFontFamily();
            FontWeight fontWeight = style.getFontWeight();
            if (fontWeight == null) {
                fontWeight = FontWeight.Companion.getNormal();
            }
            FontStyle fontStyle = style.getFontStyle-4Lr2A7w();
            FontSynthesis fontSynthesis = style.getFontSynthesis-ZQGJjVo();
            $this$applySpanStyle.setTypeface((Typeface)resolveTypeface2.invoke((Object)fontFamily, (Object)fontWeight, (Object)FontStyle.box-impl(fontStyle != null ? fontStyle.unbox-impl() : FontStyle.Companion.getNormal-_-LCdwA()), (Object)FontSynthesis.box-impl(fontSynthesis != null ? fontSynthesis.unbox-impl() : FontSynthesis.Companion.getAll-GVVA2EU())));
        }
        if (style.getLocaleList() != null && !Intrinsics.areEqual((Object)style.getLocaleList(), (Object)LocaleList.Companion.getCurrent())) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleListHelperMethods.INSTANCE.setTextLocales($this$applySpanStyle, style.getLocaleList());
            } else {
                Locale locale = style.getLocaleList().isEmpty() ? Locale.Companion.getCurrent() : style.getLocaleList().get(0);
                $this$applySpanStyle.setTextLocale(LocaleExtensions_androidKt.toJavaLocale(locale));
            }
        }
        if (TextUnitType.equals-impl0((long)(l = TextUnit.getType-UIouoOA((long)style.getLetterSpacing-XSAIIZE())), (long)TextUnitType.Companion.getEm-UIouoOA())) {
            $this$applySpanStyle.setLetterSpacing(TextUnit.getValue-impl((long)style.getLetterSpacing-XSAIIZE()));
        } else if (TextUnitType.equals-impl0((long)l, (long)TextUnitType.Companion.getSp-UIouoOA())) {
            // empty if block
        }
        if (style.getFontFeatureSettings() != null && !Intrinsics.areEqual((Object)style.getFontFeatureSettings(), (Object)"")) {
            $this$applySpanStyle.setFontFeatureSettings(style.getFontFeatureSettings());
        }
        if (style.getTextGeometricTransform() != null && !Intrinsics.areEqual((Object)style.getTextGeometricTransform(), (Object)TextGeometricTransform.Companion.getNone$ui_text_release())) {
            $this$applySpanStyle.setTextScaleX($this$applySpanStyle.getTextScaleX() * style.getTextGeometricTransform().getScaleX());
            $this$applySpanStyle.setTextSkewX($this$applySpanStyle.getTextSkewX() + style.getTextGeometricTransform().getSkewX());
        }
        $this$applySpanStyle.setColor-8_81llA(style.getColor-0d7_KjU());
        $this$applySpanStyle.setBrush-12SF9DM(style.getBrush(), Size.Companion.getUnspecified-NH-jbRc(), style.getAlpha());
        $this$applySpanStyle.setShadow(style.getShadow());
        $this$applySpanStyle.setTextDecoration(style.getTextDecoration());
        $this$applySpanStyle.setDrawStyle(style.getDrawStyle());
        l = TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)style.getLetterSpacing-XSAIIZE()), (long)TextUnitType.Companion.getSp-UIouoOA()) && !(TextUnit.getValue-impl((long)style.getLetterSpacing-XSAIIZE()) == 0.0f) ? style.getLetterSpacing-XSAIIZE() : TextUnit.Companion.getUnspecified-XSAIIZE();
        long l2 = Color.equals-impl0((long)style.getBackground-0d7_KjU(), (long)Color.Companion.getTransparent-0d7_KjU()) ? Color.Companion.getUnspecified-0d7_KjU() : style.getBackground-0d7_KjU();
        BaselineShift baselineShift = style.getBaselineShift-5SSeXJ0();
        float f = BaselineShift.Companion.getNone-y9eOQZs();
        BaselineShift baselineShift2 = baselineShift;
        BaselineShift baselineShift3 = (baselineShift2 == null ? false : BaselineShift.equals-impl0(baselineShift2.unbox-impl(), f)) ? null : style.getBaselineShift-5SSeXJ0();
        return new SpanStyle(0L, 0L, null, null, null, null, null, l, baselineShift3, null, null, l2, null, null, 13951, null);
    }

    public static final void setTextMotion(@NotNull AndroidTextPaint $this$setTextMotion, @Nullable TextMotion textMotion) {
        TextMotion finalTextMotion;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setTextMotion), (String)"<this>");
        TextMotion textMotion2 = textMotion;
        if (textMotion2 == null) {
            textMotion2 = TextMotion.Companion.getStatic();
        }
        $this$setTextMotion.setFlags((finalTextMotion = textMotion2).getSubpixelTextPositioning$ui_text_release() ? $this$setTextMotion.getFlags() | 0x80 : $this$setTextMotion.getFlags() & 0xFFFFFF7F);
        int n = finalTextMotion.getLinearity-4e0Vf04$ui_text_release();
        if (TextMotion.Linearity.equals-impl0(n, TextMotion.Linearity.Companion.getLinear-4e0Vf04())) {
            $this$setTextMotion.setFlags($this$setTextMotion.getFlags() | 0x40);
            $this$setTextMotion.setHinting(0);
        } else if (TextMotion.Linearity.equals-impl0(n, TextMotion.Linearity.Companion.getFontHinting-4e0Vf04())) {
            int cfr_ignored_0 = $this$setTextMotion.getFlags() & 0xFFFFFFBF;
            $this$setTextMotion.setHinting(1);
        } else if (TextMotion.Linearity.equals-impl0(n, TextMotion.Linearity.Companion.getNone-4e0Vf04())) {
            int cfr_ignored_1 = $this$setTextMotion.getFlags() & 0xFFFFFFBF;
            $this$setTextMotion.setHinting(0);
        } else {
            $this$setTextMotion.getFlags();
        }
    }

    public static final boolean hasFontAttributes(@NotNull SpanStyle $this$hasFontAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFontAttributes, (String)"<this>");
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle-4Lr2A7w() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    public static final float correctBlurRadius(float blurRadius) {
        return blurRadius == 0.0f ? Float.MIN_VALUE : blurRadius;
    }
}

