/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import androidx.compose.ui.text.android.PaintExtensionsKt;
import androidx.compose.ui.text.android.StaticLayoutFactory;
import androidx.compose.ui.text.android.TextAndroidCanvas;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.style.LineHeightStyleSpan;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a=\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a+\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0018\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\nH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"EmptyPair", "Lkotlin/Pair;", "", "SharedTextAndroidCanvas", "Landroidx/compose/ui/text/android/TextAndroidCanvas;", "getTextDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "textDirectionHeuristic", "getLastLineMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "Landroidx/compose/ui/text/android/TextLayout;", "textPaint", "Landroid/text/TextPaint;", "frameworkTextDir", "lineHeightSpans", "", "Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "(Landroidx/compose/ui/text/android/TextLayout;Landroid/text/TextPaint;Landroid/text/TextDirectionHeuristic;[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;)Lkotlin/Pair;", "getLineHeightPaddings", "(Landroidx/compose/ui/text/android/TextLayout;[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;)Lkotlin/Pair;", "getLineHeightSpans", "(Landroidx/compose/ui/text/android/TextLayout;)[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "getVerticalPaddings", "isLineEllipsized", "", "Landroid/text/Layout;", "lineIndex", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nTextLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayout.kt\nandroidx/compose/ui/text/android/TextLayoutKt\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,1035:1\n26#2:1036\n26#2:1037\n*S KotlinDebug\n*F\n+ 1 TextLayout.kt\nandroidx/compose/ui/text/android/TextLayoutKt\n*L\n1027#1:1036\n1031#1:1037\n*E\n"})
public final class TextLayoutKt {
    @NotNull
    private static final TextAndroidCanvas SharedTextAndroidCanvas = new TextAndroidCanvas();
    @NotNull
    private static final Pair<Integer, Integer> EmptyPair = new Pair((Object)0, (Object)0);

    @NotNull
    public static final TextDirectionHeuristic getTextDirectionHeuristic(int textDirectionHeuristic) {
        TextDirectionHeuristic textDirectionHeuristic2;
        switch (textDirectionHeuristic) {
            case 0: {
                TextDirectionHeuristic textDirectionHeuristic3 = TextDirectionHeuristics.LTR;
                textDirectionHeuristic2 = textDirectionHeuristic3;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic3, (String)"LTR");
                break;
            }
            case 5: {
                TextDirectionHeuristic textDirectionHeuristic4 = TextDirectionHeuristics.LOCALE;
                textDirectionHeuristic2 = textDirectionHeuristic4;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic4, (String)"LOCALE");
                break;
            }
            case 1: {
                TextDirectionHeuristic textDirectionHeuristic5 = TextDirectionHeuristics.RTL;
                textDirectionHeuristic2 = textDirectionHeuristic5;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic5, (String)"RTL");
                break;
            }
            case 3: {
                TextDirectionHeuristic textDirectionHeuristic6 = TextDirectionHeuristics.FIRSTSTRONG_RTL;
                textDirectionHeuristic2 = textDirectionHeuristic6;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic6, (String)"FIRSTSTRONG_RTL");
                break;
            }
            case 4: {
                TextDirectionHeuristic textDirectionHeuristic7 = TextDirectionHeuristics.ANYRTL_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic7;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic7, (String)"ANYRTL_LTR");
                break;
            }
            case 2: {
                TextDirectionHeuristic textDirectionHeuristic8 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic8;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic8, (String)"FIRSTSTRONG_LTR");
                break;
            }
            default: {
                TextDirectionHeuristic textDirectionHeuristic9 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic9;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic9, (String)"FIRSTSTRONG_LTR");
            }
        }
        return textDirectionHeuristic2;
    }

    private static final Pair<Integer, Integer> getVerticalPaddings(TextLayout $this$getVerticalPaddings) {
        Rect rect;
        int topPadding;
        if ($this$getVerticalPaddings.getIncludePadding() || $this$getVerticalPaddings.isFallbackLinespacingApplied$ui_text_release()) {
            return new Pair((Object)0, (Object)0);
        }
        TextPaint paint = $this$getVerticalPaddings.getLayout().getPaint();
        CharSequence text = $this$getVerticalPaddings.getLayout().getText();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"paint");
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        Rect firstLineTextBounds = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(0), $this$getVerticalPaddings.getLayout().getLineEnd(0));
        int ascent = $this$getVerticalPaddings.getLayout().getLineAscent(0);
        int n = topPadding = firstLineTextBounds.top < ascent ? ascent - firstLineTextBounds.top : $this$getVerticalPaddings.getLayout().getTopPadding();
        if ($this$getVerticalPaddings.getLineCount() == 1) {
            rect = firstLineTextBounds;
        } else {
            int line = $this$getVerticalPaddings.getLineCount() - 1;
            rect = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(line), $this$getVerticalPaddings.getLayout().getLineEnd(line));
        }
        Rect lastLineTextBounds = rect;
        int descent = $this$getVerticalPaddings.getLayout().getLineDescent($this$getVerticalPaddings.getLineCount() - 1);
        int bottomPadding = lastLineTextBounds.bottom > descent ? lastLineTextBounds.bottom - descent : $this$getVerticalPaddings.getLayout().getBottomPadding();
        return topPadding == 0 && bottomPadding == 0 ? EmptyPair : new Pair((Object)topPadding, (Object)bottomPadding);
    }

    private static final Pair<Integer, Integer> getLineHeightPaddings(TextLayout $this$getLineHeightPaddings, LineHeightStyleSpan[] lineHeightSpans) {
        int firstAscentDiff = 0;
        int lastDescentDiff = 0;
        for (LineHeightStyleSpan span : lineHeightSpans) {
            if (span.getFirstAscentDiff() < 0) {
                firstAscentDiff = Math.max(firstAscentDiff, Math.abs(span.getFirstAscentDiff()));
            }
            if (span.getLastDescentDiff() >= 0) continue;
            lastDescentDiff = Math.max(firstAscentDiff, Math.abs(span.getLastDescentDiff()));
        }
        return firstAscentDiff == 0 && lastDescentDiff == 0 ? EmptyPair : new Pair((Object)firstAscentDiff, (Object)lastDescentDiff);
    }

    private static final Pair<Paint.FontMetricsInt, Integer> getLastLineMetrics(TextLayout $this$getLastLineMetrics, TextPaint textPaint, TextDirectionHeuristic frameworkTextDir, LineHeightStyleSpan[] lineHeightSpans) {
        int lastLine = $this$getLastLineMetrics.getLineCount() - 1;
        if ($this$getLastLineMetrics.getLayout().getLineStart(lastLine) == $this$getLastLineMetrics.getLayout().getLineEnd(lastLine) && !(lineHeightSpans.length == 0)) {
            Paint.FontMetricsInt fontMetricsInt;
            SpannableString emptyText = new SpannableString((CharSequence)"\u200b");
            LineHeightStyleSpan lineHeightSpan = (LineHeightStyleSpan)ArraysKt.first((Object[])lineHeightSpans);
            LineHeightStyleSpan newLineHeightSpan = lineHeightSpan.copy$ui_text_release(0, emptyText.length(), lastLine != 0 && lineHeightSpan.getTrimLastLineBottom() ? false : lineHeightSpan.getTrimLastLineBottom());
            emptyText.setSpan((Object)newLineHeightSpan, 0, emptyText.length(), 33);
            StaticLayoutFactory staticLayoutFactory = StaticLayoutFactory.INSTANCE;
            int n = emptyText.length();
            boolean bl = $this$getLastLineMetrics.getIncludePadding();
            boolean bl2 = $this$getLastLineMetrics.getFallbackLineSpacing();
            StaticLayout tmpLayout = StaticLayoutFactory.create$default(staticLayoutFactory, (CharSequence)emptyText, 0, n, textPaint, Integer.MAX_VALUE, frameworkTextDir, null, 0, null, 0, 0.0f, 0.0f, 0, bl, bl2, 0, 0, 0, 0, null, null, 2072512, null);
            Paint.FontMetricsInt $this$getLastLineMetrics_u24lambda_u240 = fontMetricsInt = new Paint.FontMetricsInt();
            boolean bl3 = false;
            $this$getLastLineMetrics_u24lambda_u240.ascent = tmpLayout.getLineAscent(0);
            $this$getLastLineMetrics_u24lambda_u240.descent = tmpLayout.getLineDescent(0);
            $this$getLastLineMetrics_u24lambda_u240.top = tmpLayout.getLineTop(0);
            $this$getLastLineMetrics_u24lambda_u240.bottom = tmpLayout.getLineBottom(0);
            Paint.FontMetricsInt lastLineFontMetrics = fontMetricsInt;
            int lastLineExtra = lastLineFontMetrics.bottom - (int)$this$getLastLineMetrics.getLineHeight(lastLine);
            return new Pair((Object)lastLineFontMetrics, (Object)lastLineExtra);
        }
        return new Pair(null, (Object)0);
    }

    private static final LineHeightStyleSpan[] getLineHeightSpans(TextLayout $this$getLineHeightSpans) {
        if (!($this$getLineHeightSpans.getText() instanceof Spanned)) {
            boolean $i$f$emptyArray = false;
            return new LineHeightStyleSpan[0];
        }
        CharSequence charSequence = $this$getLineHeightSpans.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        LineHeightStyleSpan[] lineHeightStyleSpans = (LineHeightStyleSpan[])((Spanned)charSequence).getSpans(0, $this$getLineHeightSpans.getText().length(), LineHeightStyleSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)lineHeightStyleSpans, (String)"lineHeightStyleSpans");
        if (lineHeightStyleSpans.length == 0) {
            boolean $i$f$emptyArray = false;
            return new LineHeightStyleSpan[0];
        }
        return lineHeightStyleSpans;
    }

    public static final boolean isLineEllipsized(@NotNull Layout $this$isLineEllipsized, int lineIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$isLineEllipsized, (String)"<this>");
        return $this$isLineEllipsized.getEllipsisCount(lineIndex) > 0;
    }

    public static final /* synthetic */ Pair access$getVerticalPaddings(TextLayout $receiver) {
        return TextLayoutKt.getVerticalPaddings($receiver);
    }

    public static final /* synthetic */ LineHeightStyleSpan[] access$getLineHeightSpans(TextLayout $receiver) {
        return TextLayoutKt.getLineHeightSpans($receiver);
    }

    public static final /* synthetic */ Pair access$getLineHeightPaddings(TextLayout $receiver, LineHeightStyleSpan[] lineHeightSpans) {
        return TextLayoutKt.getLineHeightPaddings($receiver, lineHeightSpans);
    }

    public static final /* synthetic */ Pair access$getLastLineMetrics(TextLayout $receiver, TextPaint textPaint, TextDirectionHeuristic frameworkTextDir, LineHeightStyleSpan[] lineHeightSpans) {
        return TextLayoutKt.getLastLineMetrics($receiver, textPaint, frameworkTextDir, lineHeightSpans);
    }

    public static final /* synthetic */ TextAndroidCanvas access$getSharedTextAndroidCanvas$p() {
        return SharedTextAndroidCanvas;
    }
}

