/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.style;

import android.graphics.Paint;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.style.LineHeightStyleSpanKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/text/android/style/LineHeightSpan;", "Landroid/text/style/LineHeightSpan;", "lineHeight", "", "(F)V", "getLineHeight", "()F", "chooseHeight", "", "text", "", "start", "", "end", "spanstartVertical", "fontMetricsInt", "Landroid/graphics/Paint$FontMetricsInt;", "ui-text_release"})
@InternalPlatformTextApi
@StabilityInferred(parameters=0)
public final class LineHeightSpan
implements android.text.style.LineHeightSpan {
    private final float lineHeight;
    public static final int $stable;

    public LineHeightSpan(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public final float getLineHeight() {
        return this.lineHeight;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartVertical, int lineHeight, @NotNull Paint.FontMetricsInt fontMetricsInt) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fontMetricsInt, (String)"fontMetricsInt");
        int currentHeight = LineHeightStyleSpanKt.lineHeight(fontMetricsInt);
        if (currentHeight <= 0) {
            return;
        }
        int ceiledLineHeight = (int)Math.ceil(this.lineHeight);
        float ratio = (float)ceiledLineHeight * 1.0f / (float)currentHeight;
        fontMetricsInt.descent = (int)Math.ceil((double)fontMetricsInt.descent * (double)ratio);
        fontMetricsInt.ascent = fontMetricsInt.descent - ceiledLineHeight;
    }
}

